/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.common.Builder;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityClientImpl;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.Security;
import io.helidon.security.SecurityClient;
import io.helidon.security.SecurityContextImpl;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityRequestBuilder;
import java.util.concurrent.CompletionStage;

public class OutboundSecurityClientBuilder
extends SecurityRequestBuilder<OutboundSecurityClientBuilder>
implements Builder<SecurityClient<OutboundSecurityResponse>> {
    private final SecurityContextImpl context;
    private final Security security;
    private SecurityEnvironment outboundEnvironment;
    private EndpointConfig outboundEndpointConfig;

    OutboundSecurityClientBuilder(Security security, SecurityContextImpl context) {
        super(context);
        this.security = security;
        this.context = context;
    }

    public SecurityClient<OutboundSecurityResponse> build() {
        return new OutboundSecurityClientImpl(this.security, this.context, super.buildRequest(), super.getProviderName(), this.outboundEnvironment, this.outboundEndpointConfig);
    }

    public OutboundSecurityClientBuilder outboundEnvironment(SecurityEnvironment outboundEnvironment) {
        this.outboundEnvironment = outboundEnvironment;
        return this;
    }

    public OutboundSecurityClientBuilder outboundEnvironment(Builder<SecurityEnvironment> outboundEnvironment) {
        return this.outboundEnvironment((SecurityEnvironment)outboundEnvironment.build());
    }

    public OutboundSecurityClientBuilder outboundEndpointConfig(EndpointConfig outboundEndpointConfig) {
        this.outboundEndpointConfig = outboundEndpointConfig;
        return this;
    }

    public OutboundSecurityClientBuilder outboundEndpointConfig(Builder<EndpointConfig> outboundEndpointConfig) {
        return this.outboundEndpointConfig((EndpointConfig)outboundEndpointConfig.build());
    }

    public OutboundSecurityResponse get() {
        return (OutboundSecurityResponse)this.build().get();
    }

    public CompletionStage<OutboundSecurityResponse> submit() {
        return this.build().submit();
    }
}

