/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.AuditEvent;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.ProviderRequest;
import io.helidon.security.Security;
import io.helidon.security.SecurityClient;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityContextImpl;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityException;
import io.helidon.security.SecurityRequest;
import io.helidon.security.internal.SecurityAuditEvent;
import io.helidon.security.spi.OutboundSecurityProvider;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

final class OutboundSecurityClientImpl
implements SecurityClient<OutboundSecurityResponse> {
    private final Security security;
    private final SecurityContextImpl context;
    private final String providerName;
    private final ProviderRequest providerRequest;
    private final SecurityEnvironment outboundEnv;
    private final EndpointConfig outboundEpConfig;

    OutboundSecurityClientImpl(Security security, SecurityContextImpl context, SecurityRequest request, String providerName, SecurityEnvironment outboundEnvironment, EndpointConfig outboundEndpointConfig) {
        this.security = security;
        this.context = context;
        this.providerName = providerName;
        this.providerRequest = new ProviderRequest(context, request.getResources(), request.getRequestEntity(), request.getResponseEntity());
        this.outboundEnv = outboundEnvironment;
        this.outboundEpConfig = outboundEndpointConfig;
    }

    @Override
    public CompletionStage<OutboundSecurityResponse> submit() {
        OutboundSecurityProvider providerInstance = this.findProvider();
        if (null == providerInstance) {
            return CompletableFuture.completedFuture(OutboundSecurityResponse.empty());
        }
        return providerInstance.outboundSecurity(this.providerRequest, this.outboundEnv, this.outboundEpConfig).thenApply(response -> {
            if (response.getStatus().isSuccess()) {
                this.context.audit(SecurityAuditEvent.success("outbound.outbound", "Provider %s. Request %s. Subject %s").addParam(AuditEvent.AuditParam.plain("provider", providerInstance.getClass().getName())).addParam(AuditEvent.AuditParam.plain("request", this)).addParam(AuditEvent.AuditParam.plain("subject", this.context.getUser().orElse(SecurityContext.ANONYMOUS))));
            } else {
                this.context.audit(SecurityAuditEvent.failure("outbound.outbound", "Provider %s, Description %s, Request %s. Subject %s").addParam(AuditEvent.AuditParam.plain("provider", providerInstance.getClass().getName())).addParam(AuditEvent.AuditParam.plain("request", this)).addParam(AuditEvent.AuditParam.plain("message", response.getDescription().orElse(null))).addParam(AuditEvent.AuditParam.plain("exception", response.getThrowable().orElse(null))).addParam(AuditEvent.AuditParam.plain("subject", this.context.getUser().orElse(SecurityContext.ANONYMOUS))));
            }
            return response;
        }).exceptionally(e -> {
            this.context.audit(SecurityAuditEvent.error("outbound.outbound", "Provider %s, Description %s, Request %s. Subject %s").addParam(AuditEvent.AuditParam.plain("provider", providerInstance.getClass().getName())).addParam(AuditEvent.AuditParam.plain("request", this)).addParam(AuditEvent.AuditParam.plain("message", e.getMessage())).addParam(AuditEvent.AuditParam.plain("exception", e)).addParam(AuditEvent.AuditParam.plain("subject", this.context.getUser().orElse(SecurityContext.ANONYMOUS))));
            throw new SecurityException("Failed to process security", (Throwable)e);
        });
    }

    private OutboundSecurityProvider findProvider() {
        return this.security.resolveOutboundProvider(this.providerName).stream().filter(p -> p.isOutboundSupported(this.providerRequest, this.outboundEnv, this.outboundEpConfig)).findFirst().orElse(null);
    }
}

