/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.util.AbacSupport;
import java.util.Collection;

public class Principal
implements AbacSupport,
java.security.Principal {
    private final AbacSupport properties;
    private final String name;
    private final String id;

    private Principal(Builder builder) {
        this.name = builder.name;
        this.id = builder.id;
        AbacSupport.BasicAttributes container = new AbacSupport.BasicAttributes((AbacSupport)builder.properties);
        container.put("name", (Object)this.name);
        container.put("id", (Object)this.id);
        this.properties = container;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Principal create(String id) {
        return Principal.builder().id(id).build();
    }

    public Object getAttributeRaw(String key) {
        return this.properties.getAttributeRaw(key);
    }

    public Collection<String> getAttributeNames() {
        return this.properties.getAttributeNames();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String toString() {
        return "Principal{properties=" + this.properties + ", name='" + this.name + '\'' + ", id='" + this.id + '\'' + '}';
    }

    public static class Builder
    implements io.helidon.common.Builder<Principal> {
        private String name;
        private String id;
        private AbacSupport.BasicAttributes properties = new AbacSupport.BasicAttributes();

        private Builder() {
        }

        public Principal build() {
            return new Principal(this);
        }

        public Builder name(String name) {
            this.name = name;
            if (null == this.id) {
                this.id = name;
            }
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            if (null == this.name) {
                this.name = id;
            }
            return this;
        }

        private Builder attributes(AbacSupport attributes) {
            this.properties = new AbacSupport.BasicAttributes(attributes);
            return this;
        }

        public Builder addAttribute(String key, Object value) {
            if (null == value) {
                return this;
            }
            this.properties.put(key, value);
            return this;
        }
    }
}

