/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.config.Config;
import io.helidon.security.util.TokenHandler;

public final class QueryParamMapping {
    private final String queryParamName;
    private final TokenHandler tokenHandler;

    private QueryParamMapping(String queryParamName, TokenHandler tokenHandler) {
        this.queryParamName = queryParamName;
        this.tokenHandler = tokenHandler;
    }

    public static QueryParamMapping create(String queryParamName, TokenHandler tokenHandler) {
        return new QueryParamMapping(queryParamName, tokenHandler);
    }

    public static QueryParamMapping create(String queryParamName, String headerName) {
        return new QueryParamMapping(queryParamName, TokenHandler.forHeader((String)headerName));
    }

    public static QueryParamMapping from(Config config) {
        String name = config.get("name").asString();
        TokenHandler handler = (TokenHandler)config.as(TokenHandler.class);
        return QueryParamMapping.create(name, handler);
    }

    public String getQueryParamName() {
        return this.queryParamName;
    }

    public TokenHandler getTokenHandler() {
        return this.tokenHandler;
    }
}

