/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.common.Builder;
import io.helidon.security.Security;
import io.helidon.security.SecurityClient;
import io.helidon.security.SecurityContextImpl;
import io.helidon.security.SecurityRequest;
import io.helidon.security.SecurityRequestBuilder;
import io.helidon.security.SecurityResponse;
import java.util.concurrent.CompletionStage;

public class SecurityClientBuilder<T extends SecurityResponse>
extends SecurityRequestBuilder<SecurityClientBuilder<T>>
implements Builder<SecurityClient<T>> {
    private final SecurityContextImpl context;
    private final Security security;
    private final SecurityClientFactory<T> factory;

    SecurityClientBuilder(Security security, SecurityContextImpl context, SecurityClientFactory<T> factory) {
        super(context);
        this.security = security;
        this.context = context;
        this.factory = factory;
    }

    public SecurityClient<T> build() {
        return this.factory.create(this.security, this.context, super.buildRequest(), super.getProviderName());
    }

    public T get() {
        return this.build().get();
    }

    public CompletionStage<T> submit() {
        return this.build().submit();
    }

    @FunctionalInterface
    static interface SecurityClientFactory<U extends SecurityResponse> {
        public SecurityClient<U> create(Security var1, SecurityContextImpl var2, SecurityRequest var3, String var4);
    }
}

