/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.AuditEvent;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.AuthorizationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityClientBuilder;
import io.helidon.security.Principal;
import io.helidon.security.Security;
import io.helidon.security.SecurityClientBuilder;
import io.helidon.security.SecurityContextImpl;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityRequestBuilder;
import io.helidon.security.SecurityTime;
import io.helidon.security.Subject;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public interface SecurityContext {
    public static final Principal ANONYMOUS_PRINCIPAL = Principal.builder().name("<ANONYMOUS>").addAttribute("anonymous", true).build();
    public static final Subject ANONYMOUS = Subject.builder().principal(ANONYMOUS_PRINCIPAL).addAttribute("anonymous", true).build();

    public SecurityRequestBuilder securityRequestBuilder();

    public SecurityRequestBuilder securityRequestBuilder(SecurityEnvironment var1);

    public SecurityClientBuilder<AuthenticationResponse> atnClientBuilder();

    public AuthenticationResponse authenticate();

    public SecurityClientBuilder<AuthorizationResponse> atzClientBuilder();

    public OutboundSecurityClientBuilder outboundClientBuilder();

    public AuthorizationResponse authorize(Object ... var1);

    public boolean isAuthenticated();

    public void logout();

    public boolean isUserInRole(String var1, String var2);

    public ExecutorService getExecutorService();

    public boolean isUserInRole(String var1);

    public void audit(AuditEvent var1);

    public Optional<Subject> getService();

    default public Optional<Principal> getServicePrincipal() {
        return this.getService().map(Subject::getPrincipal);
    }

    default public String getServiceName() {
        return this.getServicePrincipal().map(Principal::getName).orElse(null);
    }

    public Optional<Subject> getUser();

    default public Optional<Principal> getUserPrincipal() {
        return this.getUser().map(Subject::getPrincipal);
    }

    default public String getUserName() {
        return this.getUserPrincipal().map(Principal::getName).orElse(null);
    }

    public void runAs(Subject var1, Runnable var2);

    public void runAs(String var1, Runnable var2);

    public SpanContext getTracingSpan();

    public Tracer getTracer();

    public String getId();

    public SecurityTime getServerTime();

    public SecurityEnvironment getEnv();

    default public void setEnv(io.helidon.common.Builder<SecurityEnvironment> envBuilder) {
        this.setEnv((SecurityEnvironment)envBuilder.build());
    }

    public void setEnv(SecurityEnvironment var1);

    public EndpointConfig getEndpointConfig();

    public void setEndpointConfig(EndpointConfig var1);

    default public void setEndpointConfig(io.helidon.common.Builder<EndpointConfig> epBuilder) {
        this.setEndpointConfig((EndpointConfig)epBuilder.build());
    }

    public boolean atzChecked();

    public static class Builder
    implements io.helidon.common.Builder<SecurityContext> {
        private final Security security;
        private String id;
        private Supplier<ExecutorService> executorServiceSupplier;
        private SecurityTime serverTime;
        private Tracer tracingTracer;
        private SpanContext tracingSpan;
        private SecurityEnvironment env;
        private EndpointConfig ec;

        Builder(Security security) {
            this.security = security;
            this.executorServiceSupplier = security.getExecutorService();
        }

        public SecurityContext build() {
            if (null == this.env) {
                this.env = SecurityEnvironment.builder(this.serverTime).build();
            }
            if (null == this.ec) {
                this.ec = EndpointConfig.builder().build();
            }
            return new SecurityContextImpl(this);
        }

        Security getSecurity() {
            return this.security;
        }

        String getId() {
            return this.id;
        }

        Supplier<ExecutorService> getExecutorServiceSupplier() {
            return this.executorServiceSupplier;
        }

        SecurityTime getServerTime() {
            return this.serverTime;
        }

        Tracer getTracingTracer() {
            return this.tracingTracer;
        }

        SpanContext getTracingSpan() {
            return this.tracingSpan;
        }

        SecurityEnvironment getEnv() {
            return this.env;
        }

        EndpointConfig getEc() {
            return this.ec;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder executorService(Supplier<ExecutorService> executorServiceSupplier) {
            this.executorServiceSupplier = executorServiceSupplier;
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorServiceSupplier = () -> executorService;
            return this;
        }

        public Builder serverTime(SecurityTime serverTime) {
            this.serverTime = serverTime;
            return this;
        }

        public Builder tracingTracer(Tracer tracingTracer) {
            this.tracingTracer = tracingTracer;
            return this;
        }

        public Builder tracingSpan(SpanContext tracingSpan) {
            this.tracingSpan = tracingSpan;
            return this;
        }

        public Builder env(SecurityEnvironment env) {
            this.env = env;
            return this;
        }

        public Builder endpointConfig(EndpointConfig ec) {
            this.ec = ec;
            return this;
        }
    }
}

