/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.common.CollectionsHelper;
import io.helidon.security.AuditEvent;
import io.helidon.security.AuthenticationClientImpl;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.AuthorizationClientImpl;
import io.helidon.security.AuthorizationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityClientBuilder;
import io.helidon.security.Role;
import io.helidon.security.Security;
import io.helidon.security.SecurityClientBuilder;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityRequestBuilder;
import io.helidon.security.SecurityTime;
import io.helidon.security.Subject;
import io.helidon.security.internal.SecurityAuditEvent;
import io.helidon.security.spi.AuthorizationProvider;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

final class SecurityContextImpl
implements SecurityContext {
    private final Security security;
    private final String tracingId;
    private final SpanContext requestSpan;
    private final Supplier<ExecutorService> executorService;
    private final Tracer securityTracer;
    private final SecurityTime serverTime;
    private final ReadWriteLock envLock = new ReentrantReadWriteLock();
    private final ReadWriteLock ecLock = new ReentrantReadWriteLock();
    private volatile SecurityEnvironment environment;
    private volatile EndpointConfig ec;
    private volatile Subject serviceSubject;
    private volatile Subject currentSubject;
    private volatile AtomicBoolean atzChecked = new AtomicBoolean(false);

    SecurityContextImpl(SecurityContext.Builder builder) {
        this.security = builder.getSecurity();
        this.tracingId = builder.getId();
        this.requestSpan = builder.getTracingSpan();
        this.executorService = builder.getExecutorServiceSupplier();
        this.securityTracer = builder.getTracingTracer();
        this.serverTime = builder.getServerTime();
        this.environment = builder.getEnv();
        this.ec = builder.getEc();
    }

    @Override
    public SpanContext getTracingSpan() {
        return this.requestSpan;
    }

    @Override
    public Tracer getTracer() {
        return this.securityTracer;
    }

    @Override
    public String getId() {
        return this.tracingId;
    }

    @Override
    public SecurityTime getServerTime() {
        return this.serverTime;
    }

    @Override
    public SecurityRequestBuilder securityRequestBuilder() {
        return this.securityRequestBuilder(this.getEnv());
    }

    @Override
    public SecurityRequestBuilder securityRequestBuilder(SecurityEnvironment environment) {
        return new SecurityRequestBuilder(this);
    }

    @Override
    public SecurityClientBuilder<AuthenticationResponse> atnClientBuilder() {
        return new SecurityClientBuilder<AuthenticationResponse>(this.security, this, AuthenticationClientImpl::new);
    }

    @Override
    public AuthenticationResponse authenticate() {
        return this.atnClientBuilder().get();
    }

    @Override
    public SecurityClientBuilder<AuthorizationResponse> atzClientBuilder() {
        this.atzChecked.set(true);
        return new SecurityClientBuilder<AuthorizationResponse>(this.security, this, AuthorizationClientImpl::new);
    }

    @Override
    public OutboundSecurityClientBuilder outboundClientBuilder() {
        return new OutboundSecurityClientBuilder(this.security, this);
    }

    @Override
    public boolean isAuthenticated() {
        return this.getUser().isPresent();
    }

    @Override
    public void logout() {
        this.currentSubject = ANONYMOUS;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService.get();
    }

    @Override
    public boolean isUserInRole(String role) {
        if (!this.isAuthenticated()) {
            return false;
        }
        Optional<AuthorizationProvider> authorizationProvider = this.security.getProviderSelectionPolicy().selectProvider(AuthorizationProvider.class);
        return authorizationProvider.map(provider -> provider.isUserInRole(this.currentSubject, role)).orElseGet(() -> this.getUser().map(Security::getRoles).orElse(CollectionsHelper.setOf()).stream().anyMatch(role::equals));
    }

    @Override
    public boolean isUserInRole(String role, String authorizerName) {
        return this.security.resolveAtzProvider(authorizerName).map(provider -> provider.isUserInRole(this.currentSubject, role)).orElse(false);
    }

    @Override
    public AuthorizationResponse authorize(Object ... resource) {
        this.atzChecked.set(true);
        SecurityClientBuilder<AuthorizationResponse> builder = this.atzClientBuilder();
        for (int i = 0; i < resource.length; ++i) {
            if (i == 0) {
                builder.object(resource[i]);
            }
            builder.object("object" + i, resource[i]);
        }
        return builder.get();
    }

    @Override
    public void audit(AuditEvent event) {
        this.security.audit(this.tracingId, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runAs(Subject subject, Runnable runnable) {
        this.audit(SecurityAuditEvent.info("security.runAs", "runAs(Subject,Runnable) invoked for %s").addParam(AuditEvent.AuditParam.plain("subject", subject)));
        Subject original = this.currentSubject;
        try {
            this.currentSubject = subject;
            runnable.run();
        }
        finally {
            this.currentSubject = original;
        }
    }

    @Override
    public void runAs(String role, Runnable runnable) {
        Subject currentSubject = this.currentSubject;
        Subject runAsSubject = Subject.builder().principal(currentSubject.getPrincipal()).addGrant(Role.create(role)).build();
        this.runAs(runAsSubject, runnable);
    }

    @Override
    public Optional<Subject> getService() {
        if (this.serviceSubject == ANONYMOUS) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.serviceSubject);
    }

    void setService(Subject serviceSubject) {
        Objects.requireNonNull(serviceSubject);
        this.serviceSubject = serviceSubject;
    }

    @Override
    public Optional<Subject> getUser() {
        if (this.currentSubject == ANONYMOUS) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.currentSubject);
    }

    void setUser(Subject subject) {
        Objects.requireNonNull(subject);
        this.currentSubject = subject;
    }

    @Override
    public EndpointConfig getEndpointConfig() {
        Lock lock = this.ecLock.readLock();
        try {
            lock.lock();
            EndpointConfig endpointConfig = this.ec;
            return endpointConfig;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void setEndpointConfig(EndpointConfig ec) {
        Lock lock = this.ecLock.writeLock();
        try {
            lock.lock();
            this.ec = ec;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public SecurityEnvironment getEnv() {
        Lock rl = this.envLock.readLock();
        try {
            rl.lock();
            SecurityEnvironment securityEnvironment = this.environment;
            return securityEnvironment;
        }
        finally {
            rl.unlock();
        }
    }

    @Override
    public void setEnv(SecurityEnvironment env) {
        Lock lock = this.envLock.writeLock();
        try {
            lock.lock();
            this.environment = env;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean atzChecked() {
        return this.atzChecked.get();
    }
}

