/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.common.Builder;
import io.helidon.common.CollectionsHelper;
import io.helidon.security.SecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class SecurityResponse {
    private final Map<String, List<String>> requestHeaders;
    private final Map<String, List<String>> responseHeaders;
    private final SecurityStatus status;
    private final String description;
    private final Throwable throwable;
    private final int statusCode;

    SecurityResponse(SecurityResponseBuilder<? extends SecurityResponseBuilder<?, ?>, ?> builder) {
        this.status = ((SecurityResponseBuilder)builder).status;
        this.description = ((SecurityResponseBuilder)builder).description;
        this.throwable = ((SecurityResponseBuilder)builder).throwable;
        this.requestHeaders = ((SecurityResponseBuilder)builder).requestHeaders;
        this.responseHeaders = ((SecurityResponseBuilder)builder).responseHeaders;
        this.statusCode = ((SecurityResponseBuilder)builder).statusCode;
    }

    static <T> T get(CompletionStage<T> stage) {
        try {
            return stage.toCompletableFuture().get(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new SecurityException("Interrupted while waiting for completion stage to complete", e);
        }
        catch (ExecutionException e) {
            throw new SecurityException("Failure while executing asynchronous security", e);
        }
        catch (TimeoutException e) {
            throw new SecurityException("Timed out after waiting for completion stage to complete", e);
        }
    }

    public SecurityStatus getStatus() {
        return this.status;
    }

    public OptionalInt getStatusCode() {
        return this.statusCode == -1 ? OptionalInt.empty() : OptionalInt.of(this.statusCode);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<Throwable> getThrowable() {
        return Optional.ofNullable(this.throwable);
    }

    public Map<String, List<String>> getRequestHeaders() {
        return this.requestHeaders;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String toString() {
        return "SecurityResponse{status=" + (Object)((Object)this.status) + ", description='" + this.description + '\'' + ", statusCode=" + this.statusCode + '}';
    }

    static abstract class SecurityResponseBuilder<T extends SecurityResponseBuilder<T, B>, B>
    implements Builder<B> {
        private final Map<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
        private final Map<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        private final T myInstance;
        private SecurityStatus status = SecurityStatus.SUCCESS;
        private String description;
        private Throwable throwable;
        private int statusCode = -1;

        SecurityResponseBuilder() {
            this.myInstance = this;
        }

        public T statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this.myInstance;
        }

        public T status(SecurityStatus status) {
            this.status = status;
            return this.myInstance;
        }

        public T description(String description) {
            this.description = description;
            return this.myInstance;
        }

        public T throwable(Throwable exception) {
            this.throwable = exception;
            return this.myInstance;
        }

        public T requestHeaders(Map<String, List<String>> headers) {
            this.requestHeaders.clear();
            this.requestHeaders.putAll(headers);
            return this.myInstance;
        }

        public T requestHeader(String header, String value) {
            this.requestHeaders.put(header, CollectionsHelper.listOf((Object[])new String[]{value}));
            return this.myInstance;
        }

        public T requestHeader(String header, List<String> values) {
            this.requestHeaders.put(header, values);
            return this.myInstance;
        }

        public T responseHeaders(Map<String, List<String>> headers) {
            this.responseHeaders.clear();
            this.responseHeaders.putAll(headers);
            return this.myInstance;
        }

        public T responseHeader(String header, String value) {
            this.responseHeaders.put(header, CollectionsHelper.listOf((Object[])new String[]{value}));
            return this.myInstance;
        }

        public T responseHeader(String header, List<String> values) {
            this.responseHeaders.put(header, values);
            return this.myInstance;
        }
    }

    public static enum SecurityStatus {
        SUCCESS(true),
        SUCCESS_FINISH(true),
        FAILURE,
        FAILURE_FINISH,
        ABSTAIN;

        private final boolean success;

        private SecurityStatus() {
            this(false);
        }

        private SecurityStatus(boolean success) {
            this.success = success;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

