/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.config.Config;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;

public class SecurityTime {
    private final long shiftSeconds;
    private final ZoneId timeZone;
    private final List<ChronoValues> chronoValues = new ArrayList<ChronoValues>();

    private SecurityTime(Builder builder) {
        this.shiftSeconds = builder.shiftBySeconds;
        this.timeZone = builder.timeZone;
        this.chronoValues.addAll(builder.values);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SecurityTime create() {
        return SecurityTime.builder().build();
    }

    public static SecurityTime from(Config config) {
        return SecurityTime.builder().fromConfig(config).build();
    }

    public ZonedDateTime get() {
        ZonedDateTime zdt = ZonedDateTime.now();
        zdt = zdt.withZoneSameInstant(this.timeZone);
        zdt = zdt.plus(this.shiftSeconds, ChronoUnit.SECONDS);
        for (ChronoValues chronoValues : this.chronoValues) {
            zdt = zdt.with(chronoValues.field, chronoValues.value);
        }
        return zdt;
    }

    private static final class ChronoValues {
        private final ChronoField field;
        private final long value;

        private ChronoValues(ChronoField field, long delta) {
            this.field = field;
            this.value = delta;
        }
    }

    public static class Builder
    implements io.helidon.common.Builder<SecurityTime> {
        private ZoneId timeZone = ZoneId.systemDefault();
        private long shiftBySeconds = 0L;
        private List<ChronoValues> values = new ArrayList<ChronoValues>();

        private Builder() {
        }

        public SecurityTime build() {
            return new SecurityTime(this);
        }

        public Builder timeZone(ZoneId zoneId) {
            this.timeZone = zoneId;
            return this;
        }

        public Builder shiftBySeconds(long seconds) {
            this.shiftBySeconds = seconds;
            return this;
        }

        public Builder value(ChronoField field, long value) {
            this.values.add(new ChronoValues(field, value));
            return this;
        }

        public Builder fromConfig(Config config) {
            config.get("time-zone").asOptionalString().map(ZoneId::of).ifPresent(this::timeZone);
            config.get("shift-by-seconds").asOptionalLong().ifPresent(this::shiftBySeconds);
            config.get("year").asOptionalLong().ifPresent(it -> this.value(ChronoField.YEAR, it));
            config.get("month").asOptionalLong().ifPresent(it -> this.value(ChronoField.MONTH_OF_YEAR, it));
            config.get("day-of-month").asOptionalLong().ifPresent(it -> this.value(ChronoField.DAY_OF_MONTH, it));
            config.get("hour-of-day").asOptionalLong().ifPresent(it -> this.value(ChronoField.HOUR_OF_DAY, it));
            config.get("minute").asOptionalLong().ifPresent(it -> this.value(ChronoField.MINUTE_OF_HOUR, it));
            config.get("second").asOptionalLong().ifPresent(it -> this.value(ChronoField.SECOND_OF_MINUTE, it));
            config.get("millisecond").asOptionalLong().ifPresent(it -> this.value(ChronoField.MILLI_OF_SECOND, it));
            return this;
        }
    }
}

