/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.config.Config;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class ThreadPoolSupplier
implements Supplier<ExecutorService> {
    private static final int EXECUTOR_DEFAULT_CORE_POOL_SIZE = 10;
    private static final int EXECUTOR_DEFAULT_MAX_POOL_SIZE = 50;
    private static final int EXECUTOR_DEFAULT_KEEP_ALIVE_MINUTES = 3;
    private static final int EXECUTOR_DEFAULT_QUEUE_CAPACITY = 10000;
    private static final boolean EXECUTOR_DEFAULT_IS_DAEMON = true;
    private static final String EXECUTOR_DEFAULT_THREAD_NAME_PREFIX = "security-";
    private static final boolean EXECUTOR_DEFAULT_PRESTART = true;
    private final int corePoolSize;
    private final int maxPoolSize;
    private final int keepAliveMinutes;
    private final int queueCapacity;
    private final boolean isDaemon;
    private final String threadNamePrefix;
    private final boolean prestart;
    private volatile ThreadPoolExecutor instance;

    private ThreadPoolSupplier(Builder builder) {
        this.corePoolSize = builder.corePoolSize;
        this.maxPoolSize = builder.maxPoolSize;
        this.keepAliveMinutes = builder.keepAliveMinutes;
        this.queueCapacity = builder.queueCapacity;
        this.isDaemon = builder.isDaemon;
        this.threadNamePrefix = builder.threadNamePrefix;
        this.prestart = builder.prestart;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ThreadPoolSupplier from(Config config) {
        return ThreadPoolSupplier.builder().fromConfig(config.get("security.environment.executor-service")).build();
    }

    @Override
    public synchronized ThreadPoolExecutor get() {
        if (null == this.instance) {
            this.instance = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, (long)this.keepAliveMinutes, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(this.queueCapacity), new ThreadFactory(){
                private AtomicInteger value = new AtomicInteger();

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(null, r, ThreadPoolSupplier.this.threadNamePrefix + this.value.incrementAndGet());
                    t.setDaemon(ThreadPoolSupplier.this.isDaemon);
                    return t;
                }
            });
            if (this.prestart) {
                this.instance.prestartAllCoreThreads();
            }
        }
        return this.instance;
    }

    public static class Builder
    implements io.helidon.common.Builder<ThreadPoolSupplier> {
        private int corePoolSize = 10;
        private int maxPoolSize = 50;
        private int keepAliveMinutes = 3;
        private int queueCapacity = 10000;
        private boolean isDaemon = true;
        private String threadNamePrefix = "security-";
        private boolean prestart = true;

        public ThreadPoolSupplier build() {
            return new ThreadPoolSupplier(this);
        }

        public Builder corePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public Builder maxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return this;
        }

        public Builder keepAliveMinutes(int keepAliveMinutes) {
            this.keepAliveMinutes = keepAliveMinutes;
            return this;
        }

        public Builder queueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
            return this;
        }

        public Builder daemon(boolean daemon) {
            this.isDaemon = daemon;
            return this;
        }

        public Builder threadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
            return this;
        }

        public Builder prestart(boolean prestart) {
            this.prestart = prestart;
            return this;
        }

        public Builder fromConfig(Config config) {
            config = config.get("security.environment.executor-service");
            config.get("core-pool-size").asOptionalInt().ifPresent(this::corePoolSize);
            config.get("max-pool-size").asOptionalInt().ifPresent(this::maxPoolSize);
            config.get("keep-alive-minutes").asOptionalInt().ifPresent(this::keepAliveMinutes);
            config.get("queue-capacity").asOptionalInt().ifPresent(this::queueCapacity);
            config.get("is-daemon").asOptional(Boolean.class).ifPresent(this::daemon);
            config.get("thread-name-prefix").value().ifPresent(this::threadNamePrefix);
            config.get("should-prestart").asOptional(Boolean.class).ifPresent(this::prestart);
            return this;
        }
    }
}

