/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.spi;

import io.helidon.security.AuthenticationResponse;
import io.helidon.security.AuthorizationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.ProviderRequest;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.spi.SecurityProvider;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public abstract class SynchronousProvider
implements SecurityProvider {
    public final CompletionStage<AuthenticationResponse> authenticate(ProviderRequest providerRequest) {
        return CompletableFuture.supplyAsync(() -> this.syncAuthenticate(providerRequest), providerRequest.getContext().getExecutorService());
    }

    public final CompletionStage<AuthorizationResponse> authorize(ProviderRequest providerRequest) {
        return CompletableFuture.supplyAsync(() -> this.syncAuthorize(providerRequest), providerRequest.getContext().getExecutorService());
    }

    public final CompletionStage<OutboundSecurityResponse> outboundSecurity(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
        return CompletableFuture.supplyAsync(() -> this.syncOutbound(providerRequest, outboundEnv, outboundConfig), providerRequest.getContext().getExecutorService());
    }

    protected AuthenticationResponse syncAuthenticate(ProviderRequest providerRequest) {
        throw new UnsupportedOperationException("You must override syncAuthenticate method in your provider implementation to act as an AuthenticationProvider");
    }

    protected AuthorizationResponse syncAuthorize(ProviderRequest providerRequest) {
        throw new UnsupportedOperationException("You must override syncAuthorize method in your provider implementation to act as an AuthorizationProvider");
    }

    protected OutboundSecurityResponse syncOutbound(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundEndpointConfig) {
        throw new UnsupportedOperationException("You must override syncOutbound method in your provider implementation to act as an OutboundProvider");
    }
}

