/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;

public interface NettyNative {
    public EventLoopGroup group(String var1, int var2);

    public Class<? extends ServerSocketChannel> channel();

    public static NettyNative get(ClassLoader loader) {
        try {
            loader.loadClass("io.netty.channel.epoll.Epoll");
            return NettyNative.epollOrNio();
        }
        catch (ClassNotFoundException x) {
            return NettyNative.nio();
        }
    }

    public static NettyNative epollOrNio() {
        if (Epoll.isAvailable()) {
            return new NettyNative(){

                @Override
                public EventLoopGroup group(String name, int threads) {
                    return new EpollEventLoopGroup(threads, (ThreadFactory)new DefaultThreadFactory(name + "-epoll"));
                }

                @Override
                public Class<? extends ServerSocketChannel> channel() {
                    return EpollServerSocketChannel.class;
                }
            };
        }
        return NettyNative.nio();
    }

    public static NettyNative nio() {
        return new NettyNative(){

            @Override
            public EventLoopGroup group(String name, int threads) {
                return new NioEventLoopGroup(threads, (ThreadFactory)new DefaultThreadFactory(name + "-nio"));
            }

            @Override
            public Class<? extends ServerSocketChannel> channel() {
                return NioServerSocketChannel.class;
            }
        };
    }
}

