/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.netty;

import io.jooby.Jooby;
import io.jooby.Router;
import io.jooby.Server;
import io.jooby.internal.netty.DefaultHeaders;
import io.jooby.internal.netty.NettyNative;
import io.jooby.internal.netty.NettyPipeline;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class Netty
extends Server.Base {
    private List<Jooby> applications = new ArrayList<Jooby>();
    private EventLoopGroup acceptor;
    private EventLoopGroup ioLoop;
    private int port = 8080;
    private boolean gzip;
    private long maxRequestSize = 0x1400000L;
    private DefaultEventExecutorGroup worker;
    private int bufferSize = 16384;
    private int processors = Math.max(Runtime.getRuntime().availableProcessors(), 1);
    private int parallelism = Math.max(2, this.processors);
    private int acceptorThreads = this.processors;
    private int ioThreads = this.parallelism * 2;
    private int workerThreads = this.parallelism * 8;
    private boolean defaultHeaders = true;

    public Server port(int port) {
        this.port = port;
        return this;
    }

    @Nonnull
    public Server defaultHeaders(boolean value) {
        this.defaultHeaders = value;
        return this;
    }

    @Nonnull
    public Server maxRequestSize(long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
        return this;
    }

    @Nonnull
    public Server bufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public Server gzip(boolean enabled) {
        this.gzip = enabled;
        return this;
    }

    public int port() {
        return this.port;
    }

    public Server workerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
        return this;
    }

    @Nonnull
    public Server start(Jooby application) {
        try {
            this.applications.add(application);
            this.addShutdownHook();
            this.worker = new DefaultEventExecutorGroup(this.workerThreads, (ThreadFactory)new DefaultThreadFactory("netty-worker"));
            this.fireStart(this.applications, (Executor)this.worker);
            if (this.applications.size() == 1) {
                String tmpdir;
                DiskFileUpload.baseDirectory = tmpdir = this.applications.get(0).tmpdir().toString();
                DiskAttribute.baseDirectory = tmpdir;
            } else {
                DiskFileUpload.baseDirectory = null;
                DiskAttribute.baseDirectory = null;
            }
            NettyNative provider = NettyNative.get(((Object)((Object)this)).getClass().getClassLoader());
            this.acceptor = provider.group("netty-acceptor", this.acceptorThreads);
            this.ioLoop = provider.group("netty", this.ioThreads);
            DefaultHttpDataFactory factory = new DefaultHttpDataFactory((long)this.bufferSize);
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)8192);
            bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
            DefaultHeaders defaultHeaders = this.defaultHeaders ? Netty.defaultHeaders((ScheduledExecutorService)this.acceptor.next()) : Netty.defaultResponseType();
            ((ServerBootstrap)bootstrap.group(this.acceptor, this.ioLoop).channel(provider.channel())).childHandler((ChannelHandler)new NettyPipeline((Router)this.applications.get(0), (HttpDataFactory)factory, defaultHeaders, this.gzip, this.bufferSize, this.maxRequestSize)).childOption(ChannelOption.SO_REUSEADDR, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true);
            bootstrap.bind(this.port).sync();
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
        this.fireReady(this.applications);
        return this;
    }

    public Server stop() {
        this.fireStop(this.applications);
        this.applications = null;
        if (this.ioLoop != null) {
            this.ioLoop.shutdownGracefully();
            this.ioLoop = null;
        }
        if (this.acceptor != null) {
            this.acceptor.shutdownGracefully();
            this.acceptor = null;
        }
        if (this.worker != null) {
            this.worker.shutdownGracefully();
            this.worker = null;
        }
        return this;
    }

    private static DefaultHeaders defaultHeaders(ScheduledExecutorService executor) {
        DefaultHeaders headers = new DefaultHeaders();
        executor.scheduleWithFixedDelay(headers, 1000L, 1000L, TimeUnit.MILLISECONDS);
        return headers;
    }

    private static Consumer<HttpHeaders> defaultResponseType() {
        return headers -> headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN);
    }
}

