/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import java.io.InputStream;

public class ChunkedLimitedStream
implements ChunkedInput<ByteBuf> {
    private final InputStream in;
    private final int chunkSize;
    private final long length;
    private long offset;
    private boolean closed;

    public ChunkedLimitedStream(InputStream in, int chunkSize, long length) {
        this.in = in;
        this.chunkSize = chunkSize;
        this.length = length;
    }

    public boolean isEndOfInput() {
        if (this.closed) {
            return true;
        }
        return this.offset >= this.length;
    }

    public void close() throws Exception {
        this.closed = true;
        this.in.close();
    }

    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
        if (this.isEndOfInput()) {
            return null;
        }
        long next = this.offset + (long)this.chunkSize;
        int chunkSize = next < this.length ? this.chunkSize : (int)(this.length - this.offset);
        boolean release = true;
        ByteBuf buffer = allocator.buffer(chunkSize);
        try {
            this.offset += (long)buffer.writeBytes(this.in, chunkSize);
            release = false;
            ByteBuf byteBuf = buffer;
            return byteBuf;
        }
        finally {
            if (release) {
                buffer.release();
            }
        }
    }

    public long length() {
        return this.length;
    }

    public long progress() {
        return this.offset;
    }
}

