/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.jooby.AttributeMap;
import io.jooby.Body;
import io.jooby.ByteRange;
import io.jooby.Context;
import io.jooby.FileUpload;
import io.jooby.Formdata;
import io.jooby.MediaType;
import io.jooby.Multipart;
import io.jooby.QueryString;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.Sender;
import io.jooby.Server;
import io.jooby.StatusCode;
import io.jooby.Throwing;
import io.jooby.Value;
import io.jooby.internal.netty.ChunkedLimitedStream;
import io.jooby.internal.netty.NettyBody;
import io.jooby.internal.netty.NettyFileUpload;
import io.jooby.internal.netty.NettyOutputStream;
import io.jooby.internal.netty.NettySender;
import io.jooby.internal.netty.NettyWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public class NettyContext
implements Context,
ChannelFutureListener {
    private static final HttpHeaders NO_TRAILING = new DefaultHttpHeaders(false);
    final HttpHeaders setHeaders = new DefaultHttpHeaders(false);
    private final int bufferSize;
    InterfaceHttpPostRequestDecoder decoder;
    private Router router;
    private Route route;
    private ChannelHandlerContext ctx;
    private HttpRequest req;
    private String path;
    private HttpResponseStatus status = HttpResponseStatus.OK;
    private boolean responseStarted;
    private QueryString query;
    private Formdata form;
    private Multipart multipart;
    private List<FileUpload> files;
    private Value.Object headers;
    private Map<String, String> pathMap = Collections.EMPTY_MAP;
    private MediaType responseType;
    private AttributeMap attributes = new AttributeMap();

    public NettyContext(ChannelHandlerContext ctx, HttpRequest req, Router router, String path, int bufferSize) {
        this.path = path;
        this.ctx = ctx;
        this.req = req;
        this.router = router;
        this.bufferSize = bufferSize;
    }

    @Nonnull
    public Router router() {
        return this.router;
    }

    public String name() {
        return "netty";
    }

    @Nonnull
    public AttributeMap attributes() {
        return this.attributes;
    }

    @Nonnull
    public String method() {
        return this.req.method().asciiName().toUpperCase().toString();
    }

    @Nonnull
    public Route route() {
        return this.route;
    }

    @Nonnull
    public Context route(@Nonnull Route route) {
        this.route = route;
        return this;
    }

    @Nonnull
    public final String pathString() {
        return this.path;
    }

    @Nonnull
    public Map<String, String> pathMap() {
        return this.pathMap;
    }

    @Nonnull
    public Context setPathMap(@Nonnull Map<String, String> pathMap) {
        this.pathMap = pathMap;
        return this;
    }

    public final boolean isInIoThread() {
        return this.ctx.channel().eventLoop().inEventLoop();
    }

    @Nonnull
    public Context dispatch(@Nonnull Runnable action) {
        return this.dispatch(this.router.worker(), action);
    }

    public Context dispatch(Executor executor, Runnable action) {
        executor.execute(action);
        return this;
    }

    @Nonnull
    public Context detach(@Nonnull Runnable action) {
        action.run();
        return this;
    }

    @Nonnull
    public QueryString query() {
        if (this.query == null) {
            this.query = Value.queryString((String)this.req.uri());
        }
        return this.query;
    }

    @Nonnull
    public Formdata form() {
        if (this.form == null) {
            this.form = new Formdata();
            this.decodeForm(this.req, (Value.Object)this.form);
        }
        return this.form;
    }

    @Nonnull
    public Multipart multipart() {
        if (this.multipart == null) {
            this.multipart = new Multipart();
            this.form = this.multipart;
            this.decodeForm(this.req, (Value.Object)this.multipart);
        }
        return this.multipart;
    }

    @Nonnull
    public Value header(@Nonnull String name) {
        return Value.create((String)name, (List)this.req.headers().getAll(name));
    }

    @Nonnull
    public String remoteAddress() {
        InetSocketAddress remoteAddress = (InetSocketAddress)this.ctx.channel().remoteAddress();
        return remoteAddress.getAddress().getHostAddress();
    }

    @Nonnull
    public String protocol() {
        return this.req.protocolVersion().text();
    }

    @Nonnull
    public Value headers() {
        if (this.headers == null) {
            this.headers = Value.headers();
            HttpHeaders headers = this.req.headers();
            Set names = headers.names();
            for (String name : names) {
                this.headers.put(name, (Collection)headers.getAll(name));
            }
        }
        return this.headers;
    }

    @Nonnull
    public Body body() {
        if (this.decoder != null && this.decoder.hasNext()) {
            return new NettyBody((HttpData)this.decoder.next(), HttpUtil.getContentLength((HttpMessage)this.req, (long)-1L));
        }
        return Body.empty();
    }

    @Nonnull
    public StatusCode statusCode() {
        return StatusCode.valueOf((int)this.status.code());
    }

    @Nonnull
    public Context statusCode(int statusCode) {
        this.status = HttpResponseStatus.valueOf((int)statusCode);
        return this;
    }

    @Nonnull
    public Context setHeader(@Nonnull String name, @Nonnull String value) {
        this.setHeaders.set(name, (Object)value);
        return this;
    }

    @Nonnull
    public MediaType responseContentType() {
        return this.responseType == null ? MediaType.text : this.responseType;
    }

    @Nonnull
    public Context setDefaultContentType(@Nonnull MediaType contentType) {
        if (this.responseType == null) {
            this.setContentType(contentType, contentType.charset());
        }
        return this;
    }

    public final Context setContentType(MediaType contentType, Charset charset) {
        this.responseType = contentType;
        this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType.toContentTypeHeader(charset));
        return this;
    }

    @Nonnull
    public Context setContentLength(long length) {
        this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)length);
        return this;
    }

    @Nonnull
    public PrintWriter responseWriter(MediaType type, Charset charset) {
        this.setContentType(type, charset);
        return new PrintWriter(new NettyWriter(this.newOutputStream(), charset));
    }

    @Nonnull
    public Sender responseSender() {
        this.responseStarted = true;
        this.prepareChunked();
        this.ctx.write((Object)new DefaultHttpResponse(this.req.protocolVersion(), this.status, this.setHeaders));
        return new NettySender(this, this.ctx);
    }

    @Nonnull
    public OutputStream responseStream() {
        return this.newOutputStream();
    }

    @Nonnull
    public Context sendString(@Nonnull String data) {
        return this.sendBytes(Unpooled.copiedBuffer((CharSequence)data, (Charset)StandardCharsets.UTF_8));
    }

    public final Context sendString(String data, Charset charset) {
        return this.sendBytes(Unpooled.copiedBuffer((CharSequence)data, (Charset)charset));
    }

    public final Context sendBytes(byte[] data) {
        return this.sendBytes(Unpooled.wrappedBuffer((byte[])data));
    }

    public final Context sendBytes(ByteBuffer data) {
        return this.sendBytes(Unpooled.wrappedBuffer((ByteBuffer)data));
    }

    @Nonnull
    public Context sendBytes(@Nonnull ByteBuf data) {
        this.responseStarted = true;
        this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)data.readableBytes());
        this.ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.status, data, this.setHeaders, NO_TRAILING)).addListener((GenericFutureListener)this);
        return this;
    }

    @Nonnull
    public Context sendStream(@Nonnull InputStream in) {
        if (in instanceof FileInputStream) {
            return this.sendFile(((FileInputStream)in).getChannel());
        }
        try {
            Object chunkedStream;
            this.prepareChunked();
            long len = this.responseLength();
            if (len > 0L) {
                ByteRange range = ByteRange.parse((String)this.req.headers().get((CharSequence)HttpHeaderNames.RANGE)).apply((Context)this, len);
                in.skip(range.start);
                chunkedStream = new ChunkedLimitedStream(in, this.bufferSize, range.end);
            } else {
                chunkedStream = new ChunkedStream(in, this.bufferSize);
            }
            DefaultHttpResponse rsp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, this.status, this.setHeaders);
            this.responseStarted = true;
            this.ctx.channel().eventLoop().execute(() -> this.lambda$sendStream$0(rsp, (ChunkedInput)chunkedStream));
            return this;
        }
        catch (Exception x) {
            throw Throwing.sneakyThrow((Throwable)x);
        }
    }

    @Nonnull
    public Context sendFile(@Nonnull FileChannel file) {
        try {
            long len = file.size();
            this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)len);
            ByteRange range = ByteRange.parse((String)this.req.headers().get((CharSequence)HttpHeaderNames.RANGE)).apply((Context)this, len);
            DefaultHttpResponse rsp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, this.status, this.setHeaders);
            this.responseStarted = true;
            this.ctx.channel().eventLoop().execute(() -> {
                this.ctx.write((Object)rsp);
                this.ctx.write((Object)new DefaultFileRegion(file, range.start, range.end));
                this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)this);
            });
        }
        catch (IOException x) {
            throw Throwing.sneakyThrow((Throwable)x);
        }
        return this;
    }

    public boolean isResponseStarted() {
        return this.responseStarted;
    }

    @Nonnull
    public Context sendStatusCode(int statusCode) {
        this.responseStarted = true;
        this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        DefaultFullHttpResponse rsp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)statusCode), Unpooled.EMPTY_BUFFER, this.setHeaders, NO_TRAILING);
        this.ctx.writeAndFlush((Object)rsp).addListener((GenericFutureListener)this);
        return this;
    }

    public void operationComplete(ChannelFuture future) {
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)this.req);
        try {
            this.destroy(future.cause());
        }
        finally {
            if (!keepAlive) {
                future.channel().close();
            }
        }
    }

    private NettyOutputStream newOutputStream() {
        this.prepareChunked();
        return new NettyOutputStream(this.ctx, this.bufferSize, (HttpResponse)new DefaultHttpResponse(this.req.protocolVersion(), this.status, this.setHeaders), this);
    }

    void destroy(Throwable cause) {
        Logger log = this.router.log();
        if (cause != null) {
            if (Server.connectionLost((Throwable)cause)) {
                log.debug("exception found while sending response {} {}", new Object[]{this.method(), this.pathString(), cause});
            } else {
                log.error("exception found while sending response {} {}", new Object[]{this.method(), this.pathString(), cause});
            }
        }
        if (this.files != null) {
            for (FileUpload file : this.files) {
                try {
                    file.destroy();
                }
                catch (Exception x) {
                    log.debug("file upload destroy resulted in exception", (Throwable)x);
                }
            }
            this.files = null;
        }
        if (this.decoder != null) {
            try {
                this.decoder.destroy();
            }
            catch (Exception x) {
                log.debug("body decoder destroy resulted in exception", (Throwable)x);
            }
            this.decoder = null;
        }
        NettyContext.release(this.req);
        this.route = null;
        this.ctx = null;
        this.req = null;
        this.router = null;
    }

    private FileUpload register(FileUpload upload) {
        if (this.files == null) {
            this.files = new ArrayList<FileUpload>();
        }
        this.files.add(upload);
        return upload;
    }

    private void decodeForm(HttpRequest req, Value.Object form) {
        try {
            while (this.decoder.hasNext()) {
                HttpData next = (HttpData)this.decoder.next();
                if (next.getHttpDataType() == InterfaceHttpData.HttpDataType.FileUpload) {
                    form.put(next.getName(), this.register(new NettyFileUpload(this.router.tmpdir(), next.getName(), (io.netty.handler.codec.http.multipart.FileUpload)next)));
                    continue;
                }
                form.put(next.getName(), next.getString(StandardCharsets.UTF_8));
            }
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException next) {
        }
        catch (Exception x) {
            throw Throwing.sneakyThrow((Throwable)x);
        }
        finally {
            NettyContext.release(req);
        }
    }

    private static void release(HttpRequest req) {
        ReferenceCounted ref;
        if (req instanceof ReferenceCounted && (ref = (ReferenceCounted)req).refCnt() > 0) {
            ref.release();
        }
    }

    private long responseLength() {
        String len = this.setHeaders.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        return len == null ? -1L : Long.parseLong(len);
    }

    private void prepareChunked() {
        ChannelPipeline pipeline = this.ctx.pipeline();
        ChannelHandler flusher = pipeline.get("flusher");
        if (flusher != null) {
            pipeline.remove(flusher);
        }
        if (!this.setHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
            this.setHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
    }

    private /* synthetic */ void lambda$sendStream$0(DefaultHttpResponse rsp, ChunkedInput chunkedStream) {
        this.ctx.write((Object)rsp);
        this.ctx.write((Object)chunkedStream);
        this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)this);
    }
}

