/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.jooby.Router;
import io.jooby.internal.netty.NettyHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.function.Consumer;

public class NettyPipeline
extends ChannelInitializer<SocketChannel> {
    private final Router router;
    private final HttpDataFactory factory;
    private final boolean gzip;
    private final int bufferSize;
    private final long maxRequestSize;
    private final Consumer<HttpHeaders> defaultHeaders;

    public NettyPipeline(Router router, HttpDataFactory factory, Consumer<HttpHeaders> defaultHeaders, boolean gzip, int bufferSize, long maxRequestSize) {
        this.router = router;
        this.factory = factory;
        this.defaultHeaders = defaultHeaders;
        this.gzip = gzip;
        this.bufferSize = bufferSize;
        this.maxRequestSize = maxRequestSize;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        p.addLast("flusher", (ChannelHandler)new FlushConsolidationHandler(256, true));
        p.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(4096, 8192, this.bufferSize, false));
        p.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        if (this.gzip) {
            p.addLast("gzip", (ChannelHandler)new HttpContentCompressor());
        }
        p.addLast("chunked", (ChannelHandler)new ChunkedWriteHandler());
        p.addLast("handler", (ChannelHandler)new NettyHandler(this.router, this.maxRequestSize, this.bufferSize, this.factory, this.defaultHeaders));
    }
}

