/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class NettyResponseChannel
implements WritableByteChannel,
Closeable {
    private ChannelHandlerContext ctx;
    private HttpResponse rsp;
    private final int maxBufferSize;
    private int bufferSize;

    public NettyResponseChannel(ChannelHandlerContext ctx, HttpResponse rsp, int maxBufferSize) {
        this.ctx = ctx;
        this.rsp = rsp;
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    public int write(ByteBuffer src) {
        boolean flush;
        int size = src.remaining();
        boolean bl = flush = size + this.bufferSize >= this.maxBufferSize;
        if (this.rsp != null) {
            this.ctx.write((Object)this.rsp, this.ctx.voidPromise());
            this.rsp = null;
        }
        ByteBuf bytebuf = Unpooled.wrappedBuffer((ByteBuffer)src).copy();
        if (flush) {
            this.bufferSize = 0;
            this.ctx.writeAndFlush((Object)new DefaultHttpContent(bytebuf), this.ctx.voidPromise());
        } else {
            this.bufferSize += size;
            this.ctx.write((Object)new DefaultHttpContent(bytebuf), this.ctx.voidPromise());
        }
        return size;
    }

    @Override
    public boolean isOpen() {
        return this.ctx != null;
    }

    @Override
    public void close() {
        if (this.ctx != null) {
            this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, this.ctx.voidPromise());
            this.ctx = null;
        }
    }
}

