/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.netty;

import io.jooby.Jooby;
import io.jooby.Router;
import io.jooby.Server;
import io.jooby.ServerOptions;
import io.jooby.SneakyThrows;
import io.jooby.internal.netty.NettyNative;
import io.jooby.internal.netty.NettyPipeline;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.BindException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;

public class Netty
extends Server.Base {
    private static final int BACKLOG = 8192;
    private List<Jooby> applications = new ArrayList<Jooby>();
    private EventLoopGroup acceptor;
    private EventLoopGroup ioLoop;
    private DefaultEventExecutorGroup worker;
    private ServerOptions options = new ServerOptions().setSingleLoop(false).setServer("netty");

    public Netty setOptions(@Nonnull ServerOptions options) {
        this.options = options.setSingleLoop(options.getSingleLoop(false));
        return this;
    }

    @Nonnull
    public ServerOptions getOptions() {
        return this.options;
    }

    @Nonnull
    public Server start(@Nonnull Jooby application) {
        try {
            String tmpdir;
            this.applications.add(application);
            this.addShutdownHook();
            this.worker = new DefaultEventExecutorGroup(this.options.getWorkerThreads(), (ThreadFactory)new DefaultThreadFactory("application"));
            this.fireStart(this.applications, (Executor)this.worker);
            DiskFileUpload.baseDirectory = tmpdir = this.applications.get(0).getTmpdir().toString();
            DiskAttribute.baseDirectory = tmpdir;
            NettyNative provider = NettyNative.get(((Object)((Object)this)).getClass().getClassLoader());
            this.acceptor = provider.group("netty-acceptor", this.options.getIoThreads());
            this.ioLoop = this.options.getSingleLoop() ? this.acceptor : provider.group("netty-io", this.options.getIoThreads());
            DefaultHttpDataFactory factory = new DefaultHttpDataFactory((long)this.options.getBufferSize());
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)8192);
            bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
            ((ServerBootstrap)bootstrap.group(this.acceptor, this.ioLoop).channel(provider.channel())).childHandler((ChannelHandler)new NettyPipeline((ScheduledExecutorService)this.acceptor.next(), (Router)this.applications.get(0), (HttpDataFactory)factory, this.options.isDefaultHeaders(), this.options.isGzip(), this.options.getBufferSize(), this.options.getMaxRequestSize())).childOption(ChannelOption.SO_REUSEADDR, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true);
            bootstrap.bind("0.0.0.0", this.options.getPort()).get();
            this.fireReady(this.applications);
        }
        catch (InterruptedException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
        catch (ExecutionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof BindException) {
                cause = new BindException("Address already in use: " + this.options.getPort());
            }
            throw SneakyThrows.propagate((Throwable)cause);
        }
        return this;
    }

    @Nonnull
    public synchronized Server stop() {
        this.fireStop(this.applications);
        if (this.acceptor != null) {
            this.acceptor.shutdownGracefully();
            this.acceptor = null;
        }
        if (!this.options.getSingleLoop() && this.ioLoop != null) {
            this.ioLoop.shutdownGracefully();
            this.ioLoop = null;
        }
        if (this.worker != null) {
            this.worker.shutdownGracefully();
            this.worker = null;
        }
        return this;
    }

    static {
        System.setProperty("io.netty.leakDetection.level", System.getProperty("io.netty.leakDetection.level", "disabled"));
    }
}

