/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.jooby.Context;
import io.jooby.Router;
import io.jooby.Server;
import io.jooby.StatusCode;
import io.jooby.WebSocketCloseStatus;
import io.jooby.exception.StatusCodeException;
import io.jooby.internal.netty.HttpRawPostRequestDecoder;
import io.jooby.internal.netty.NettyContext;
import io.jooby.internal.netty.NettyWebSocket;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCounted;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class NettyHandler
extends ChannelInboundHandlerAdapter {
    private static final AtomicReference<String> cachedDateString = new AtomicReference();
    private static final Runnable INVALIDATE_TASK = () -> cachedDateString.set(null);
    private static final AsciiString server = AsciiString.cached((String)"N");
    private final ScheduledExecutorService scheduler;
    private static final int DATE_INTERVAL = 1000;
    private final Router router;
    private final int bufferSize;
    private final boolean defaultHeaders;
    private NettyContext context;
    private final HttpDataFactory factory;
    private InterfaceHttpPostRequestDecoder decoder;
    private final long maxRequestSize;
    private long contentLength;
    private long chunkSize;

    public NettyHandler(ScheduledExecutorService scheduler, Router router, long maxRequestSize, int bufferSize, HttpDataFactory factory, boolean defaultHeaders) {
        this.scheduler = scheduler;
        this.router = router;
        this.maxRequestSize = maxRequestSize;
        this.factory = factory;
        this.bufferSize = bufferSize;
        this.defaultHeaders = defaultHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            if (msg instanceof HttpRequest) {
                HttpRequest req = (HttpRequest)msg;
                this.context = new NettyContext(ctx, req, this.router, NettyHandler.pathOnly(req.uri()), this.bufferSize);
                if (this.defaultHeaders) {
                    this.context.setHeaders.set((CharSequence)HttpHeaderNames.DATE, (Object)NettyHandler.date(this.scheduler));
                    this.context.setHeaders.set((CharSequence)HttpHeaderNames.SERVER, (Object)server);
                }
                this.context.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN);
                if (this.context.isHttpGet()) {
                    this.router.match((Context)this.context).execute((Context)this.context);
                } else {
                    this.contentLength = NettyHandler.contentLength(req);
                    if (this.contentLength > 0L || HttpUtil.isTransferEncodingChunked((HttpMessage)req)) {
                        this.decoder = NettyHandler.newDecoder(req, this.factory);
                    } else {
                        this.router.match((Context)this.context).execute((Context)this.context);
                    }
                }
            } else if (this.decoder != null && msg instanceof HttpContent) {
                HttpContent chunk = (HttpContent)msg;
                this.chunkSize += (long)chunk.content().readableBytes();
                if (this.chunkSize > this.maxRequestSize) {
                    this.resetDecoderState(true);
                    this.context.sendError((Throwable)new StatusCodeException(StatusCode.REQUEST_ENTITY_TOO_LARGE));
                    return;
                }
                this.offer(chunk);
                if (this.contentLength == this.chunkSize && !(chunk instanceof LastHttpContent)) {
                    chunk = LastHttpContent.EMPTY_LAST_CONTENT;
                    this.offer(chunk);
                }
                if (chunk instanceof LastHttpContent) {
                    this.context.decoder = this.decoder;
                    Router.Match result = this.router.match((Context)this.context);
                    this.resetDecoderState(!result.matches());
                    result.execute((Context)this.context);
                }
            } else if (msg instanceof WebSocketFrame && this.context.webSocket != null) {
                this.context.webSocket.handleFrame((WebSocketFrame)msg);
            }
        }
        finally {
            ReferenceCounted ref;
            if (msg instanceof ReferenceCounted && (ref = (ReferenceCounted)msg).refCnt() > 0) {
                ref.release();
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.context != null) {
            this.context.flush();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        NettyWebSocket ws;
        if (evt instanceof IdleStateEvent && (ws = (NettyWebSocket)ctx.channel().attr(NettyWebSocket.WS).getAndSet(null)) != null) {
            ws.close(WebSocketCloseStatus.GOING_AWAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        try {
            Logger log = this.router.getLog();
            if (Server.connectionLost((Throwable)cause)) {
                if (log.isDebugEnabled()) {
                    if (this.context == null) {
                        log.debug("execution resulted in connection lost", cause);
                    } else {
                        log.debug("%s %s", new Object[]{this.context.getMethod(), this.context.getRequestPath(), cause});
                    }
                }
            } else if (this.context == null) {
                log.error("execution resulted in exception", cause);
            } else {
                this.context.sendError(cause);
                this.context = null;
            }
        }
        finally {
            ctx.close();
        }
    }

    private void offer(HttpContent chunk) {
        try {
            this.decoder.offer(chunk);
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException x) {
            this.resetDecoderState(true);
            this.context.sendError(x, StatusCode.BAD_REQUEST);
        }
    }

    private void resetDecoderState(boolean destroy) {
        this.chunkSize = 0L;
        this.contentLength = -1L;
        if (destroy && this.decoder != null) {
            this.decoder.destroy();
        }
        this.decoder = null;
    }

    private static InterfaceHttpPostRequestDecoder newDecoder(HttpRequest request, HttpDataFactory factory) {
        String contentType = request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentType != null) {
            String lowerContentType = contentType.toLowerCase();
            if (lowerContentType.startsWith("multipart/form-data")) {
                return new HttpPostMultipartRequestDecoder(factory, request, StandardCharsets.UTF_8);
            }
            if (lowerContentType.startsWith("application/x-www-form-urlencoded")) {
                return new HttpPostStandardRequestDecoder(factory, request, StandardCharsets.UTF_8);
            }
        }
        return new HttpRawPostRequestDecoder(factory, request);
    }

    static String pathOnly(String uri) {
        int len = uri.indexOf(63);
        return len > 0 ? uri.substring(0, len) : uri;
    }

    private static long contentLength(HttpRequest req) {
        String value = req.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        if (value == null) {
            return -1L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException x) {
            return -1L;
        }
    }

    private static String date(ScheduledExecutorService scheduler) {
        String dateString = cachedDateString.get();
        if (dateString == null) {
            long realTime = System.currentTimeMillis();
            long mod = realTime % 1000L;
            long toGo = 1000L - mod;
            dateString = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneOffset.UTC));
            if (cachedDateString.compareAndSet(null, dateString)) {
                scheduler.schedule(INVALIDATE_TASK, toGo, TimeUnit.MILLISECONDS);
            }
        }
        return dateString;
    }
}

