/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.jooby.Router;
import io.jooby.internal.netty.HttpChunkContentCompressor;
import io.jooby.internal.netty.NettyHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.ssl.SslContext;
import java.util.concurrent.ScheduledExecutorService;

public class NettyPipeline
extends ChannelInitializer<SocketChannel> {
    private final Router router;
    private final HttpDataFactory factory;
    private final boolean gzip;
    private final int bufferSize;
    private final long maxRequestSize;
    private final boolean defaultHeaders;
    private final ScheduledExecutorService service;
    private final SslContext sslContext;

    public NettyPipeline(ScheduledExecutorService service, Router router, HttpDataFactory factory, SslContext sslContext, boolean defaultHeaders, boolean gzip, int bufferSize, long maxRequestSize) {
        this.service = service;
        this.router = router;
        this.factory = factory;
        this.sslContext = sslContext;
        this.defaultHeaders = defaultHeaders;
        this.gzip = gzip;
        this.bufferSize = bufferSize;
        this.maxRequestSize = maxRequestSize;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        if (this.sslContext != null) {
            p.addLast("ssl", (ChannelHandler)this.sslContext.newHandler(ch.alloc()));
        }
        p.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(4096, 8192, this.bufferSize, false));
        p.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        if (this.gzip) {
            p.addLast("compressor", (ChannelHandler)new HttpChunkContentCompressor());
        }
        p.addLast("handler", (ChannelHandler)new NettyHandler(this.service, this.router, this.maxRequestSize, this.bufferSize, this.factory, this.defaultHeaders));
    }
}

