/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Body;
import io.jooby.Context;
import io.jooby.MediaType;
import io.jooby.SneakyThrows;
import io.jooby.Value;
import io.jooby.ValueNode;
import io.netty.handler.codec.http.multipart.HttpData;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class NettyBody
implements Body {
    private final Context ctx;
    private final HttpData data;
    private long length;

    public NettyBody(Context ctx, HttpData data, long contentLength) {
        this.ctx = ctx;
        this.data = data;
        this.length = contentLength;
    }

    public boolean isInMemory() {
        return this.data.isInMemory();
    }

    public long getSize() {
        return this.length;
    }

    public InputStream stream() {
        try {
            if (this.data.isInMemory()) {
                return new ByteArrayInputStream(this.data.get());
            }
            return new FileInputStream(this.data.getFile());
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public ReadableByteChannel channel() {
        return Channels.newChannel(this.stream());
    }

    public byte[] bytes() {
        try {
            if (this.data.isInMemory()) {
                return this.data.get();
            }
            return Files.readAllBytes(this.data.getFile().toPath());
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    @NonNull
    public String value() {
        return this.value(StandardCharsets.UTF_8);
    }

    @NonNull
    public ValueNode get(@NonNull int index) {
        return index == 0 ? this : this.get(Integer.toString(index));
    }

    @NonNull
    public ValueNode get(@NonNull String name) {
        return Value.missing((String)name);
    }

    public String name() {
        return "body";
    }

    @NonNull
    public <T> T to(@NonNull Type type) {
        return (T)this.ctx.decode(type, this.ctx.getRequestType(MediaType.text));
    }

    public Map<String, List<String>> toMultimap() {
        return Collections.emptyMap();
    }
}

