/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContentCompressor;

public class HttpChunkContentCompressor
extends HttpContentCompressor {
    public HttpChunkContentCompressor(int compressionLevel) {
        super(new CompressionOptions[]{StandardCompressionOptions.gzip((int)compressionLevel, (int)StandardCompressionOptions.gzip().windowBits(), (int)StandardCompressionOptions.gzip().memLevel())});
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ByteBuf buff;
        if (msg instanceof ByteBuf && (buff = (ByteBuf)msg).isReadable()) {
            msg = new DefaultHttpContent(buff);
        }
        super.write(ctx, msg, promise);
    }
}

