/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.netty;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Jooby;
import io.jooby.Router;
import io.jooby.Server;
import io.jooby.ServerOptions;
import io.jooby.SneakyThrows;
import io.jooby.SslOptions;
import io.jooby.buffer.DataBufferFactory;
import io.jooby.internal.netty.HeadersMultiMap;
import io.jooby.internal.netty.NettyPipeline;
import io.jooby.internal.netty.NettyTransport;
import io.jooby.internal.netty.NettyWebSocket;
import io.jooby.netty.buffer.NettyDataBufferFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;

public class NettyServer
extends Server.Base {
    private static final int _50 = 50;
    private static final int _100 = 100;
    private List<Jooby> applications = new ArrayList<Jooby>();
    private EventLoopGroup acceptorloop;
    private EventLoopGroup eventloop;
    private ExecutorService worker;
    private NettyDataBufferFactory bufferFactory;
    private ServerOptions options = new ServerOptions().setServer("netty");

    public NettyServer(@NonNull NettyDataBufferFactory bufferFactory, @NonNull ExecutorService worker) {
        this.worker = worker;
        this.bufferFactory = bufferFactory;
    }

    public NettyServer(@NonNull ExecutorService worker) {
        this.worker = worker;
    }

    public NettyServer(@NonNull NettyDataBufferFactory bufferFactory) {
        this.worker = null;
        this.bufferFactory = bufferFactory;
    }

    public NettyServer() {
    }

    @NonNull
    public NettyServer setOptions(@NonNull ServerOptions options) {
        this.options = options;
        return this;
    }

    @NonNull
    public ServerOptions getOptions() {
        return this.options;
    }

    @NonNull
    public String getName() {
        return "netty";
    }

    @NonNull
    public Server start(@NonNull Jooby application) {
        try {
            boolean http2;
            String tmpdir;
            if (this.worker == null) {
                this.worker = Executors.newFixedThreadPool(this.options.getWorkerThreads(), (ThreadFactory)new DefaultThreadFactory("worker"));
            }
            if (this.bufferFactory == null) {
                this.bufferFactory = new NettyDataBufferFactory(ByteBufAllocator.DEFAULT);
            }
            application.setBufferFactory((DataBufferFactory)this.bufferFactory);
            this.applications.add(application);
            this.addShutdownHook();
            this.fireStart(this.applications, this.worker);
            DiskFileUpload.baseDirectory = tmpdir = this.applications.get(0).getTmpdir().toString();
            DiskAttribute.baseDirectory = tmpdir;
            NettyTransport transport = NettyTransport.transport(application.getClassLoader());
            this.acceptorloop = transport.createEventLoop(1, "acceptor", 50);
            this.eventloop = transport.createEventLoop(this.options.getIoThreads(), "eventloop", 100);
            DefaultHttpDataFactory factory = new DefaultHttpDataFactory((long)this.options.getBufferSize());
            ByteBufAllocator allocator = this.bufferFactory.getByteBufAllocator();
            boolean bl = http2 = this.options.isHttp2() == Boolean.TRUE;
            if (!this.options.isHttpsOnly()) {
                ServerBootstrap http = this.newBootstrap(allocator, transport, this.newPipeline(null, (HttpDataFactory)factory, http2));
                http.bind(this.options.getHost(), this.options.getPort()).get();
            }
            if (this.options.isSSLEnabled()) {
                SSLContext javaSslContext = this.options.getSSLContext(application.getEnvironment().getClassLoader());
                SslOptions sslOptions = this.options.getSsl();
                String[] protocol = (String[])sslOptions.getProtocol().toArray(String[]::new);
                SslOptions.ClientAuth clientAuth = sslOptions.getClientAuth();
                SslContext sslContext = this.wrap(javaSslContext, this.toClientAuth(clientAuth), protocol, http2);
                ServerBootstrap https = this.newBootstrap(allocator, transport, this.newPipeline(sslContext, (HttpDataFactory)factory, http2));
                https.bind(this.options.getHost(), this.options.getSecurePort().intValue()).get();
            } else if (this.options.isHttpsOnly()) {
                throw new IllegalArgumentException("Server configured for httpsOnly, but ssl options not set");
            }
            this.fireReady(this.applications);
        }
        catch (InterruptedException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
        catch (ExecutionException x) {
            Throwable cause = x.getCause();
            if (Server.isAddressInUse((Throwable)cause)) {
                cause = new BindException("Address already in use: " + this.options.getPort());
            }
            throw SneakyThrows.propagate((Throwable)cause);
        }
        return this;
    }

    private ServerBootstrap newBootstrap(ByteBufAllocator allocator, NettyTransport transport, NettyPipeline factory) {
        return transport.configure(this.acceptorloop, this.eventloop).childHandler((ChannelHandler)factory).childOption(ChannelOption.ALLOCATOR, (Object)allocator).childOption(ChannelOption.SO_REUSEADDR, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true);
    }

    private ClientAuth toClientAuth(SslOptions.ClientAuth clientAuth) {
        return switch (clientAuth) {
            case SslOptions.ClientAuth.REQUIRED -> ClientAuth.REQUIRE;
            case SslOptions.ClientAuth.REQUESTED -> ClientAuth.OPTIONAL;
            default -> ClientAuth.NONE;
        };
    }

    private NettyPipeline newPipeline(SslContext sslContext, HttpDataFactory factory, boolean http2) {
        EventLoop executor = this.acceptorloop.next();
        Jooby router = this.applications.get(0);
        int bufferSize = this.options.getBufferSize();
        HttpHeadersFactory headersFactory = HeadersMultiMap.httpHeadersFactory();
        HttpDecoderConfig decoderConfig = new HttpDecoderConfig().setMaxInitialLineLength(4096).setMaxHeaderSize(8192).setMaxChunkSize(bufferSize).setHeadersFactory(headersFactory).setTrailersFactory(headersFactory);
        return new NettyPipeline(sslContext, (ScheduledExecutorService)executor, factory, decoderConfig, (Router)router, this.options.getMaxRequestSize(), bufferSize, this.options.getDefaultHeaders(), http2, this.options.isExpectContinue() == Boolean.TRUE, this.options.getCompressionLevel());
    }

    @NonNull
    public synchronized Server stop() {
        this.fireStop(this.applications);
        this.applications.clear();
        NettyWebSocket.all.clear();
        this.shutdown(this.acceptorloop);
        this.shutdown(this.eventloop);
        if (this.worker != null) {
            this.worker.shutdown();
            this.worker = null;
        }
        return this;
    }

    private void shutdown(EventLoopGroup loopGroup) {
        if (loopGroup != null) {
            loopGroup.shutdownGracefully();
        }
    }

    private SslContext wrap(SSLContext sslContext, ClientAuth clientAuth, String[] protocol, boolean http2) {
        ApplicationProtocolConfig protocolConfig = http2 ? new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, Arrays.asList("h2", "http/1.1")) : ApplicationProtocolConfig.DISABLED;
        return new JdkSslContext(sslContext, false, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, protocolConfig, clientAuth, protocol, false);
    }
}

