/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.netty.buffer;

import io.jooby.buffer.DataBuffer;
import io.jooby.buffer.PooledDataBuffer;
import io.jooby.netty.buffer.NettyDataBufferFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.IntPredicate;

public class NettyDataBuffer
implements PooledDataBuffer {
    private ByteBuf byteBuf;
    private final NettyDataBufferFactory dataBufferFactory;

    NettyDataBuffer(ByteBuf byteBuf, NettyDataBufferFactory dataBufferFactory) {
        Objects.requireNonNull(byteBuf, "ByteBuf must not be null");
        Objects.requireNonNull(dataBufferFactory, "NettyDataBufferFactory must not be null");
        this.byteBuf = byteBuf;
        this.dataBufferFactory = dataBufferFactory;
    }

    public ByteBuf getNativeBuffer() {
        return this.byteBuf;
    }

    public NettyDataBufferFactory factory() {
        return this.dataBufferFactory;
    }

    public int indexOf(IntPredicate predicate, int fromIndex) {
        Objects.requireNonNull(predicate, "IntPredicate must not be null");
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.byteBuf.writerIndex()) {
            return -1;
        }
        int length = this.byteBuf.writerIndex() - fromIndex;
        return this.byteBuf.forEachByte(fromIndex, length, predicate.negate()::test);
    }

    public int lastIndexOf(IntPredicate predicate, int fromIndex) {
        Objects.requireNonNull(predicate, "IntPredicate must not be null");
        if (fromIndex < 0) {
            return -1;
        }
        fromIndex = Math.min(fromIndex, this.byteBuf.writerIndex() - 1);
        return this.byteBuf.forEachByteDesc(0, fromIndex + 1, predicate.negate()::test);
    }

    public int readableByteCount() {
        return this.byteBuf.readableBytes();
    }

    public int writableByteCount() {
        return this.byteBuf.writableBytes();
    }

    public int readPosition() {
        return this.byteBuf.readerIndex();
    }

    public NettyDataBuffer readPosition(int readPosition) {
        this.byteBuf.readerIndex(readPosition);
        return this;
    }

    public int writePosition() {
        return this.byteBuf.writerIndex();
    }

    public NettyDataBuffer writePosition(int writePosition) {
        this.byteBuf.writerIndex(writePosition);
        return this;
    }

    public byte getByte(int index) {
        return this.byteBuf.getByte(index);
    }

    public int capacity() {
        return this.byteBuf.capacity();
    }

    public DataBuffer ensureWritable(int capacity) {
        this.byteBuf.ensureWritable(capacity);
        return this;
    }

    public byte read() {
        return this.byteBuf.readByte();
    }

    public NettyDataBuffer read(byte[] destination) {
        this.byteBuf.readBytes(destination);
        return this;
    }

    public NettyDataBuffer read(byte[] destination, int offset, int length) {
        this.byteBuf.readBytes(destination, offset, length);
        return this;
    }

    public NettyDataBuffer write(byte b) {
        this.byteBuf.writeByte((int)b);
        return this;
    }

    public NettyDataBuffer write(byte[] source) {
        this.byteBuf.writeBytes(source);
        return this;
    }

    public NettyDataBuffer write(byte[] source, int offset, int length) {
        this.byteBuf.writeBytes(source, offset, length);
        return this;
    }

    public NettyDataBuffer write(DataBuffer ... dataBuffers) {
        if (NettyDataBuffer.hasNettyDataBuffers(dataBuffers)) {
            ByteBuf[] nativeBuffers = new ByteBuf[dataBuffers.length];
            for (int i = 0; i < dataBuffers.length; ++i) {
                nativeBuffers[i] = ((NettyDataBuffer)dataBuffers[i]).getNativeBuffer();
            }
            this.write(nativeBuffers);
        } else {
            ByteBuffer[] byteBuffers = new ByteBuffer[dataBuffers.length];
            for (int i = 0; i < dataBuffers.length; ++i) {
                byteBuffers[i] = ByteBuffer.allocate(dataBuffers[i].readableByteCount());
                dataBuffers[i].toByteBuffer(byteBuffers[i]);
            }
            this.write(byteBuffers);
        }
        return this;
    }

    private static boolean hasNettyDataBuffers(DataBuffer[] buffers) {
        for (DataBuffer buffer : buffers) {
            if (buffer instanceof NettyDataBuffer) continue;
            return false;
        }
        return true;
    }

    public NettyDataBuffer write(ByteBuffer ... buffers) {
        for (ByteBuffer buffer : buffers) {
            this.byteBuf.writeBytes(buffer);
        }
        return this;
    }

    public NettyDataBuffer write(ByteBuf ... byteBufs) {
        for (ByteBuf byteBuf : byteBufs) {
            this.byteBuf.writeBytes(byteBuf);
        }
        return this;
    }

    public DataBuffer write(CharSequence charSequence, Charset charset) {
        Objects.requireNonNull(charSequence, "CharSequence must not be null");
        Objects.requireNonNull(charset, "Charset must not be null");
        if (StandardCharsets.UTF_8.equals(charset)) {
            ByteBufUtil.writeUtf8((ByteBuf)this.byteBuf, (CharSequence)charSequence);
        } else if (StandardCharsets.US_ASCII.equals(charset)) {
            ByteBufUtil.writeAscii((ByteBuf)this.byteBuf, (CharSequence)charSequence);
        } else {
            return super.write(charSequence, charset);
        }
        return this;
    }

    public NettyDataBuffer split(int index) {
        ByteBuf split = this.byteBuf.retainedSlice(0, index);
        int writerIndex = this.byteBuf.writerIndex();
        int readerIndex = this.byteBuf.readerIndex();
        split.writerIndex(Math.min(writerIndex, index));
        split.readerIndex(Math.min(readerIndex, index));
        this.byteBuf = this.byteBuf.slice(index, this.byteBuf.capacity() - index);
        this.byteBuf.writerIndex(Math.max(writerIndex, index) - index);
        this.byteBuf.readerIndex(Math.max(readerIndex, index) - index);
        return new NettyDataBuffer(split, this.dataBufferFactory);
    }

    public void toByteBuffer(int srcPos, ByteBuffer dest, int destPos, int length) {
        Objects.requireNonNull(dest, "Dest must not be null");
        dest = dest.duplicate().clear();
        dest.put(destPos, this.byteBuf.nioBuffer(srcPos, length), 0, length);
    }

    public DataBuffer.ByteBufferIterator readableByteBuffers() {
        ByteBuffer[] readable = this.byteBuf.nioBuffers(this.byteBuf.readerIndex(), this.byteBuf.readableBytes());
        return new ByteBufferIterator(readable, true);
    }

    public DataBuffer.ByteBufferIterator writableByteBuffers() {
        ByteBuffer[] writable = this.byteBuf.nioBuffers(this.byteBuf.writerIndex(), this.byteBuf.writableBytes());
        return new ByteBufferIterator(writable, false);
    }

    public String toString(Charset charset) {
        Objects.requireNonNull(charset, "Charset must not be null");
        return this.byteBuf.toString(charset);
    }

    public String toString(int index, int length, Charset charset) {
        Objects.requireNonNull(charset, "Charset must not be null");
        return this.byteBuf.toString(index, length, charset);
    }

    public DataBuffer clear() {
        this.byteBuf.clear();
        return this;
    }

    public boolean isAllocated() {
        return this.byteBuf.refCnt() > 0;
    }

    public PooledDataBuffer retain() {
        return new NettyDataBuffer(this.byteBuf.retain(), this.dataBufferFactory);
    }

    public PooledDataBuffer touch(Object hint) {
        this.byteBuf.touch(hint);
        return this;
    }

    public boolean release() {
        return this.byteBuf.release();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof NettyDataBuffer)) return false;
        NettyDataBuffer that = (NettyDataBuffer)other;
        if (!this.byteBuf.equals((Object)that.byteBuf)) return false;
        return true;
    }

    public int hashCode() {
        return this.byteBuf.hashCode();
    }

    public String toString() {
        return this.byteBuf.toString();
    }

    private static final class ByteBufferIterator
    implements DataBuffer.ByteBufferIterator {
        private final ByteBuffer[] byteBuffers;
        private final boolean readOnly;
        private int cursor = 0;

        public ByteBufferIterator(ByteBuffer[] byteBuffers, boolean readOnly) {
            this.byteBuffers = byteBuffers;
            this.readOnly = readOnly;
        }

        public boolean hasNext() {
            return this.cursor < this.byteBuffers.length;
        }

        public ByteBuffer next() {
            int index = this.cursor;
            if (index < this.byteBuffers.length) {
                this.cursor = index + 1;
                ByteBuffer next = this.byteBuffers[index];
                return this.readOnly ? next.asReadOnlyBuffer() : next;
            }
            throw new NoSuchElementException();
        }

        public void close() {
        }
    }
}

