/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.netty.buffer;

import io.jooby.buffer.DataBuffer;
import io.jooby.buffer.DataBufferFactory;
import io.jooby.netty.buffer.NettyDataBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ResourceLeakDetector;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;

public class NettyDataBufferFactory
implements DataBufferFactory {
    private static final String LEAK_DETECTION = "io.netty.leakDetection.level";
    private final ByteBufAllocator byteBufAllocator;

    public NettyDataBufferFactory(ByteBufAllocator byteBufAllocator) {
        Objects.requireNonNull(byteBufAllocator, "ByteBufAllocator must not be null");
        this.byteBufAllocator = byteBufAllocator;
    }

    public NettyDataBufferFactory() {
        this(ByteBufAllocator.DEFAULT);
    }

    public ByteBufAllocator getByteBufAllocator() {
        return this.byteBufAllocator;
    }

    public NettyDataBuffer allocateBuffer() {
        ByteBuf byteBuf = this.byteBufAllocator.buffer();
        return new NettyDataBuffer(byteBuf, this);
    }

    public NettyDataBuffer allocateBuffer(int initialCapacity) {
        ByteBuf byteBuf = this.byteBufAllocator.buffer(initialCapacity);
        return new NettyDataBuffer(byteBuf, this);
    }

    public NettyDataBuffer wrap(ByteBuffer byteBuffer) {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuffer)byteBuffer);
        return new NettyDataBuffer(byteBuf, this);
    }

    public DataBuffer wrap(byte[] bytes) {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])bytes);
        return new NettyDataBuffer(byteBuf, this);
    }

    public NettyDataBuffer wrap(ByteBuf byteBuf) {
        byteBuf.touch();
        return new NettyDataBuffer(byteBuf, this);
    }

    public DataBuffer join(List<? extends DataBuffer> dataBuffers) {
        Objects.requireNonNull(dataBuffers, "DataBuffer List must not be empty");
        int bufferCount = dataBuffers.size();
        if (bufferCount == 1) {
            return dataBuffers.get(0);
        }
        CompositeByteBuf composite = this.byteBufAllocator.compositeBuffer(bufferCount);
        for (DataBuffer dataBuffer : dataBuffers) {
            if (!(dataBuffer instanceof NettyDataBuffer)) {
                throw new IllegalArgumentException("");
            }
            composite.addComponent(true, ((NettyDataBuffer)dataBuffer).getNativeBuffer());
        }
        return new NettyDataBuffer((ByteBuf)composite, this);
    }

    public boolean isDirect() {
        return this.byteBufAllocator.isDirectBufferPooled();
    }

    public static ByteBuf toByteBuf(DataBuffer dataBuffer) {
        if (dataBuffer instanceof NettyDataBuffer) {
            NettyDataBuffer nettyDataBuffer = (NettyDataBuffer)dataBuffer;
            return nettyDataBuffer.getNativeBuffer();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(dataBuffer.readableByteCount());
        dataBuffer.toByteBuffer(byteBuffer);
        return Unpooled.wrappedBuffer((ByteBuffer)byteBuffer);
    }

    public String toString() {
        return "NettyDataBufferFactory (" + this.byteBufAllocator + ")";
    }

    static {
        System.setProperty(LEAK_DETECTION, System.getProperty(LEAK_DETECTION, ResourceLeakDetector.Level.DISABLED.name()));
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.valueOf((String)System.getProperty(LEAK_DETECTION)));
    }
}

