/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public final class HeadersMultiMap
extends HttpHeaders {
    public static final boolean DISABLE_HEADER_VALIDATION = Boolean.parseBoolean(System.getProperty("io.netty.disableHttpHeadersValidation", "false"));
    static final BiConsumer<CharSequence, CharSequence> HTTP_VALIDATOR;
    private final BiConsumer<CharSequence, CharSequence> validator;
    private final MapEntry[] entries = new MapEntry[16];
    private final MapEntry head = new MapEntry();
    private static final int COLON_AND_SPACE_SHORT = 14880;
    static final int CRLF_SHORT = 3338;

    private static CharSequence toValidCharSequence(Object value) {
        if (value instanceof CharSequence) {
            return (CharSequence)value;
        }
        return value.toString();
    }

    public static HttpHeadersFactory httpHeadersFactory() {
        return new HttpHeadersFactory(){

            public HttpHeaders newHeaders() {
                return new HeadersMultiMap();
            }

            public HttpHeaders newEmptyHeaders() {
                return new HeadersMultiMap();
            }
        };
    }

    public int size() {
        return this.names().size();
    }

    public HeadersMultiMap() {
        this(HTTP_VALIDATOR);
    }

    public HeadersMultiMap(BiConsumer<CharSequence, CharSequence> validator) {
        this.validator = validator;
        this.head.before = this.head.after = this.head;
    }

    public HeadersMultiMap add(CharSequence name, CharSequence value) {
        Objects.requireNonNull(value);
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        this.add0(h, i, name, value);
        return this;
    }

    public HeadersMultiMap add(CharSequence name, Object value) {
        return this.add(name, HeadersMultiMap.toValidCharSequence(value));
    }

    public HttpHeaders add(String name, Object value) {
        return this.add((CharSequence)name, HeadersMultiMap.toValidCharSequence(value));
    }

    public HeadersMultiMap add(String name, String strVal) {
        return this.add((CharSequence)name, (CharSequence)strVal);
    }

    public HeadersMultiMap add(CharSequence name, Iterable values) {
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        for (Object vstr : values) {
            this.add0(h, i, name, HeadersMultiMap.toValidCharSequence(vstr));
        }
        return this;
    }

    public HeadersMultiMap add(String name, Iterable values) {
        return this.add((CharSequence)name, values);
    }

    public HeadersMultiMap remove(CharSequence name) {
        Objects.requireNonNull(name, "name");
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        this.remove0(h, i, name);
        return this;
    }

    public HeadersMultiMap remove(String name) {
        return this.remove((CharSequence)name);
    }

    public HeadersMultiMap set(CharSequence name, CharSequence value) {
        return this.set0(name, value);
    }

    public HeadersMultiMap set(String name, String value) {
        return this.set0(name, value);
    }

    public HeadersMultiMap set(String name, Object value) {
        return this.set0(name, HeadersMultiMap.toValidCharSequence(value));
    }

    public HeadersMultiMap set(CharSequence name, Object value) {
        return this.set(name, HeadersMultiMap.toValidCharSequence(value));
    }

    public HeadersMultiMap set(CharSequence name, Iterable values) {
        Objects.requireNonNull(values, "values");
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        this.remove0(h, i, name);
        for (Object v : values) {
            if (v == null) break;
            this.add0(h, i, name, HeadersMultiMap.toValidCharSequence(v));
        }
        return this;
    }

    public HeadersMultiMap set(String name, Iterable values) {
        return this.set((CharSequence)name, values);
    }

    public boolean containsValue(CharSequence name, CharSequence value, boolean ignoreCase) {
        return this.containsInternal(name, value, false, ignoreCase);
    }

    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCase) {
        return this.containsInternal(name, value, true, ignoreCase);
    }

    private boolean containsInternal(CharSequence name, CharSequence value, boolean equals, boolean ignoreCase) {
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        MapEntry e = this.entries[i];
        while (e != null) {
            CharSequence key = e.key;
            if (e.hash == h && (name == key || AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)key))) {
                CharSequence other = e.getValue();
                if (equals) {
                    if (ignoreCase && AsciiString.contentEqualsIgnoreCase((CharSequence)value, (CharSequence)other) || !ignoreCase && AsciiString.contentEquals((CharSequence)value, (CharSequence)other)) {
                        return true;
                    }
                } else {
                    int prev = 0;
                    while (true) {
                        int idx;
                        int from;
                        int to;
                        for (to = (idx = AsciiString.indexOf((CharSequence)other, (char)',', (int)prev)) == -1 ? other.length() : idx; to > prev && other.charAt(to - 1) == ' '; --to) {
                        }
                        for (from = prev; from < to && other.charAt(from) == ' '; ++from) {
                        }
                        int len = to - from;
                        if (len > 0 && AsciiString.regionMatches((CharSequence)other, (boolean)ignoreCase, (int)from, (CharSequence)value, (int)0, (int)len)) {
                            return true;
                        }
                        if (idx == -1) break;
                        prev = idx + 1;
                    }
                }
            }
            e = e.next;
        }
        return false;
    }

    public boolean contains(String name, String value, boolean ignoreCase) {
        return this.contains((CharSequence)name, (CharSequence)value, ignoreCase);
    }

    public boolean contains(CharSequence name) {
        return this.get0(name) != null;
    }

    public boolean contains(String name) {
        return this.contains((CharSequence)name);
    }

    public String get(CharSequence name) {
        Objects.requireNonNull(name, "name");
        CharSequence ret = this.get0(name);
        return ret != null ? ret.toString() : null;
    }

    public String get(String name) {
        return this.get((CharSequence)name);
    }

    public List<String> getAll(CharSequence name) {
        Objects.requireNonNull(name, "name");
        LinkedList<String> values = null;
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        MapEntry e = this.entries[i];
        while (e != null) {
            CharSequence key = e.key;
            if (e.hash == h && (name == key || AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)key))) {
                if (values == null) {
                    values = new LinkedList<String>();
                }
                values.addFirst(e.getValue().toString());
            }
            e = e.next;
        }
        return values == null ? Collections.emptyList() : Collections.unmodifiableList(values);
    }

    public List<Map.Entry<String, String>> entries() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(this.entries.length);
        this.forEach(entries::add);
        return entries;
    }

    public List<String> getAll(String name) {
        return this.getAll((CharSequence)name);
    }

    public void forEach(Consumer<? super Map.Entry<String, String>> action) {
        MapEntry e = this.head.after;
        while (e != this.head) {
            action.accept(e.stringEntry());
            e = e.after;
        }
    }

    public void forEach(BiConsumer<String, String> action) {
        MapEntry e = this.head.after;
        while (e != this.head) {
            action.accept(e.getKey().toString(), e.getValue().toString());
            e = e.after;
        }
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return new Iterator<Map.Entry<String, String>>(){
            MapEntry curr;
            {
                this.curr = HeadersMultiMap.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.curr.after != HeadersMultiMap.this.head;
            }

            @Override
            public Map.Entry<String, String> next() {
                final MapEntry next = this.curr.after;
                if (next == HeadersMultiMap.this.head) {
                    throw new NoSuchElementException();
                }
                this.curr = next;
                return new Map.Entry<String, String>(){

                    @Override
                    public String getKey() {
                        return next.key.toString();
                    }

                    @Override
                    public String getValue() {
                        return next.value.toString();
                    }

                    @Override
                    public String setValue(String value) {
                        return next.setValue(value).toString();
                    }

                    public String toString() {
                        return this.getKey() + "=" + this.getValue();
                    }
                };
            }
        };
    }

    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    public Set<String> names() {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        MapEntry e = this.head.after;
        while (e != this.head) {
            names.add(e.getKey().toString());
            e = e.after;
        }
        return names;
    }

    public HeadersMultiMap clear() {
        Arrays.fill(this.entries, null);
        this.head.before = this.head.after = this.head;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            sb.append(entry).append('\n');
        }
        return sb.toString();
    }

    public Integer getInt(CharSequence name) {
        return this.getValue(name, Integer::parseInt, null);
    }

    private <T> T getValue(CharSequence name, Function<String, T> mapper, T defaultValue) {
        String value = this.get(name);
        return value == null ? defaultValue : mapper.apply(value);
    }

    public int getInt(CharSequence name, int defaultValue) {
        return this.getValue(name, Integer::parseInt, defaultValue);
    }

    public Short getShort(CharSequence name) {
        return this.getValue(name, Short::parseShort, null);
    }

    public short getShort(CharSequence name, short defaultValue) {
        return this.getValue(name, Short::parseShort, defaultValue);
    }

    public Long getTimeMillis(CharSequence name) {
        return this.getValue(name, HeadersMultiMap.dateToMillis(), null);
    }

    public long getTimeMillis(CharSequence name, long defaultValue) {
        return this.getValue(name, HeadersMultiMap.dateToMillis(), defaultValue);
    }

    private static Function<String, Long> dateToMillis() {
        return value -> {
            Date date = DateFormatter.parseHttpDate((CharSequence)value);
            return date == null ? null : Long.valueOf(date.getTime());
        };
    }

    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return new Iterator<Map.Entry<CharSequence, CharSequence>>(){
            MapEntry current;
            {
                this.current = HeadersMultiMap.this.head.after;
            }

            @Override
            public boolean hasNext() {
                return this.current != HeadersMultiMap.this.head;
            }

            @Override
            public Map.Entry<CharSequence, CharSequence> next() {
                MapEntry next = this.current;
                this.current = this.current.after;
                return next;
            }
        };
    }

    public HttpHeaders addInt(CharSequence name, int value) {
        this.add(name, (CharSequence)Integer.toString(value));
        return this;
    }

    public HttpHeaders addShort(CharSequence name, short value) {
        this.add(name, (CharSequence)Short.toString(value));
        return this;
    }

    public HttpHeaders setInt(CharSequence name, int value) {
        return this.set(name, (CharSequence)Integer.toString(value));
    }

    public HttpHeaders setShort(CharSequence name, short value) {
        return this.set(name, (CharSequence)Short.toString(value));
    }

    public void encode(ByteBuf buf) {
        MapEntry current = this.head.after;
        while (current != this.head) {
            HeadersMultiMap.encoderHeader(current.key, current.value, buf);
            current = current.after;
        }
    }

    static void encoderHeader(CharSequence name, CharSequence value, ByteBuf buf) {
        int nameLen = name.length();
        int valueLen = value.length();
        int entryLen = nameLen + valueLen + 4;
        buf.ensureWritable(entryLen);
        int offset = buf.writerIndex();
        HeadersMultiMap.writeAscii(buf, offset, name);
        ByteBufUtil.setShortBE((ByteBuf)buf, (int)(offset += nameLen), (int)14880);
        HeadersMultiMap.writeAscii(buf, offset += 2, value);
        ByteBufUtil.setShortBE((ByteBuf)buf, (int)(offset += valueLen), (int)3338);
        buf.writerIndex(offset += 2);
    }

    private static void writeAscii(ByteBuf buf, int offset, CharSequence value) {
        if (value instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)((AsciiString)value), (int)0, (ByteBuf)buf, (int)offset, (int)value.length());
        } else {
            buf.setCharSequence(offset, value, CharsetUtil.US_ASCII);
        }
    }

    private void remove0(int h, int i, CharSequence name) {
        MapEntry e = this.entries[i];
        MapEntry prev = null;
        while (e != null) {
            MapEntry next = e.next;
            CharSequence key = e.key;
            if (e.hash == h && (name == key || AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)key))) {
                if (prev == null) {
                    this.entries[i] = next;
                } else {
                    prev.next = next;
                }
                e.remove();
            } else {
                prev = e;
            }
            e = next;
        }
    }

    private void add0(int h, int i, CharSequence name, CharSequence value) {
        MapEntry newEntry;
        if (this.validator != null) {
            this.validator.accept(name, value);
        }
        MapEntry e = this.entries[i];
        this.entries[i] = newEntry = new MapEntry(h, name, value);
        newEntry.next = e;
        newEntry.addBefore(this.head);
    }

    private HeadersMultiMap set0(CharSequence name, CharSequence strVal) {
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        this.remove0(h, i, name);
        if (strVal != null) {
            this.add0(h, i, name, strVal);
        }
        return this;
    }

    private CharSequence get0(CharSequence name) {
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        MapEntry e = this.entries[i];
        CharSequence value = null;
        while (e != null) {
            CharSequence key = e.key;
            if (e.hash == h && (name == key || AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)key))) {
                value = e.getValue();
            }
            e = e.next;
        }
        return value;
    }

    static {
        if (DISABLE_HEADER_VALIDATION) {
            HTTP_VALIDATOR = null;
        } else {
            DefaultHeaders.NameValidator nameValidator = DefaultHttpHeadersFactory.headersFactory().getNameValidator();
            DefaultHeaders.ValueValidator valueValidator = DefaultHttpHeadersFactory.headersFactory().getValueValidator();
            HTTP_VALIDATOR = (name, value) -> {
                nameValidator.validateName(name);
                valueValidator.validate(value);
            };
        }
    }

    private final class MapEntry
    implements Map.Entry<CharSequence, CharSequence> {
        final int hash;
        final CharSequence key;
        CharSequence value;
        MapEntry next;
        MapEntry before;
        MapEntry after;

        MapEntry() {
            this.hash = -1;
            this.key = null;
            this.value = null;
        }

        MapEntry(int hash, CharSequence key, CharSequence value) {
            this.hash = hash;
            this.key = key;
            this.value = value;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
            this.after = null;
            this.before = null;
        }

        void addBefore(MapEntry e) {
            this.after = e;
            this.before = e.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public CharSequence setValue(CharSequence value) {
            Objects.requireNonNull(value, "value");
            if (HeadersMultiMap.this.validator != null) {
                HeadersMultiMap.this.validator.accept("", value);
            }
            CharSequence oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        private Map.Entry<String, String> stringEntry() {
            if (this.key instanceof String && this.value instanceof String) {
                return this;
            }
            return new AbstractMap.SimpleEntry<String, String>(this.key.toString(), this.value.toString());
        }
    }
}

