/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstachio.TemplateInfo;
import io.jstach.jstachio.spi.JStachioTemplateFinder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

final class CompositeTemplateFinder
implements JStachioTemplateFinder {
    private final List<JStachioTemplateFinder> finders;

    private CompositeTemplateFinder(List<JStachioTemplateFinder> finders) {
        this.finders = finders;
    }

    public static JStachioTemplateFinder of(List<? extends JStachioTemplateFinder> finders) {
        if (finders.size() == 1) {
            return finders.get(0);
        }
        ArrayList<? extends JStachioTemplateFinder> sorted = new ArrayList<JStachioTemplateFinder>();
        sorted.addAll(finders);
        sorted.sort(Comparator.comparingInt(JStachioTemplateFinder::order));
        return new CompositeTemplateFinder(List.copyOf(sorted));
    }

    @Override
    public TemplateInfo findTemplate(Class<?> modelType) throws Exception {
        for (JStachioTemplateFinder f : this.finders) {
            if (!f.supportsType(modelType)) continue;
            return f.findTemplate(modelType);
        }
        throw new RuntimeException("Template not found for type: " + modelType);
    }
}

