/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstachio.spi.CompositeConfig;
import io.jstach.jstachio.spi.CompositeTemplateFinder;
import io.jstach.jstachio.spi.JStachioConfig;
import io.jstach.jstachio.spi.JStachioExtension;
import io.jstach.jstachio.spi.JStachioExtensions;
import io.jstach.jstachio.spi.JStachioFilter;
import io.jstach.jstachio.spi.JStachioTemplateFinder;
import io.jstach.jstachio.spi.SystemPropertyConfig;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

class DefaultJStachioExtensions
implements JStachioExtensions {
    private final List<JStachioExtension> services;
    private final JStachioConfig config;
    private final JStachioFilter filter;
    private final JStachioTemplateFinder templateFinder;

    private DefaultJStachioExtensions(List<JStachioExtension> services, JStachioConfig config, JStachioFilter filter, JStachioTemplateFinder templateFinder) {
        this.services = services;
        this.config = config;
        this.filter = filter;
        this.templateFinder = templateFinder;
    }

    static JStachioExtensions of(Iterable<JStachioExtension> it) {
        ArrayList svs = new ArrayList();
        it.forEach(svs::add);
        ArrayList<JStachioConfig> configs = new ArrayList<JStachioConfig>();
        ArrayList<JStachioFilter> filters = new ArrayList<JStachioFilter>();
        ArrayList<JStachioTemplateFinder> finders = new ArrayList<JStachioTemplateFinder>();
        for (Object sv : svs) {
            JStachioConfig c = sv.provideConfig();
            if (c == null) continue;
            configs.add(c);
        }
        JStachioConfig config = configs.isEmpty() ? SystemPropertyConfig.INSTANCE : new CompositeConfig(configs);
        for (JStachioExtension sv : svs) {
            JStachioTemplateFinder find;
            sv.init(config);
            @Nullable JStachioFilter filt = sv.provideFilter();
            if (filt != null) {
                filters.add(filt);
            }
            if ((find = sv.provideTemplateFinder()) == null) continue;
            finders.add(find);
        }
        JStachioFilter filter = JStachioFilter.compose(filters);
        if (finders.isEmpty()) {
            finders.add(JStachioTemplateFinder.cachedTemplateFinder(JStachioTemplateFinder.defaultTemplateFinder(config)));
        }
        JStachioTemplateFinder templateFinder = CompositeTemplateFinder.of(finders);
        return new DefaultJStachioExtensions(List.copyOf(svs), config, filter, templateFinder);
    }

    @Override
    public JStachioConfig getConfig() {
        return this.config;
    }

    @Override
    public JStachioFilter getFilter() {
        return this.filter;
    }

    @Override
    public JStachioTemplateFinder getTemplateFinder() {
        return this.templateFinder;
    }

    @Override
    public List<JStachioExtension> getExtensions() {
        return this.services;
    }
}

