/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.jstachio.spi;

import io.jstach.jstachio.spi.NOOPLogger;
import org.eclipse.jdt.annotation.Nullable;

public interface JStachioConfig {
    public static final String REFLECTION_TEMPLATE_DISABLE = "jstachio.reflection.template.disable";
    public static final String LOGGING_DISABLE = "jstachio.logging.disable";

    public @Nullable String getProperty(String var1);

    default public boolean getBoolean(String key) {
        String prop = this.getProperty(key);
        return Boolean.parseBoolean(prop);
    }

    default public boolean getBoolean(String key, boolean fallback) {
        String prop = this.getProperty(key);
        if (prop == null) {
            return fallback;
        }
        return Boolean.parseBoolean(prop);
    }

    default public String requireProperty(String key, String fallback) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        String v = this.getProperty(key);
        if (v == null) {
            v = fallback;
        }
        if (v == null) {
            throw new NullPointerException("fallback is null. key: " + key);
        }
        return v;
    }

    default public System.Logger getLogger(String name) {
        if (!this.getBoolean(LOGGING_DISABLE)) {
            return System.getLogger(name);
        }
        return JStachioConfig.noopLogger();
    }

    public static System.Logger noopLogger() {
        return NOOPLogger.INSTANCE;
    }
}

