/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.cio;

import io.ktor.application.ApplicationCall;
import io.ktor.http.Headers;
import io.ktor.http.HttpMethod;
import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.http.cio.CIOHeaders;
import io.ktor.http.cio.Request;
import io.ktor.request.ApplicationRequest;
import io.ktor.request.RequestCookies;
import io.ktor.server.engine.BaseApplicationRequest;
import io.ktor.utils.io.ByteReadChannel;
import java.net.InetSocketAddress;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001f\u001a\u00020\bH\u0016J\r\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"R\u001b\u0010\f\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0011\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/ktor/server/cio/CIOApplicationRequest;", "Lio/ktor/server/engine/BaseApplicationRequest;", "call", "Lio/ktor/application/ApplicationCall;", "remoteAddress", "Ljava/net/InetSocketAddress;", "localAddress", "input", "Lio/ktor/utils/io/ByteReadChannel;", "request", "Lio/ktor/http/cio/Request;", "(Lio/ktor/application/ApplicationCall;Ljava/net/InetSocketAddress;Ljava/net/InetSocketAddress;Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/http/cio/Request;)V", "cookies", "Lio/ktor/request/RequestCookies;", "getCookies", "()Lio/ktor/request/RequestCookies;", "cookies$delegate", "Lkotlin/Lazy;", "headers", "Lio/ktor/http/Headers;", "getHeaders", "()Lio/ktor/http/Headers;", "local", "Lio/ktor/http/RequestConnectionPoint;", "getLocal", "()Lio/ktor/http/RequestConnectionPoint;", "queryParameters", "Lio/ktor/http/Parameters;", "getQueryParameters", "()Lio/ktor/http/Parameters;", "queryParameters$delegate", "receiveChannel", "release", "", "release$ktor_server_cio", "ktor-server-cio"})
public final class CIOApplicationRequest
extends BaseApplicationRequest {
    @Nullable
    private final InetSocketAddress remoteAddress;
    @Nullable
    private final InetSocketAddress localAddress;
    @NotNull
    private final ByteReadChannel input;
    @NotNull
    private final Request request;
    @NotNull
    private final Lazy cookies$delegate;
    @NotNull
    private final Headers headers;
    @NotNull
    private final Lazy queryParameters$delegate;
    @NotNull
    private final RequestConnectionPoint local;

    public CIOApplicationRequest(@NotNull ApplicationCall call, @Nullable InetSocketAddress remoteAddress, @Nullable InetSocketAddress localAddress, @NotNull ByteReadChannel input, @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super(call);
        this.remoteAddress = remoteAddress;
        this.localAddress = localAddress;
        this.input = input;
        this.request = request;
        this.cookies$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<RequestCookies>(this){
            final /* synthetic */ CIOApplicationRequest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final RequestCookies invoke() {
                return new RequestCookies((ApplicationRequest)this.this$0);
            }
        }));
        this.headers = (Headers)new CIOHeaders(this.request.getHeaders());
        this.queryParameters$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Parameters>(this){
            final /* synthetic */ CIOApplicationRequest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Parameters invoke() {
                CharSequence uri = CIOApplicationRequest.access$getRequest$p(this.this$0).getUri();
                int qIdx = StringsKt.indexOf$default((CharSequence)uri, (char)'?', (int)0, (boolean)false, (int)6, null);
                if (qIdx == -1 || qIdx == StringsKt.getLastIndex((CharSequence)uri)) {
                    return Parameters.Companion.getEmpty();
                }
                CharSequence charSequence = uri;
                int n = qIdx + 1;
                int n2 = charSequence.length();
                boolean bl = false;
                return QueryKt.parseQueryString$default((String)((Object)charSequence.subSequence(n, n2)).toString(), (int)0, (int)0, (int)6, null);
            }
        }));
        this.local = new RequestConnectionPoint(this){
            final /* synthetic */ CIOApplicationRequest this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public String getScheme() {
                return "http";
            }

            @NotNull
            public String getVersion() {
                return ((Object)CIOApplicationRequest.access$getRequest$p(this.this$0).getVersion()).toString();
            }

            @NotNull
            public String getUri() {
                return ((Object)CIOApplicationRequest.access$getRequest$p(this.this$0).getUri()).toString();
            }

            @NotNull
            public String getHost() {
                String string;
                Object object;
                String string2;
                Object object2 = CIOApplicationRequest.access$getLocalAddress$p(this.this$0);
                if (object2 == null) {
                    string2 = null;
                } else {
                    object = object2;
                    boolean bl = false;
                    boolean bl2 = false;
                    InetSocketAddress it = object;
                    boolean bl3 = false;
                    String string3 = it.getHostName();
                    string2 = string3 == null ? it.getAddress().getHostAddress() : string3;
                }
                String string4 = string2;
                return string4 == null ? ((object2 = CIOApplicationRequest.access$getRequest$p(this.this$0).getHeaders().get("Host")) == null ? "localhost" : ((object = object2.toString()) == null ? "localhost" : ((string = StringsKt.substringBefore$default((String)object, (String)":", null, (int)2, null)) == null ? "localhost" : string))) : string4;
            }

            public int getPort() {
                int n;
                Integer n2;
                Object object = CIOApplicationRequest.access$getLocalAddress$p(this.this$0);
                Integer n3 = n2 = object == null ? null : Integer.valueOf(((InetSocketAddress)object).getPort());
                if (n2 == null) {
                    object = CIOApplicationRequest.access$getRequest$p(this.this$0).getHeaders().get("Host");
                    if (object == null) {
                        n = 80;
                    } else {
                        String string = object.toString();
                        if (string == null) {
                            n = 80;
                        } else {
                            String string2 = StringsKt.substringAfter((String)string, (String)":", (String)"80");
                            if (string2 == null) {
                                n = 80;
                            } else {
                                int n4;
                                String string3 = string2;
                                boolean bl = false;
                                n = n4 = Integer.parseInt(string3);
                            }
                        }
                    }
                } else {
                    n = n2;
                }
                return n;
            }

            @NotNull
            public HttpMethod getMethod() {
                return HttpMethod.Companion.parse(CIOApplicationRequest.access$getRequest$p(this.this$0).getMethod().getValue());
            }

            @NotNull
            public String getRemoteHost() {
                String string;
                InetSocketAddress inetSocketAddress = CIOApplicationRequest.access$getRemoteAddress$p(this.this$0);
                if (inetSocketAddress == null) {
                    string = "unknown";
                } else {
                    InetSocketAddress inetSocketAddress2 = inetSocketAddress;
                    boolean bl = false;
                    boolean bl2 = false;
                    InetSocketAddress it = inetSocketAddress2;
                    boolean bl3 = false;
                    String string2 = it.getHostName();
                    String string3 = string2 == null ? it.getAddress().getHostAddress() : string2;
                    string = string3 == null ? "unknown" : string3;
                }
                return string;
            }
        };
    }

    @NotNull
    public RequestCookies getCookies() {
        Lazy lazy = this.cookies$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (RequestCookies)lazy.getValue();
    }

    @NotNull
    public ByteReadChannel receiveChannel() {
        return this.input;
    }

    @NotNull
    public Headers getHeaders() {
        return this.headers;
    }

    @NotNull
    public Parameters getQueryParameters() {
        Lazy lazy = this.queryParameters$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Parameters)lazy.getValue();
    }

    @NotNull
    public RequestConnectionPoint getLocal() {
        return this.local;
    }

    public final void release$ktor_server_cio() {
        this.request.release();
    }

    public static final /* synthetic */ Request access$getRequest$p(CIOApplicationRequest $this) {
        return $this.request;
    }

    public static final /* synthetic */ InetSocketAddress access$getLocalAddress$p(CIOApplicationRequest $this) {
        return $this.localAddress;
    }

    public static final /* synthetic */ InetSocketAddress access$getRemoteAddress$p(CIOApplicationRequest $this) {
        return $this.remoteAddress;
    }
}

