/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1DeleteOptionsFluent;
import io.kubernetes.client.openapi.models.V1Preconditions;
import io.kubernetes.client.openapi.models.V1PreconditionsBuilder;
import io.kubernetes.client.openapi.models.V1PreconditionsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1DeleteOptionsFluentImpl<A extends V1DeleteOptionsFluent<A>>
extends BaseFluent<A>
implements V1DeleteOptionsFluent<A> {
    private String apiVersion;
    private List<String> dryRun;
    private Long gracePeriodSeconds;
    private String kind;
    private Boolean orphanDependents;
    private V1PreconditionsBuilder preconditions;
    private String propagationPolicy;

    public V1DeleteOptionsFluentImpl() {
    }

    public V1DeleteOptionsFluentImpl(V1DeleteOptions instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withDryRun(instance.getDryRun());
        this.withGracePeriodSeconds(instance.getGracePeriodSeconds());
        this.withKind(instance.getKind());
        this.withOrphanDependents(instance.getOrphanDependents());
        this.withPreconditions(instance.getPreconditions());
        this.withPropagationPolicy(instance.getPropagationPolicy());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToDryRun(Integer index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDryRun(Integer index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDryRun(String ... items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDryRun(Collection<String> items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDryRun(String ... items) {
        for (String item : items) {
            if (this.dryRun == null) continue;
            this.dryRun.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDryRun(Collection<String> items) {
        for (String item : items) {
            if (this.dryRun == null) continue;
            this.dryRun.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDryRun() {
        return this.dryRun;
    }

    @Override
    public String getDryRun(Integer index) {
        return this.dryRun.get(index);
    }

    @Override
    public String getFirstDryRun() {
        return this.dryRun.get(0);
    }

    @Override
    public String getLastDryRun() {
        return this.dryRun.get(this.dryRun.size() - 1);
    }

    @Override
    public String getMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDryRun(List<String> dryRun) {
        if (dryRun != null) {
            this.dryRun = new ArrayList<String>();
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        } else {
            this.dryRun = null;
        }
        return (A)this;
    }

    @Override
    public A withDryRun(String ... dryRun) {
        if (this.dryRun != null) {
            this.dryRun.clear();
        }
        if (dryRun != null) {
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDryRun() {
        return this.dryRun != null && !this.dryRun.isEmpty();
    }

    @Override
    public Long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    @Override
    public A withGracePeriodSeconds(Long gracePeriodSeconds) {
        this.gracePeriodSeconds = gracePeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasGracePeriodSeconds() {
        return this.gracePeriodSeconds != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public Boolean getOrphanDependents() {
        return this.orphanDependents;
    }

    @Override
    public A withOrphanDependents(Boolean orphanDependents) {
        this.orphanDependents = orphanDependents;
        return (A)this;
    }

    @Override
    public Boolean hasOrphanDependents() {
        return this.orphanDependents != null;
    }

    @Override
    @Deprecated
    public V1Preconditions getPreconditions() {
        return this.preconditions != null ? this.preconditions.build() : null;
    }

    @Override
    public V1Preconditions buildPreconditions() {
        return this.preconditions != null ? this.preconditions.build() : null;
    }

    @Override
    public A withPreconditions(V1Preconditions preconditions) {
        this._visitables.get("preconditions").remove(this.preconditions);
        if (preconditions != null) {
            this.preconditions = new V1PreconditionsBuilder(preconditions);
            this._visitables.get("preconditions").add(this.preconditions);
        } else {
            this.preconditions = null;
            this._visitables.get("preconditions").remove(this.preconditions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPreconditions() {
        return this.preconditions != null;
    }

    @Override
    public V1DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditions() {
        return new PreconditionsNestedImpl();
    }

    @Override
    public V1DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditionsLike(V1Preconditions item) {
        return new PreconditionsNestedImpl(item);
    }

    @Override
    public V1DeleteOptionsFluent.PreconditionsNested<A> editPreconditions() {
        return this.withNewPreconditionsLike(this.getPreconditions());
    }

    @Override
    public V1DeleteOptionsFluent.PreconditionsNested<A> editOrNewPreconditions() {
        return this.withNewPreconditionsLike(this.getPreconditions() != null ? this.getPreconditions() : new V1PreconditionsBuilder().build());
    }

    @Override
    public V1DeleteOptionsFluent.PreconditionsNested<A> editOrNewPreconditionsLike(V1Preconditions item) {
        return this.withNewPreconditionsLike(this.getPreconditions() != null ? this.getPreconditions() : item);
    }

    @Override
    public String getPropagationPolicy() {
        return this.propagationPolicy;
    }

    @Override
    public A withPropagationPolicy(String propagationPolicy) {
        this.propagationPolicy = propagationPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPropagationPolicy() {
        return this.propagationPolicy != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1DeleteOptionsFluentImpl that = (V1DeleteOptionsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.dryRun != null ? !this.dryRun.equals(that.dryRun) : that.dryRun != null) {
            return false;
        }
        if (this.gracePeriodSeconds != null ? !this.gracePeriodSeconds.equals(that.gracePeriodSeconds) : that.gracePeriodSeconds != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.orphanDependents != null ? !this.orphanDependents.equals(that.orphanDependents) : that.orphanDependents != null) {
            return false;
        }
        if (this.preconditions != null ? !this.preconditions.equals(that.preconditions) : that.preconditions != null) {
            return false;
        }
        return !(this.propagationPolicy != null ? !this.propagationPolicy.equals(that.propagationPolicy) : that.propagationPolicy != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.dryRun, this.gracePeriodSeconds, this.kind, this.orphanDependents, this.preconditions, this.propagationPolicy, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.dryRun != null && !this.dryRun.isEmpty()) {
            sb.append("dryRun:");
            sb.append(this.dryRun + ",");
        }
        if (this.gracePeriodSeconds != null) {
            sb.append("gracePeriodSeconds:");
            sb.append(this.gracePeriodSeconds + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.orphanDependents != null) {
            sb.append("orphanDependents:");
            sb.append(this.orphanDependents + ",");
        }
        if (this.preconditions != null) {
            sb.append("preconditions:");
            sb.append(this.preconditions + ",");
        }
        if (this.propagationPolicy != null) {
            sb.append("propagationPolicy:");
            sb.append(this.propagationPolicy);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withOrphanDependents() {
        return this.withOrphanDependents(true);
    }

    class PreconditionsNestedImpl<N>
    extends V1PreconditionsFluentImpl<V1DeleteOptionsFluent.PreconditionsNested<N>>
    implements V1DeleteOptionsFluent.PreconditionsNested<N>,
    Nested<N> {
        V1PreconditionsBuilder builder;

        PreconditionsNestedImpl(V1Preconditions item) {
            this.builder = new V1PreconditionsBuilder(this, item);
        }

        PreconditionsNestedImpl() {
            this.builder = new V1PreconditionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1DeleteOptionsFluentImpl.this.withPreconditions(this.builder.build());
        }

        @Override
        public N endPreconditions() {
            return this.and();
        }
    }
}

