/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1HTTPIngressRuleValue;
import io.kubernetes.client.openapi.models.V1HTTPIngressRuleValueBuilder;
import io.kubernetes.client.openapi.models.V1HTTPIngressRuleValueFluentImpl;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1IngressRuleFluent;
import java.util.Objects;

public class V1IngressRuleFluentImpl<A extends V1IngressRuleFluent<A>>
extends BaseFluent<A>
implements V1IngressRuleFluent<A> {
    private String host;
    private V1HTTPIngressRuleValueBuilder http;

    public V1IngressRuleFluentImpl() {
    }

    public V1IngressRuleFluentImpl(V1IngressRule instance) {
        this.withHost(instance.getHost());
        this.withHttp(instance.getHttp());
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    @Deprecated
    public V1HTTPIngressRuleValue getHttp() {
        return this.http != null ? this.http.build() : null;
    }

    @Override
    public V1HTTPIngressRuleValue buildHttp() {
        return this.http != null ? this.http.build() : null;
    }

    @Override
    public A withHttp(V1HTTPIngressRuleValue http) {
        this._visitables.get("http").remove(this.http);
        if (http != null) {
            this.http = new V1HTTPIngressRuleValueBuilder(http);
            this._visitables.get("http").add(this.http);
        } else {
            this.http = null;
            this._visitables.get("http").remove(this.http);
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttp() {
        return this.http != null;
    }

    @Override
    public V1IngressRuleFluent.HttpNested<A> withNewHttp() {
        return new HttpNestedImpl();
    }

    @Override
    public V1IngressRuleFluent.HttpNested<A> withNewHttpLike(V1HTTPIngressRuleValue item) {
        return new HttpNestedImpl(item);
    }

    @Override
    public V1IngressRuleFluent.HttpNested<A> editHttp() {
        return this.withNewHttpLike(this.getHttp());
    }

    @Override
    public V1IngressRuleFluent.HttpNested<A> editOrNewHttp() {
        return this.withNewHttpLike(this.getHttp() != null ? this.getHttp() : new V1HTTPIngressRuleValueBuilder().build());
    }

    @Override
    public V1IngressRuleFluent.HttpNested<A> editOrNewHttpLike(V1HTTPIngressRuleValue item) {
        return this.withNewHttpLike(this.getHttp() != null ? this.getHttp() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1IngressRuleFluentImpl that = (V1IngressRuleFluentImpl)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        return !(this.http != null ? !this.http.equals(that.http) : that.http != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.host, this.http, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.http != null) {
            sb.append("http:");
            sb.append(this.http);
        }
        sb.append("}");
        return sb.toString();
    }

    class HttpNestedImpl<N>
    extends V1HTTPIngressRuleValueFluentImpl<V1IngressRuleFluent.HttpNested<N>>
    implements V1IngressRuleFluent.HttpNested<N>,
    Nested<N> {
        V1HTTPIngressRuleValueBuilder builder;

        HttpNestedImpl(V1HTTPIngressRuleValue item) {
            this.builder = new V1HTTPIngressRuleValueBuilder(this, item);
        }

        HttpNestedImpl() {
            this.builder = new V1HTTPIngressRuleValueBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1IngressRuleFluentImpl.this.withHttp(this.builder.build());
        }

        @Override
        public N endHttp() {
            return this.and();
        }
    }
}

