/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1HostAlias;
import io.kubernetes.client.openapi.models.V1HostAliasFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1HostAliasFluentImpl<A extends V1HostAliasFluent<A>>
extends BaseFluent<A>
implements V1HostAliasFluent<A> {
    private List<String> hostnames;
    private String ip;

    public V1HostAliasFluentImpl() {
    }

    public V1HostAliasFluentImpl(V1HostAlias instance) {
        if (instance != null) {
            this.withHostnames(instance.getHostnames());
            this.withIp(instance.getIp());
        }
    }

    @Override
    public A addToHostnames(int index, String item) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHostnames(int index, String item) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHostnames(String ... items) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.hostnames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHostnames(Collection<String> items) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.hostnames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHostnames(String ... items) {
        for (String item : items) {
            if (this.hostnames == null) continue;
            this.hostnames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHostnames(Collection<String> items) {
        for (String item : items) {
            if (this.hostnames == null) continue;
            this.hostnames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getHostnames() {
        return this.hostnames;
    }

    @Override
    public String getHostname(int index) {
        return this.hostnames.get(index);
    }

    @Override
    public String getFirstHostname() {
        return this.hostnames.get(0);
    }

    @Override
    public String getLastHostname() {
        return this.hostnames.get(this.hostnames.size() - 1);
    }

    @Override
    public String getMatchingHostname(Predicate<String> predicate) {
        for (String item : this.hostnames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHostname(Predicate<String> predicate) {
        for (String item : this.hostnames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHostnames(List<String> hostnames) {
        if (hostnames != null) {
            this.hostnames = new ArrayList<String>();
            for (String item : hostnames) {
                this.addToHostnames(item);
            }
        } else {
            this.hostnames = null;
        }
        return (A)this;
    }

    @Override
    public A withHostnames(String ... hostnames) {
        if (this.hostnames != null) {
            this.hostnames.clear();
            this._visitables.remove("hostnames");
        }
        if (hostnames != null) {
            for (String item : hostnames) {
                this.addToHostnames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostnames() {
        return this.hostnames != null && !this.hostnames.isEmpty();
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    @Override
    public Boolean hasIp() {
        return this.ip != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1HostAliasFluentImpl that = (V1HostAliasFluentImpl)o;
        if (!Objects.equals(this.hostnames, that.hostnames)) {
            return false;
        }
        return Objects.equals(this.ip, that.ip);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostnames, this.ip, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostnames != null && !this.hostnames.isEmpty()) {
            sb.append("hostnames:");
            sb.append(this.hostnames + ",");
        }
        if (this.ip != null) {
            sb.append("ip:");
            sb.append(this.ip);
        }
        sb.append("}");
        return sb.toString();
    }
}

