/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1ConfigMap
implements KubernetesObject {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_BINARY_DATA = "binaryData";
    @SerializedName(value="binaryData")
    private Map<String, byte[]> binaryData = new HashMap<String, byte[]>();
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    private Map<String, String> data = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_IMMUTABLE = "immutable";
    @SerializedName(value="immutable")
    private Boolean immutable;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ConfigMap apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1ConfigMap binaryData(Map<String, byte[]> binaryData) {
        this.binaryData = binaryData;
        return this;
    }

    public V1ConfigMap putBinaryDataItem(String key, byte[] binaryDataItem) {
        if (this.binaryData == null) {
            this.binaryData = new HashMap<String, byte[]>();
        }
        this.binaryData.put(key, binaryDataItem);
        return this;
    }

    @Nullable
    public Map<String, byte[]> getBinaryData() {
        return this.binaryData;
    }

    public void setBinaryData(Map<String, byte[]> binaryData) {
        this.binaryData = binaryData;
    }

    public V1ConfigMap data(Map<String, String> data) {
        this.data = data;
        return this;
    }

    public V1ConfigMap putDataItem(String key, String dataItem) {
        if (this.data == null) {
            this.data = new HashMap<String, String>();
        }
        this.data.put(key, dataItem);
        return this;
    }

    @Nullable
    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public V1ConfigMap immutable(Boolean immutable) {
        this.immutable = immutable;
        return this;
    }

    @Nullable
    public Boolean getImmutable() {
        return this.immutable;
    }

    public void setImmutable(Boolean immutable) {
        this.immutable = immutable;
    }

    public V1ConfigMap kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1ConfigMap metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ConfigMap v1ConfigMap = (V1ConfigMap)o;
        return Objects.equals(this.apiVersion, v1ConfigMap.apiVersion) && Objects.equals(this.binaryData, v1ConfigMap.binaryData) && Objects.equals(this.data, v1ConfigMap.data) && Objects.equals(this.immutable, v1ConfigMap.immutable) && Objects.equals(this.kind, v1ConfigMap.kind) && Objects.equals(this.metadata, v1ConfigMap.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.binaryData, this.data, this.immutable, this.kind, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ConfigMap {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    binaryData: ").append(this.toIndentedString(this.binaryData)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    immutable: ").append(this.toIndentedString(this.immutable)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ConfigMap is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ConfigMap` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_METADATA).isJsonNull()) {
            V1ObjectMeta.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_METADATA));
        }
    }

    public static V1ConfigMap fromJson(String jsonString) throws IOException {
        return (V1ConfigMap)JSON.getGson().fromJson(jsonString, V1ConfigMap.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_BINARY_DATA);
        openapiFields.add(SERIALIZED_NAME_DATA);
        openapiFields.add(SERIALIZED_NAME_IMMUTABLE);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ConfigMap.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ConfigMap.class));
            return new TypeAdapter<V1ConfigMap>(){

                public void write(JsonWriter out, V1ConfigMap value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ConfigMap read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1ConfigMap.validateJsonObject(jsonObj);
                    return (V1ConfigMap)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

