/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1HostAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1HostAliasFluent<A extends V1HostAliasFluent<A>>
extends BaseFluent<A> {
    private List<String> hostnames;
    private String ip;

    public V1HostAliasFluent() {
    }

    public V1HostAliasFluent(V1HostAlias instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1HostAlias instance) {
        V1HostAlias v1HostAlias = instance = instance != null ? instance : new V1HostAlias();
        if (instance != null) {
            this.withHostnames(instance.getHostnames());
            this.withIp(instance.getIp());
        }
    }

    public A addToHostnames(int index, String item) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.add(index, item);
        return (A)this;
    }

    public A setToHostnames(int index, String item) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.set(index, item);
        return (A)this;
    }

    public A addToHostnames(String ... items) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.hostnames.add(item);
        }
        return (A)this;
    }

    public A addAllToHostnames(Collection<String> items) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.hostnames.add(item);
        }
        return (A)this;
    }

    public A removeFromHostnames(String ... items) {
        if (this.hostnames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.hostnames.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromHostnames(Collection<String> items) {
        if (this.hostnames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.hostnames.remove(item);
        }
        return (A)this;
    }

    public List<String> getHostnames() {
        return this.hostnames;
    }

    public String getHostname(int index) {
        return this.hostnames.get(index);
    }

    public String getFirstHostname() {
        return this.hostnames.get(0);
    }

    public String getLastHostname() {
        return this.hostnames.get(this.hostnames.size() - 1);
    }

    public String getMatchingHostname(Predicate<String> predicate) {
        for (String item : this.hostnames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingHostname(Predicate<String> predicate) {
        for (String item : this.hostnames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHostnames(List<String> hostnames) {
        if (hostnames != null) {
            this.hostnames = new ArrayList<String>();
            for (String item : hostnames) {
                this.addToHostnames(item);
            }
        } else {
            this.hostnames = null;
        }
        return (A)this;
    }

    public A withHostnames(String ... hostnames) {
        if (this.hostnames != null) {
            this.hostnames.clear();
            this._visitables.remove("hostnames");
        }
        if (hostnames != null) {
            for (String item : hostnames) {
                this.addToHostnames(item);
            }
        }
        return (A)this;
    }

    public boolean hasHostnames() {
        return this.hostnames != null && !this.hostnames.isEmpty();
    }

    public String getIp() {
        return this.ip;
    }

    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    public boolean hasIp() {
        return this.ip != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1HostAliasFluent that = (V1HostAliasFluent)o;
        if (!Objects.equals(this.hostnames, that.hostnames)) {
            return false;
        }
        return Objects.equals(this.ip, that.ip);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostnames, this.ip, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostnames != null && !this.hostnames.isEmpty()) {
            sb.append("hostnames:");
            sb.append(this.hostnames + ",");
        }
        if (this.ip != null) {
            sb.append("ip:");
            sb.append(this.ip);
        }
        sb.append("}");
        return sb.toString();
    }
}

