/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceFluent;
import io.kubernetes.client.openapi.models.V1ScaleIOVolumeSource;
import java.util.Objects;
import java.util.Optional;

public class V1ScaleIOVolumeSourceFluent<A extends V1ScaleIOVolumeSourceFluent<A>>
extends BaseFluent<A> {
    private String fsType;
    private String gateway;
    private String protectionDomain;
    private Boolean readOnly;
    private V1LocalObjectReferenceBuilder secretRef;
    private Boolean sslEnabled;
    private String storageMode;
    private String storagePool;
    private String system;
    private String volumeName;

    public V1ScaleIOVolumeSourceFluent() {
    }

    public V1ScaleIOVolumeSourceFluent(V1ScaleIOVolumeSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1ScaleIOVolumeSource instance) {
        V1ScaleIOVolumeSource v1ScaleIOVolumeSource = instance = instance != null ? instance : new V1ScaleIOVolumeSource();
        if (instance != null) {
            this.withFsType(instance.getFsType());
            this.withGateway(instance.getGateway());
            this.withProtectionDomain(instance.getProtectionDomain());
            this.withReadOnly(instance.getReadOnly());
            this.withSecretRef(instance.getSecretRef());
            this.withSslEnabled(instance.getSslEnabled());
            this.withStorageMode(instance.getStorageMode());
            this.withStoragePool(instance.getStoragePool());
            this.withSystem(instance.getSystem());
            this.withVolumeName(instance.getVolumeName());
        }
    }

    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    public boolean hasFsType() {
        return this.fsType != null;
    }

    public String getGateway() {
        return this.gateway;
    }

    public A withGateway(String gateway) {
        this.gateway = gateway;
        return (A)this;
    }

    public boolean hasGateway() {
        return this.gateway != null;
    }

    public String getProtectionDomain() {
        return this.protectionDomain;
    }

    public A withProtectionDomain(String protectionDomain) {
        this.protectionDomain = protectionDomain;
        return (A)this;
    }

    public boolean hasProtectionDomain() {
        return this.protectionDomain != null;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public V1LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(V1LocalObjectReference secretRef) {
        this._visitables.remove("secretRef");
        if (secretRef != null) {
            this.secretRef = new V1LocalObjectReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get("secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public SecretRefNested<A> withNewSecretRefLike(V1LocalObjectReference item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new V1LocalObjectReferenceBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(V1LocalObjectReference item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public A withSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return (A)this;
    }

    public boolean hasSslEnabled() {
        return this.sslEnabled != null;
    }

    public String getStorageMode() {
        return this.storageMode;
    }

    public A withStorageMode(String storageMode) {
        this.storageMode = storageMode;
        return (A)this;
    }

    public boolean hasStorageMode() {
        return this.storageMode != null;
    }

    public String getStoragePool() {
        return this.storagePool;
    }

    public A withStoragePool(String storagePool) {
        this.storagePool = storagePool;
        return (A)this;
    }

    public boolean hasStoragePool() {
        return this.storagePool != null;
    }

    public String getSystem() {
        return this.system;
    }

    public A withSystem(String system) {
        this.system = system;
        return (A)this;
    }

    public boolean hasSystem() {
        return this.system != null;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)this;
    }

    public boolean hasVolumeName() {
        return this.volumeName != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ScaleIOVolumeSourceFluent that = (V1ScaleIOVolumeSourceFluent)o;
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.gateway, that.gateway)) {
            return false;
        }
        if (!Objects.equals(this.protectionDomain, that.protectionDomain)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals(this.secretRef, that.secretRef)) {
            return false;
        }
        if (!Objects.equals(this.sslEnabled, that.sslEnabled)) {
            return false;
        }
        if (!Objects.equals(this.storageMode, that.storageMode)) {
            return false;
        }
        if (!Objects.equals(this.storagePool, that.storagePool)) {
            return false;
        }
        if (!Objects.equals(this.system, that.system)) {
            return false;
        }
        return Objects.equals(this.volumeName, that.volumeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fsType, this.gateway, this.protectionDomain, this.readOnly, this.secretRef, this.sslEnabled, this.storageMode, this.storagePool, this.system, this.volumeName, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.gateway != null) {
            sb.append("gateway:");
            sb.append(this.gateway + ",");
        }
        if (this.protectionDomain != null) {
            sb.append("protectionDomain:");
            sb.append(this.protectionDomain + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.sslEnabled != null) {
            sb.append("sslEnabled:");
            sb.append(this.sslEnabled + ",");
        }
        if (this.storageMode != null) {
            sb.append("storageMode:");
            sb.append(this.storageMode + ",");
        }
        if (this.storagePool != null) {
            sb.append("storagePool:");
            sb.append(this.storagePool + ",");
        }
        if (this.system != null) {
            sb.append("system:");
            sb.append(this.system + ",");
        }
        if (this.volumeName != null) {
            sb.append("volumeName:");
            sb.append(this.volumeName);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public A withSslEnabled() {
        return this.withSslEnabled(true);
    }

    public class SecretRefNested<N>
    extends V1LocalObjectReferenceFluent<SecretRefNested<N>>
    implements Nested<N> {
        V1LocalObjectReferenceBuilder builder;

        SecretRefNested(V1LocalObjectReference item) {
            this.builder = new V1LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ScaleIOVolumeSourceFluent.this.withSecretRef(this.builder.build());
        }

        public N endSecretRef() {
            return this.and();
        }
    }
}

