/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1NonResourceRule;
import io.kubernetes.client.openapi.models.V1NonResourceRuleBuilder;
import io.kubernetes.client.openapi.models.V1NonResourceRuleFluent;
import io.kubernetes.client.openapi.models.V1ResourceRule;
import io.kubernetes.client.openapi.models.V1ResourceRuleBuilder;
import io.kubernetes.client.openapi.models.V1ResourceRuleFluent;
import io.kubernetes.client.openapi.models.V1SubjectRulesReviewStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1SubjectRulesReviewStatusFluent<A extends V1SubjectRulesReviewStatusFluent<A>>
extends BaseFluent<A> {
    private String evaluationError;
    private Boolean incomplete;
    private ArrayList<V1NonResourceRuleBuilder> nonResourceRules;
    private ArrayList<V1ResourceRuleBuilder> resourceRules;

    public V1SubjectRulesReviewStatusFluent() {
    }

    public V1SubjectRulesReviewStatusFluent(V1SubjectRulesReviewStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1SubjectRulesReviewStatus instance) {
        V1SubjectRulesReviewStatus v1SubjectRulesReviewStatus = instance = instance != null ? instance : new V1SubjectRulesReviewStatus();
        if (instance != null) {
            this.withEvaluationError(instance.getEvaluationError());
            this.withIncomplete(instance.getIncomplete());
            this.withNonResourceRules(instance.getNonResourceRules());
            this.withResourceRules(instance.getResourceRules());
        }
    }

    public String getEvaluationError() {
        return this.evaluationError;
    }

    public A withEvaluationError(String evaluationError) {
        this.evaluationError = evaluationError;
        return (A)this;
    }

    public boolean hasEvaluationError() {
        return this.evaluationError != null;
    }

    public Boolean getIncomplete() {
        return this.incomplete;
    }

    public A withIncomplete(Boolean incomplete) {
        this.incomplete = incomplete;
        return (A)this;
    }

    public boolean hasIncomplete() {
        return this.incomplete != null;
    }

    public A addToNonResourceRules(int index, V1NonResourceRule item) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        V1NonResourceRuleBuilder builder = new V1NonResourceRuleBuilder(item);
        if (index < 0 || index >= this.nonResourceRules.size()) {
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        } else {
            this._visitables.get("nonResourceRules").add(index, builder);
            this.nonResourceRules.add(index, builder);
        }
        return (A)this;
    }

    public A setToNonResourceRules(int index, V1NonResourceRule item) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        V1NonResourceRuleBuilder builder = new V1NonResourceRuleBuilder(item);
        if (index < 0 || index >= this.nonResourceRules.size()) {
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        } else {
            this._visitables.get("nonResourceRules").set(index, builder);
            this.nonResourceRules.set(index, builder);
        }
        return (A)this;
    }

    public A addToNonResourceRules(V1NonResourceRule ... items) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        for (V1NonResourceRule item : items) {
            V1NonResourceRuleBuilder builder = new V1NonResourceRuleBuilder(item);
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        }
        return (A)this;
    }

    public A addAllToNonResourceRules(Collection<V1NonResourceRule> items) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        for (V1NonResourceRule item : items) {
            V1NonResourceRuleBuilder builder = new V1NonResourceRuleBuilder(item);
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        }
        return (A)this;
    }

    public A removeFromNonResourceRules(V1NonResourceRule ... items) {
        if (this.nonResourceRules == null) {
            return (A)this;
        }
        for (V1NonResourceRule item : items) {
            V1NonResourceRuleBuilder builder = new V1NonResourceRuleBuilder(item);
            this._visitables.get("nonResourceRules").remove(builder);
            this.nonResourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromNonResourceRules(Collection<V1NonResourceRule> items) {
        if (this.nonResourceRules == null) {
            return (A)this;
        }
        for (V1NonResourceRule item : items) {
            V1NonResourceRuleBuilder builder = new V1NonResourceRuleBuilder(item);
            this._visitables.get("nonResourceRules").remove(builder);
            this.nonResourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromNonResourceRules(Predicate<V1NonResourceRuleBuilder> predicate) {
        if (this.nonResourceRules == null) {
            return (A)this;
        }
        Iterator<V1NonResourceRuleBuilder> each = this.nonResourceRules.iterator();
        Object visitables = this._visitables.get("nonResourceRules");
        while (each.hasNext()) {
            V1NonResourceRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1NonResourceRule> buildNonResourceRules() {
        return this.nonResourceRules != null ? V1SubjectRulesReviewStatusFluent.build(this.nonResourceRules) : null;
    }

    public V1NonResourceRule buildNonResourceRule(int index) {
        return this.nonResourceRules.get(index).build();
    }

    public V1NonResourceRule buildFirstNonResourceRule() {
        return this.nonResourceRules.get(0).build();
    }

    public V1NonResourceRule buildLastNonResourceRule() {
        return this.nonResourceRules.get(this.nonResourceRules.size() - 1).build();
    }

    public V1NonResourceRule buildMatchingNonResourceRule(Predicate<V1NonResourceRuleBuilder> predicate) {
        for (V1NonResourceRuleBuilder item : this.nonResourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingNonResourceRule(Predicate<V1NonResourceRuleBuilder> predicate) {
        for (V1NonResourceRuleBuilder item : this.nonResourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNonResourceRules(List<V1NonResourceRule> nonResourceRules) {
        if (this.nonResourceRules != null) {
            this._visitables.get("nonResourceRules").clear();
        }
        if (nonResourceRules != null) {
            this.nonResourceRules = new ArrayList();
            for (V1NonResourceRule item : nonResourceRules) {
                this.addToNonResourceRules(item);
            }
        } else {
            this.nonResourceRules = null;
        }
        return (A)this;
    }

    public A withNonResourceRules(V1NonResourceRule ... nonResourceRules) {
        if (this.nonResourceRules != null) {
            this.nonResourceRules.clear();
            this._visitables.remove("nonResourceRules");
        }
        if (nonResourceRules != null) {
            for (V1NonResourceRule item : nonResourceRules) {
                this.addToNonResourceRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasNonResourceRules() {
        return this.nonResourceRules != null && !this.nonResourceRules.isEmpty();
    }

    public NonResourceRulesNested<A> addNewNonResourceRule() {
        return new NonResourceRulesNested(-1, null);
    }

    public NonResourceRulesNested<A> addNewNonResourceRuleLike(V1NonResourceRule item) {
        return new NonResourceRulesNested(-1, item);
    }

    public NonResourceRulesNested<A> setNewNonResourceRuleLike(int index, V1NonResourceRule item) {
        return new NonResourceRulesNested(index, item);
    }

    public NonResourceRulesNested<A> editNonResourceRule(int index) {
        if (this.nonResourceRules.size() <= index) {
            throw new RuntimeException("Can't edit nonResourceRules. Index exceeds size.");
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    public NonResourceRulesNested<A> editFirstNonResourceRule() {
        if (this.nonResourceRules.size() == 0) {
            throw new RuntimeException("Can't edit first nonResourceRules. The list is empty.");
        }
        return this.setNewNonResourceRuleLike(0, this.buildNonResourceRule(0));
    }

    public NonResourceRulesNested<A> editLastNonResourceRule() {
        int index = this.nonResourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last nonResourceRules. The list is empty.");
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    public NonResourceRulesNested<A> editMatchingNonResourceRule(Predicate<V1NonResourceRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.nonResourceRules.size(); ++i) {
            if (!predicate.test(this.nonResourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching nonResourceRules. No match found.");
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    public A addToResourceRules(int index, V1ResourceRule item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        V1ResourceRuleBuilder builder = new V1ResourceRuleBuilder(item);
        if (index < 0 || index >= this.resourceRules.size()) {
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        } else {
            this._visitables.get("resourceRules").add(index, builder);
            this.resourceRules.add(index, builder);
        }
        return (A)this;
    }

    public A setToResourceRules(int index, V1ResourceRule item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        V1ResourceRuleBuilder builder = new V1ResourceRuleBuilder(item);
        if (index < 0 || index >= this.resourceRules.size()) {
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        } else {
            this._visitables.get("resourceRules").set(index, builder);
            this.resourceRules.set(index, builder);
        }
        return (A)this;
    }

    public A addToResourceRules(V1ResourceRule ... items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        for (V1ResourceRule item : items) {
            V1ResourceRuleBuilder builder = new V1ResourceRuleBuilder(item);
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)this;
    }

    public A addAllToResourceRules(Collection<V1ResourceRule> items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        for (V1ResourceRule item : items) {
            V1ResourceRuleBuilder builder = new V1ResourceRuleBuilder(item);
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)this;
    }

    public A removeFromResourceRules(V1ResourceRule ... items) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        for (V1ResourceRule item : items) {
            V1ResourceRuleBuilder builder = new V1ResourceRuleBuilder(item);
            this._visitables.get("resourceRules").remove(builder);
            this.resourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResourceRules(Collection<V1ResourceRule> items) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        for (V1ResourceRule item : items) {
            V1ResourceRuleBuilder builder = new V1ResourceRuleBuilder(item);
            this._visitables.get("resourceRules").remove(builder);
            this.resourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResourceRules(Predicate<V1ResourceRuleBuilder> predicate) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        Iterator<V1ResourceRuleBuilder> each = this.resourceRules.iterator();
        Object visitables = this._visitables.get("resourceRules");
        while (each.hasNext()) {
            V1ResourceRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1ResourceRule> buildResourceRules() {
        return this.resourceRules != null ? V1SubjectRulesReviewStatusFluent.build(this.resourceRules) : null;
    }

    public V1ResourceRule buildResourceRule(int index) {
        return this.resourceRules.get(index).build();
    }

    public V1ResourceRule buildFirstResourceRule() {
        return this.resourceRules.get(0).build();
    }

    public V1ResourceRule buildLastResourceRule() {
        return this.resourceRules.get(this.resourceRules.size() - 1).build();
    }

    public V1ResourceRule buildMatchingResourceRule(Predicate<V1ResourceRuleBuilder> predicate) {
        for (V1ResourceRuleBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceRule(Predicate<V1ResourceRuleBuilder> predicate) {
        for (V1ResourceRuleBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceRules(List<V1ResourceRule> resourceRules) {
        if (this.resourceRules != null) {
            this._visitables.get("resourceRules").clear();
        }
        if (resourceRules != null) {
            this.resourceRules = new ArrayList();
            for (V1ResourceRule item : resourceRules) {
                this.addToResourceRules(item);
            }
        } else {
            this.resourceRules = null;
        }
        return (A)this;
    }

    public A withResourceRules(V1ResourceRule ... resourceRules) {
        if (this.resourceRules != null) {
            this.resourceRules.clear();
            this._visitables.remove("resourceRules");
        }
        if (resourceRules != null) {
            for (V1ResourceRule item : resourceRules) {
                this.addToResourceRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasResourceRules() {
        return this.resourceRules != null && !this.resourceRules.isEmpty();
    }

    public ResourceRulesNested<A> addNewResourceRule() {
        return new ResourceRulesNested(-1, null);
    }

    public ResourceRulesNested<A> addNewResourceRuleLike(V1ResourceRule item) {
        return new ResourceRulesNested(-1, item);
    }

    public ResourceRulesNested<A> setNewResourceRuleLike(int index, V1ResourceRule item) {
        return new ResourceRulesNested(index, item);
    }

    public ResourceRulesNested<A> editResourceRule(int index) {
        if (this.resourceRules.size() <= index) {
            throw new RuntimeException("Can't edit resourceRules. Index exceeds size.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public ResourceRulesNested<A> editFirstResourceRule() {
        if (this.resourceRules.size() == 0) {
            throw new RuntimeException("Can't edit first resourceRules. The list is empty.");
        }
        return this.setNewResourceRuleLike(0, this.buildResourceRule(0));
    }

    public ResourceRulesNested<A> editLastResourceRule() {
        int index = this.resourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceRules. The list is empty.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public ResourceRulesNested<A> editMatchingResourceRule(Predicate<V1ResourceRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceRules.size(); ++i) {
            if (!predicate.test(this.resourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceRules. No match found.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1SubjectRulesReviewStatusFluent that = (V1SubjectRulesReviewStatusFluent)o;
        if (!Objects.equals(this.evaluationError, that.evaluationError)) {
            return false;
        }
        if (!Objects.equals(this.incomplete, that.incomplete)) {
            return false;
        }
        if (!Objects.equals(this.nonResourceRules, that.nonResourceRules)) {
            return false;
        }
        return Objects.equals(this.resourceRules, that.resourceRules);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.evaluationError, this.incomplete, this.nonResourceRules, this.resourceRules, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.evaluationError != null) {
            sb.append("evaluationError:");
            sb.append(this.evaluationError + ",");
        }
        if (this.incomplete != null) {
            sb.append("incomplete:");
            sb.append(this.incomplete + ",");
        }
        if (this.nonResourceRules != null && !this.nonResourceRules.isEmpty()) {
            sb.append("nonResourceRules:");
            sb.append(this.nonResourceRules + ",");
        }
        if (this.resourceRules != null && !this.resourceRules.isEmpty()) {
            sb.append("resourceRules:");
            sb.append(this.resourceRules);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withIncomplete() {
        return this.withIncomplete(true);
    }

    public class NonResourceRulesNested<N>
    extends V1NonResourceRuleFluent<NonResourceRulesNested<N>>
    implements Nested<N> {
        V1NonResourceRuleBuilder builder;
        int index;

        NonResourceRulesNested(int index, V1NonResourceRule item) {
            this.index = index;
            this.builder = new V1NonResourceRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1SubjectRulesReviewStatusFluent.this.setToNonResourceRules(this.index, this.builder.build());
        }

        public N endNonResourceRule() {
            return this.and();
        }
    }

    public class ResourceRulesNested<N>
    extends V1ResourceRuleFluent<ResourceRulesNested<N>>
    implements Nested<N> {
        V1ResourceRuleBuilder builder;
        int index;

        ResourceRulesNested(int index, V1ResourceRule item) {
            this.index = index;
            this.builder = new V1ResourceRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1SubjectRulesReviewStatusFluent.this.setToResourceRules(this.index, this.builder.build());
        }

        public N endResourceRule() {
            return this.and();
        }
    }
}

