/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1SuccessPolicy;
import io.kubernetes.client.openapi.models.V1SuccessPolicyRule;
import io.kubernetes.client.openapi.models.V1SuccessPolicyRuleBuilder;
import io.kubernetes.client.openapi.models.V1SuccessPolicyRuleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1SuccessPolicyFluent<A extends V1SuccessPolicyFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1SuccessPolicyRuleBuilder> rules;

    public V1SuccessPolicyFluent() {
    }

    public V1SuccessPolicyFluent(V1SuccessPolicy instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1SuccessPolicy instance) {
        V1SuccessPolicy v1SuccessPolicy = instance = instance != null ? instance : new V1SuccessPolicy();
        if (instance != null) {
            this.withRules(instance.getRules());
        }
    }

    public A addToRules(int index, V1SuccessPolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        V1SuccessPolicyRuleBuilder builder = new V1SuccessPolicyRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").add(index, builder);
            this.rules.add(index, builder);
        }
        return (A)this;
    }

    public A setToRules(int index, V1SuccessPolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        V1SuccessPolicyRuleBuilder builder = new V1SuccessPolicyRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").set(index, builder);
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    public A addToRules(V1SuccessPolicyRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (V1SuccessPolicyRule item : items) {
            V1SuccessPolicyRuleBuilder builder = new V1SuccessPolicyRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    public A addAllToRules(Collection<V1SuccessPolicyRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (V1SuccessPolicyRule item : items) {
            V1SuccessPolicyRuleBuilder builder = new V1SuccessPolicyRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    public A removeFromRules(V1SuccessPolicyRule ... items) {
        if (this.rules == null) {
            return (A)this;
        }
        for (V1SuccessPolicyRule item : items) {
            V1SuccessPolicyRuleBuilder builder = new V1SuccessPolicyRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            this.rules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRules(Collection<V1SuccessPolicyRule> items) {
        if (this.rules == null) {
            return (A)this;
        }
        for (V1SuccessPolicyRule item : items) {
            V1SuccessPolicyRuleBuilder builder = new V1SuccessPolicyRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            this.rules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRules(Predicate<V1SuccessPolicyRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<V1SuccessPolicyRuleBuilder> each = this.rules.iterator();
        Object visitables = this._visitables.get("rules");
        while (each.hasNext()) {
            V1SuccessPolicyRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1SuccessPolicyRule> buildRules() {
        return this.rules != null ? V1SuccessPolicyFluent.build(this.rules) : null;
    }

    public V1SuccessPolicyRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    public V1SuccessPolicyRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    public V1SuccessPolicyRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    public V1SuccessPolicyRule buildMatchingRule(Predicate<V1SuccessPolicyRuleBuilder> predicate) {
        for (V1SuccessPolicyRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRule(Predicate<V1SuccessPolicyRuleBuilder> predicate) {
        for (V1SuccessPolicyRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRules(List<V1SuccessPolicyRule> rules) {
        if (this.rules != null) {
            this._visitables.get("rules").clear();
        }
        if (rules != null) {
            this.rules = new ArrayList();
            for (V1SuccessPolicyRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    public A withRules(V1SuccessPolicyRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
            this._visitables.remove("rules");
        }
        if (rules != null) {
            for (V1SuccessPolicyRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    public RulesNested<A> addNewRule() {
        return new RulesNested(-1, null);
    }

    public RulesNested<A> addNewRuleLike(V1SuccessPolicyRule item) {
        return new RulesNested(-1, item);
    }

    public RulesNested<A> setNewRuleLike(int index, V1SuccessPolicyRule item) {
        return new RulesNested(index, item);
    }

    public RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    public RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editMatchingRule(Predicate<V1SuccessPolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1SuccessPolicyFluent that = (V1SuccessPolicyFluent)o;
        return Objects.equals(this.rules, that.rules);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rules, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.rules != null && !this.rules.isEmpty()) {
            sb.append("rules:");
            sb.append(this.rules);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RulesNested<N>
    extends V1SuccessPolicyRuleFluent<RulesNested<N>>
    implements Nested<N> {
        V1SuccessPolicyRuleBuilder builder;
        int index;

        RulesNested(int index, V1SuccessPolicyRule item) {
            this.index = index;
            this.builder = new V1SuccessPolicyRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1SuccessPolicyFluent.this.setToRules(this.index, this.builder.build());
        }

        public N endRule() {
            return this.and();
        }
    }
}

