/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import io.kubernetes.client.custom.IntOrString;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class Yaml {
    private static Map<String, Class<?>> classes = new HashMap();
    private static Map<String, String> apiGroups = new HashMap<String, String>();
    private static List<String> apiVersions = new ArrayList<String>();
    static final Logger logger = LoggerFactory.getLogger(Yaml.class);

    private static void initApiGroupMap() {
        apiGroups.put("Admissionregistration", "admissionregistration.k8s.io");
        apiGroups.put("Apiextensions", "apiextensions.k8s.io");
        apiGroups.put("Apiregistration", "apiregistration.k8s.io");
        apiGroups.put("Apps", "apps");
        apiGroups.put("Authentication", "authentication.k8s.io");
        apiGroups.put("Authorization", "authorization.k8s.io");
        apiGroups.put("Autoscaling", "autoscaling");
        apiGroups.put("Extensions", "extensions");
        apiGroups.put("Batch", "batch");
        apiGroups.put("Certificates", "certificates.k8s.io");
        apiGroups.put("Networking", "networking.k8s.io");
        apiGroups.put("Policy", "policy");
        apiGroups.put("RbacAuthorization", "rbac.authorization.k8s.io");
        apiGroups.put("Scheduling", "scheduling.k8s.io");
        apiGroups.put("Settings", "settings.k8s.io");
        apiGroups.put("Storage", "storage.k8s.io");
    }

    private static void initApiVersionList() {
        apiVersions.add("V2beta1");
        apiVersions.add("V2alpha1");
        apiVersions.add("V1beta2");
        apiVersions.add("V1beta1");
        apiVersions.add("V1alpha1");
        apiVersions.add("V1");
    }

    private static Pair<String, String> getApiGroup(String name) {
        MutablePair parts = new MutablePair();
        for (String prefix : apiGroups.keySet()) {
            if (!name.startsWith(prefix)) continue;
            parts.left = apiGroups.get(prefix);
            parts.right = name.substring(prefix.length());
            break;
        }
        if (parts.left == null) {
            parts.right = name;
        }
        return parts;
    }

    private static Pair<String, String> getApiVersion(String name) {
        MutablePair parts = new MutablePair();
        for (String version : apiVersions) {
            if (!name.startsWith(version)) continue;
            parts.left = version.toLowerCase();
            parts.right = name.substring(version.length());
            break;
        }
        if (parts.left == null) {
            parts.right = name;
        }
        return parts;
    }

    private static void initModelMap() throws IOException {
        Yaml.initApiGroupMap();
        Yaml.initApiVersionList();
        ClassPath cp = ClassPath.from((ClassLoader)ClassLoader.getSystemClassLoader());
        ImmutableSet allClasses = cp.getTopLevelClasses("io.kubernetes.client.models");
        for (ClassPath.ClassInfo clazz : allClasses) {
            String modelName = "";
            Pair<String, String> nameParts = Yaml.getApiGroup(clazz.getSimpleName());
            modelName = modelName + (nameParts.getLeft() == null ? "" : (String)nameParts.getLeft() + "/");
            nameParts = Yaml.getApiVersion((String)nameParts.getRight());
            modelName = modelName + (nameParts.getLeft() == null ? "" : (String)nameParts.getLeft() + "/");
            modelName = modelName + (String)nameParts.getRight();
            classes.put(modelName, clazz.load());
        }
    }

    public static void addModelMap(String apiGroupVersion, String kind, Class<?> clazz) {
        classes.put(apiGroupVersion + "/" + kind, clazz);
    }

    public static Object load(String content) throws IOException {
        return Yaml.load(new StringReader(content));
    }

    public static Object load(File f) throws IOException {
        return Yaml.load(new FileReader(f));
    }

    public static Object load(Reader reader) throws IOException {
        Map data = (Map)Yaml.getSnakeYaml().load(reader);
        return Yaml.modelMapper(data);
    }

    public static <T> T loadAs(String content, Class<T> clazz) {
        return (T)Yaml.getSnakeYaml().loadAs((Reader)new StringReader(content), clazz);
    }

    public static <T> T loadAs(File f, Class<T> clazz) throws IOException {
        return (T)Yaml.getSnakeYaml().loadAs((Reader)new FileReader(f), clazz);
    }

    public static <T> T loadAs(Reader reader, Class<T> clazz) {
        return (T)Yaml.getSnakeYaml().loadAs(reader, clazz);
    }

    public static List<Object> loadAll(String content) throws IOException {
        return Yaml.loadAll(new StringReader(content));
    }

    public static List<Object> loadAll(File f) throws IOException {
        return Yaml.loadAll(new FileReader(f));
    }

    public static List<Object> loadAll(Reader reader) throws IOException {
        Iterable iterable = Yaml.getSnakeYaml().loadAll(reader);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : iterable) {
            if (object == null) continue;
            try {
                list.add(Yaml.modelMapper((Map)object));
            }
            catch (ClassCastException ex) {
                logger.error("Unexpected exception while casting: " + ex);
            }
        }
        return list;
    }

    public static org.yaml.snakeyaml.Yaml getSnakeYaml() {
        return new org.yaml.snakeyaml.Yaml((BaseConstructor)new CustomConstructor());
    }

    private static Object modelMapper(Map<String, Object> data) throws IOException {
        String kind = (String)data.get("kind");
        if (kind == null) {
            throw new IOException("Missing kind in YAML file!");
        }
        String apiVersion = (String)data.get("apiVersion");
        if (apiVersion == null) {
            throw new IOException("Missing apiVersion in YAML file!");
        }
        Class<?> clazz = classes.get(apiVersion + "/" + kind);
        if (clazz == null && apiVersion.contains("/")) {
            clazz = classes.get(apiVersion.split("/")[1] + "/" + kind);
        }
        if (clazz == null) {
            throw new IOException("Unknown apiVersionKind: " + apiVersion + "/" + kind + " known kinds are: " + classes.toString());
        }
        return Yaml.loadAs(new StringReader(Yaml.getSnakeYaml().dump(data)), clazz);
    }

    static {
        try {
            Yaml.initModelMap();
        }
        catch (Exception ex) {
            logger.error("Unexpected exception while loading classes: " + ex);
        }
    }

    public static class CustomConstructor
    extends Constructor {
        protected Object constructObject(Node node) {
            if (node.getType() == IntOrString.class) {
                return this.constructIntOrString((ScalarNode)node);
            }
            return super.constructObject(node);
        }

        private IntOrString constructIntOrString(ScalarNode node) {
            try {
                return new IntOrString(Integer.parseInt(node.getValue()));
            }
            catch (NumberFormatException err) {
                return new IntOrString(node.getValue());
            }
        }
    }
}

