/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer.cache;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.kubernetes.client.informer.ListerWatcher;
import io.kubernetes.client.informer.ResyncRunnable;
import io.kubernetes.client.informer.cache.DeltaFIFO;
import io.kubernetes.client.informer.cache.ReflectorRunnable;
import java.util.Deque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.MutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller<ApiType, ApiListType> {
    private static final Logger log = LoggerFactory.getLogger(Controller.class);
    private static final long DEFAULT_PERIOD = 1000L;
    private long fullResyncPeriod;
    private DeltaFIFO<ApiType> queue;
    private ListerWatcher<ApiType, ApiListType> listerWatcher;
    private ReflectorRunnable<ApiType, ApiListType> reflector;
    private Supplier<Boolean> resyncFunc;
    private Consumer<Deque<MutablePair<DeltaFIFO.DeltaType, Object>>> processFunc;
    private ScheduledExecutorService reflectExecutor;
    private ScheduledExecutorService resyncExecutor;
    private ScheduledFuture resyncFuture;
    private Class<ApiType> apiTypeClass;
    private ScheduledFuture reflectorFuture;

    public Controller(Class<ApiType> apiTypeClass, DeltaFIFO<ApiType> queue, ListerWatcher<ApiType, ApiListType> listerWatcher, Consumer<Deque<MutablePair<DeltaFIFO.DeltaType, Object>>> processFunc, Supplier<Boolean> resyncFunc, long fullResyncPeriod) {
        this.queue = queue;
        this.listerWatcher = listerWatcher;
        this.apiTypeClass = apiTypeClass;
        this.processFunc = processFunc;
        this.resyncFunc = resyncFunc;
        this.fullResyncPeriod = fullResyncPeriod;
        this.reflectExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("controller-reflector-" + apiTypeClass.getName() + "-%d").build());
        this.resyncExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("controller-resync-" + apiTypeClass.getName() + "-%d").build());
    }

    public Controller(Class<ApiType> apiTypeClass, DeltaFIFO<ApiType> queue, ListerWatcher<ApiType, ApiListType> listerWatcher, Consumer<Deque<MutablePair<DeltaFIFO.DeltaType, Object>>> popProcessFunc) {
        this(apiTypeClass, queue, listerWatcher, popProcessFunc, null, 0L);
    }

    public void run() {
        log.info("informer#Controller: ready to run resync & reflector runnable");
        if (this.fullResyncPeriod > 0L) {
            ResyncRunnable<Object> resyncRunnable = new ResyncRunnable<Object>(this.queue, this.resyncFunc);
            this.resyncFuture = this.resyncExecutor.scheduleAtFixedRate(resyncRunnable::run, this.fullResyncPeriod, this.fullResyncPeriod, TimeUnit.MILLISECONDS);
        } else {
            log.info("informer#Controller: resync skipped due to 0 full resync period");
        }
        this.reflector = new ReflectorRunnable(this.apiTypeClass, this.listerWatcher, this.queue);
        this.reflectorFuture = this.reflectExecutor.scheduleWithFixedDelay(this.reflector::run, 0L, 1000L, TimeUnit.MILLISECONDS);
        this.processLoop();
    }

    public void stop() {
        this.reflector.stop();
        this.reflectorFuture.cancel(true);
        this.reflectExecutor.shutdown();
        if (this.resyncFuture != null) {
            this.resyncFuture.cancel(true);
            this.resyncExecutor.shutdown();
        }
    }

    public boolean hasSynced() {
        return this.queue.hasSynced();
    }

    public String lastSyncResourceVersion() {
        if (this.reflector == null) {
            return "";
        }
        return this.reflector.getLastSyncResourceVersion();
    }

    private void processLoop() {
        while (true) {
            try {
                while (true) {
                    this.queue.pop(this.processFunc);
                }
            }
            catch (InterruptedException t) {
                log.error("DefaultController#processLoop get interrupted {}", (Object)t.getMessage(), (Object)t);
                continue;
            }
            break;
        }
    }
}

