/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster.models.slots;

import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.internal.HostAndPort;
import io.lettuce.core.internal.LettuceAssert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ClusterSlotRange
implements Serializable {
    private int from;
    private int to;
    private RedisClusterNode masterNode;
    private List<RedisClusterNode> slaveNodes = Collections.emptyList();

    public ClusterSlotRange() {
    }

    public ClusterSlotRange(int from, int to, RedisClusterNode masterNode, List<RedisClusterNode> slaveNodes) {
        LettuceAssert.notNull(masterNode, "MasterNode must not be null");
        LettuceAssert.notNull(slaveNodes, "SlaveNodes must not be null");
        this.from = from;
        this.to = to;
        this.masterNode = masterNode;
        this.slaveNodes = slaveNodes;
    }

    private RedisClusterNode toRedisClusterNode(HostAndPort hostAndPort, String slaveOf, Set<RedisClusterNode.NodeFlag> flags) {
        int port = hostAndPort.hasPort() ? hostAndPort.getPort() : 6379;
        RedisClusterNode redisClusterNode = new RedisClusterNode();
        redisClusterNode.setUri(RedisURI.create(hostAndPort.getHostText(), port));
        redisClusterNode.setSlaveOf(slaveOf);
        redisClusterNode.setFlags(flags);
        return redisClusterNode;
    }

    private List<RedisClusterNode> toRedisClusterNodes(List<HostAndPort> hostAndPorts, String slaveOf, Set<RedisClusterNode.NodeFlag> flags) {
        ArrayList<RedisClusterNode> result = new ArrayList<RedisClusterNode>();
        for (HostAndPort hostAndPort : hostAndPorts) {
            result.add(this.toRedisClusterNode(hostAndPort, slaveOf, flags));
        }
        return result;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public RedisClusterNode getMasterNode() {
        return this.masterNode;
    }

    public void setMasterNode(RedisClusterNode masterNode) {
        this.masterNode = masterNode;
    }

    public List<RedisClusterNode> getSlaveNodes() {
        return this.slaveNodes;
    }

    public void setSlaveNodes(List<RedisClusterNode> slaveNodes) {
        this.slaveNodes = slaveNodes;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public void setTo(int to) {
        this.to = to;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [from=").append(this.from);
        sb.append(", to=").append(this.to);
        sb.append(", masterNode=").append(this.masterNode);
        sb.append(", slaveNodes=").append(this.slaveNodes);
        sb.append(']');
        return sb.toString();
    }
}

