/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.internal;

import io.lettuce.core.internal.LettuceAssert;
import io.netty.channel.ChannelFuture;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public abstract class Futures {
    private Futures() {
    }

    public static CompletableFuture<Void> allOf(Collection<? extends CompletableFuture<?>> futures) {
        LettuceAssert.notNull(futures, "Futures must not be null");
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public static <T> CompletableFuture<T> failed(Throwable throwable) {
        LettuceAssert.notNull((Object)throwable, "Throwable must not be null");
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(throwable);
        return future;
    }

    public static CompletableFuture<Void> from(ChannelFuture future) {
        LettuceAssert.notNull((Object)future, "ChannelFuture must not be null");
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Futures.adapt(future, result);
        return result;
    }

    public static void adapt(ChannelFuture future, CompletableFuture<Void> target) {
        future.addListener(f -> {
            if (f.isSuccess()) {
                target.complete(null);
            } else {
                target.completeExceptionally(f.cause());
            }
        });
        if (future.isSuccess()) {
            target.complete(null);
        } else if (future.isCancelled()) {
            target.cancel(false);
        } else if (future.isDone() && !future.isSuccess()) {
            target.completeExceptionally(future.cause());
        }
    }
}

