/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpParameters;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpParameters;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.micronaut.http.netty.stream.DefaultStreamedHttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Internal
class NettyClientHttpRequest<B>
implements MutableHttpRequest<B> {
    private final NettyHttpHeaders headers = new NettyHttpHeaders();
    private final MutableConvertibleValues<Object> attributes = new MutableConvertibleValuesMap();
    private final HttpMethod httpMethod;
    private URI uri;
    private B body;
    private NettyHttpParameters httpParameters;

    NettyClientHttpRequest(HttpMethod httpMethod, URI uri) {
        this.httpMethod = httpMethod;
        this.uri = uri;
    }

    NettyClientHttpRequest(HttpMethod httpMethod, String uri) {
        this.httpMethod = httpMethod;
        this.uri = URI.create(uri);
    }

    public MutableHttpHeaders getHeaders() {
        return this.headers;
    }

    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    public MutableHttpRequest<B> cookie(Cookie cookie) {
        if (!(cookie instanceof NettyCookie)) {
            throw new IllegalArgumentException("Argument is not a Netty compatible Cookie");
        }
        NettyCookie nettyCookie = (NettyCookie)cookie;
        String value = ClientCookieEncoder.LAX.encode(nettyCookie.getNettyCookie());
        this.headers.add((CharSequence)HttpHeaderNames.COOKIE, (CharSequence)value);
        return this;
    }

    public MutableHttpRequest<B> uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public Optional<B> getBody() {
        return Optional.ofNullable(this.body);
    }

    public <T> Optional<T> getBody(Class<T> type) {
        return this.getBody(Argument.of(type));
    }

    public <T> Optional<T> getBody(Argument<T> type) {
        return this.getBody().flatMap(b -> ConversionService.SHARED.convert(b, ConversionContext.of((Argument)type)));
    }

    public MutableHttpRequest<B> body(B body) {
        this.body = body;
        return this;
    }

    public Cookies getCookies() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableHttpParameters getParameters() {
        NettyHttpParameters httpParameters = this.httpParameters;
        if (httpParameters == null) {
            NettyClientHttpRequest nettyClientHttpRequest = this;
            synchronized (nettyClientHttpRequest) {
                httpParameters = this.httpParameters;
                if (httpParameters == null) {
                    this.httpParameters = httpParameters = this.decodeParameters(this.getUri().getRawPath());
                }
            }
        }
        return httpParameters;
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public URI getUri() {
        return this.uri;
    }

    private NettyHttpParameters decodeParameters(String uri) {
        QueryStringDecoder queryStringDecoder = this.createDecoder(uri);
        return new NettyHttpParameters(queryStringDecoder.parameters(), ConversionService.SHARED);
    }

    protected QueryStringDecoder createDecoder(String uri) {
        Charset charset = this.getCharacterEncoding();
        return charset != null ? new QueryStringDecoder(uri, charset) : new QueryStringDecoder(uri);
    }

    HttpRequest getFullRequest(ByteBuf content) {
        String uriStr = this.resolveUriPath();
        io.netty.handler.codec.http.HttpMethod method = io.netty.handler.codec.http.HttpMethod.valueOf((String)this.httpMethod.name());
        DefaultFullHttpRequest req = content != null ? new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uriStr, content) : new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uriStr);
        req.headers().setAll(this.headers.getNettyHeaders());
        return req;
    }

    HttpRequest getStreamedRequest(Publisher<HttpContent> publisher) {
        String uriStr = this.resolveUriPath();
        io.netty.handler.codec.http.HttpMethod method = io.netty.handler.codec.http.HttpMethod.valueOf((String)this.httpMethod.name());
        DefaultStreamedHttpRequest req = publisher != null ? new DefaultStreamedHttpRequest(HttpVersion.HTTP_1_1, method, uriStr, publisher) : new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uriStr);
        req.headers().setAll(this.headers.getNettyHeaders());
        return req;
    }

    private String resolveUriPath() {
        URI uri = this.getUri();
        if (StringUtils.isNotEmpty((CharSequence)uri.getScheme())) {
            try {
                uri = new URI(null, null, null, -1, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uri.toString();
    }

    public String toString() {
        return this.getMethod() + " " + this.uri;
    }
}

