/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequestFactory;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.NettyClientHttpRequest;
import io.micronaut.http.uri.UriTemplate;
import java.util.Map;

@Internal
public class NettyClientHttpRequestFactory
implements HttpRequestFactory {
    public <T> MutableHttpRequest<T> get(String uri) {
        return new NettyClientHttpRequest(HttpMethod.GET, uri);
    }

    public <T> MutableHttpRequest<T> post(String uri, T body) {
        HttpMethod method = HttpMethod.POST;
        return this.buildRequest(uri, body, method);
    }

    public <T> MutableHttpRequest<T> put(String uri, T body) {
        return this.buildRequest(uri, body, HttpMethod.PUT);
    }

    public <T> MutableHttpRequest<T> patch(String uri, T body) {
        return this.buildRequest(uri, body, HttpMethod.PATCH);
    }

    public <T> MutableHttpRequest<T> head(String uri) {
        return new NettyClientHttpRequest(HttpMethod.HEAD, uri);
    }

    public <T> MutableHttpRequest<T> options(String uri) {
        return new NettyClientHttpRequest(HttpMethod.OPTIONS, uri);
    }

    public <T> MutableHttpRequest<T> delete(String uri, T body) {
        return this.buildRequest(uri, body, HttpMethod.DELETE);
    }

    public <T> MutableHttpRequest<T> create(HttpMethod httpMethod, String uri) {
        return new NettyClientHttpRequest(httpMethod, uri);
    }

    private <T> MutableHttpRequest<T> buildRequest(String uri, T body, HttpMethod method) {
        if (uri.indexOf(123) > -1 && body != null) {
            uri = body instanceof Map ? UriTemplate.of((String)uri).expand((Map)body) : UriTemplate.of((String)uri).expand((Map)BeanMap.of(body));
        }
        return new NettyClientHttpRequest<T>(method, uri).body(body);
    }
}

