/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.reactor;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.ReactiveClientResultTransformer;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import javax.inject.Singleton;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Singleton
@Requires(classes={Mono.class})
@Internal
public class ReactorReactiveClientResultTransformer
implements ReactiveClientResultTransformer {
    @Override
    public Object transform(Object publisherResult) {
        if (publisherResult instanceof Mono) {
            Mono maybe = (Mono)publisherResult;
            return maybe.onErrorResume(throwable -> {
                HttpClientResponseException responseException;
                if (throwable instanceof HttpClientResponseException && (responseException = (HttpClientResponseException)((Object)((Object)throwable))).getStatus() == HttpStatus.NOT_FOUND) {
                    return Mono.empty();
                }
                return Mono.error((Throwable)throwable);
            });
        }
        if (publisherResult instanceof Flux) {
            Flux flux = (Flux)publisherResult;
            return flux.onErrorResume(throwable -> {
                HttpClientResponseException responseException;
                if (throwable instanceof HttpClientResponseException && (responseException = (HttpClientResponseException)((Object)((Object)throwable))).getStatus() == HttpStatus.NOT_FOUND) {
                    return Flux.empty();
                }
                return Flux.error((Throwable)throwable);
            });
        }
        return publisherResult;
    }
}

