/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.scope;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.exceptions.DependencyInjectionException;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.client.DefaultHttpClient;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.LoadBalancerResolver;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.http.client.loadbalance.FixedLoadBalancer;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.ParametrizedProvider;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import io.micronaut.websocket.WebSocketClient;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class ClientScope
implements CustomScope<Client>,
LifeCycle<ClientScope>,
ApplicationEventListener<RefreshEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ClientScope.class);
    private final Map<ClientKey, HttpClient> clients = new ConcurrentHashMap<ClientKey, HttpClient>();
    private final LoadBalancerResolver loadBalancerResolver;
    private final BeanContext beanContext;

    public ClientScope(LoadBalancerResolver loadBalancerResolver, BeanContext beanContext) {
        this.loadBalancerResolver = loadBalancerResolver;
        this.beanContext = beanContext;
    }

    public boolean isRunning() {
        return true;
    }

    public Class<Client> annotationType() {
        return Client.class;
    }

    public <T> T get(BeanResolutionContext resolutionContext, BeanDefinition<T> beanDefinition, BeanIdentifier identifier, Provider<T> provider) {
        BeanResolutionContext.Segment segment = (BeanResolutionContext.Segment)resolutionContext.getPath().currentSegment().orElseThrow(() -> new IllegalStateException("@Client used in invalid location"));
        Argument argument = segment.getArgument();
        AnnotationValue annotation = argument.getAnnotationMetadata().findAnnotation(Client.class).orElse(null);
        if (annotation == null) {
            throw new DependencyInjectionException(resolutionContext, argument, "ClientScope called for injection point that is not annotated with @Client");
        }
        if (!HttpClient.class.isAssignableFrom(argument.getType()) && !WebSocketClient.class.isAssignableFrom(argument.getType())) {
            throw new DependencyInjectionException(resolutionContext, argument, "@Client used on type that is not an HttpClient");
        }
        if (!(provider instanceof ParametrizedProvider)) {
            throw new DependencyInjectionException(resolutionContext, argument, "ClientScope called with invalid bean provider");
        }
        String value = (String)annotation.stringValue().orElseThrow(() -> new DependencyInjectionException(resolutionContext, argument, "No value specified for @Client"));
        return (T)this.clients.computeIfAbsent(new ClientKey(identifier, value), clientKey -> {
            String path = annotation.get((CharSequence)"path", String.class).orElse(null);
            HttpClient clientBean = this.beanContext.findBean(HttpClient.class, Qualifiers.byName((String)value)).orElse(null);
            Optional configurationClass = annotation.classValue("configuration");
            if (clientBean != null && path == null && !configurationClass.isPresent()) {
                return clientBean;
            }
            LoadBalancer loadBalancer = this.loadBalancerResolver.resolve(value).orElseThrow(() -> new DependencyInjectionException(resolutionContext, argument, "Invalid service reference [" + value + "] specified to @Client"));
            String contextPath = null;
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                contextPath = path;
            } else if (StringUtils.isNotEmpty((CharSequence)value) && value.startsWith("/")) {
                contextPath = value;
            } else if (loadBalancer instanceof FixedLoadBalancer) {
                contextPath = ((FixedLoadBalancer)loadBalancer).getUrl().getPath();
            }
            Optional clientSpecificConfig = this.beanContext.findBean(HttpClientConfiguration.class, Qualifiers.byName((String)value));
            Class<HttpClientConfiguration> defaultConfiguration = configurationClass.orElse(HttpClientConfiguration.class);
            HttpClientConfiguration configuration = clientSpecificConfig.orElseGet(() -> (HttpClientConfiguration)this.beanContext.getBean(defaultConfiguration));
            if (!(configuration instanceof HttpClientConfiguration)) {
                throw new IllegalStateException("Referenced HTTP client configuration class must be an instance of HttpClientConfiguration for injection point: " + segment);
            }
            HttpClient client = (HttpClient)((ParametrizedProvider)provider).get(new Object[]{loadBalancer, configuration, contextPath});
            if (client instanceof DefaultHttpClient) {
                DefaultHttpClient defaultClient = (DefaultHttpClient)client;
                defaultClient.setClientIdentifiers(value);
            }
            return client;
        });
    }

    public <T> Optional<T> remove(BeanIdentifier identifier) {
        return Optional.empty();
    }

    public ClientScope stop() {
        for (HttpClient httpClient : this.clients.values()) {
            try {
                httpClient.close();
            }
            catch (Throwable e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Error shutting down HTTP client: " + e.getMessage(), e);
            }
        }
        this.clients.clear();
        return this;
    }

    public void onApplicationEvent(RefreshEvent event) {
        this.refresh();
    }

    private static class ClientKey {
        final BeanIdentifier identifier;
        final String value;

        public ClientKey(BeanIdentifier identifier, String value) {
            this.identifier = identifier;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientKey clientKey = (ClientKey)o;
            return Objects.equals(this.identifier, clientKey.identifier) && Objects.equals(this.value, clientKey.value);
        }

        public int hashCode() {
            return Objects.hash(this.identifier, this.value);
        }
    }
}

