/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.PathMatcher;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.Toggleable;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseWrapper;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.ConnectTTLHandler;
import io.micronaut.http.client.DefaultHttpClientConfiguration;
import io.micronaut.http.client.FullNettyClientHttpResponse;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.NettyClientHttpRequest;
import io.micronaut.http.client.NettyStreamedHttpResponse;
import io.micronaut.http.client.RxHttpClient;
import io.micronaut.http.client.RxStreamingHttpClient;
import io.micronaut.http.client.exceptions.ContentLengthExceededException;
import io.micronaut.http.client.exceptions.HttpClientErrorDecoder;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.client.exceptions.ReadTimeoutException;
import io.micronaut.http.client.filters.ClientServerContextFilter;
import io.micronaut.http.client.multipart.MultipartBody;
import io.micronaut.http.client.sse.RxSseClient;
import io.micronaut.http.client.ssl.NettyClientSslBuilder;
import io.micronaut.http.client.websocket.NettyWebSocketClientHandler;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.FilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.http.multipart.MultipartException;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.channel.NettyThreadFactory;
import io.micronaut.http.netty.content.HttpContentUtil;
import io.micronaut.http.netty.stream.HttpStreamsClientHandler;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.micronaut.http.sse.Event;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.http.uri.UriTemplate;
import io.micronaut.jackson.ObjectMapperFactory;
import io.micronaut.jackson.codec.JsonMediaTypeCodec;
import io.micronaut.jackson.codec.JsonStreamMediaTypeCodec;
import io.micronaut.jackson.parser.JacksonProcessor;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.websocket.RxWebSocketClient;
import io.micronaut.websocket.annotation.ClientWebSocket;
import io.micronaut.websocket.annotation.OnMessage;
import io.micronaut.websocket.context.WebSocketBean;
import io.micronaut.websocket.context.WebSocketBeanRegistry;
import io.micronaut.websocket.exceptions.WebSocketSessionException;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.channel.pool.AbstractChannelPoolMap;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Cancellable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Prototype
@Internal
@BootstrapContextCompatible
@Primary
public class DefaultHttpClient
implements RxWebSocketClient,
RxHttpClient,
RxStreamingHttpClient,
RxSseClient,
Closeable,
AutoCloseable {
    protected static final String HANDLER_AGGREGATOR = "http-aggregator";
    protected static final String HANDLER_CHUNK = "chunk-writer";
    protected static final String HANDLER_STREAM = "stream-handler";
    protected static final String HANDLER_DECODER = "http-decoder";
    protected static final String HANDLER_CONNECT_TTL = "handler-connect-ttl";
    private static final String HANDLER_IDLE_STATE = "handler-idle-state";
    private static final String HANDLER_MICRONAUT_WEBSOCKET_CLIENT = "handler-micronaut-websocket-client";
    private static final String HANDLER_HTTP_PROXY = "handler-http-proxy";
    private static final String HANDLER_SOCKS_5_PROXY = "handler-socks5-proxy";
    private static final String HANDLER_MICRONAUT_FULL_HTTP_RESPONSE = "handler-micronaut-full-http-response";
    private static final String HANDLER_READ_TIMEOUT = "handler-read-timeout";
    private static final String HANDLER_HTTP_CLIENT_CODEC = "handler-http-client-codec";
    private static final String HANDLER_SSL = "handler-ssl";
    private static final String HANDLER_MICRONAUT_SSE_EVENT_STREAM = "handler-micronaut-sse-event-stream";
    private static final String HANDLER_MICRONAUT_SSE_CONTENT = "handler-micronaut-sse-content";
    private static final String HANDLER_MICRONAUT_HTTP_RESPONSE_STREAM = "handler-micronaut-http-response-stream";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpClient.class);
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String HANDLER_HTTP_CLIENT_INIT = "handler-http-client-init";
    protected final Bootstrap bootstrap;
    protected EventLoopGroup group;
    protected MediaTypeCodecRegistry mediaTypeCodecRegistry;
    protected ByteBufferFactory<ByteBufAllocator, ByteBuf> byteBufferFactory = new NettyByteBufferFactory();
    private final Scheduler scheduler;
    private final LoadBalancer loadBalancer;
    private final HttpClientConfiguration configuration;
    private final String contextPath;
    private final SslContext sslContext;
    private final AnnotationMetadataResolver annotationMetadataResolver;
    private final ThreadFactory threadFactory;
    private final List<HttpClientFilter> filters;
    private final Charset defaultCharset;
    private final ChannelPoolMap<RequestKey, ChannelPool> poolMap;
    private final Logger log;
    @Nullable
    private final Long readTimeoutMillis;
    @Nullable
    private final Long connectionTimeAliveMillis;
    private Set<String> clientIdentifiers = Collections.emptySet();
    private WebSocketBeanRegistry webSocketRegistry = WebSocketBeanRegistry.EMPTY;
    private RequestBinderRegistry requestBinderRegistry;

    public DefaultHttpClient(@Parameter LoadBalancer loadBalancer, @Parameter HttpClientConfiguration configuration, @Parameter @Nullable String contextPath, @Named(value="netty") @Nullable ThreadFactory threadFactory, NettyClientSslBuilder nettyClientSslBuilder, MediaTypeCodecRegistry codecRegistry, @Nullable AnnotationMetadataResolver annotationMetadataResolver, HttpClientFilter ... filters) {
        this(loadBalancer, configuration, contextPath, threadFactory, nettyClientSslBuilder, codecRegistry, annotationMetadataResolver, Arrays.asList(filters));
    }

    @Inject
    public DefaultHttpClient(@Parameter LoadBalancer loadBalancer, @Parameter HttpClientConfiguration configuration, @Parameter @Nullable String contextPath, @Named(value="netty") @Nullable ThreadFactory threadFactory, NettyClientSslBuilder nettyClientSslBuilder, MediaTypeCodecRegistry codecRegistry, @Nullable AnnotationMetadataResolver annotationMetadataResolver, List<HttpClientFilter> filters) {
        int maxConnections;
        this.loadBalancer = loadBalancer;
        this.defaultCharset = configuration.getDefaultCharset();
        this.contextPath = contextPath;
        this.bootstrap = new Bootstrap();
        this.configuration = configuration;
        this.sslContext = nettyClientSslBuilder.build(configuration.getSslConfiguration()).orElse(null);
        this.group = this.createEventLoopGroup(configuration, threadFactory);
        this.scheduler = Schedulers.from((Executor)this.group);
        this.threadFactory = threadFactory;
        ((Bootstrap)((Bootstrap)this.bootstrap.group(this.group)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        Optional<Duration> readTimeout = configuration.getReadTimeout();
        this.readTimeoutMillis = readTimeout.map(duration -> !duration.isNegative() ? Long.valueOf(duration.toMillis()) : null).orElse(null);
        Optional<Duration> connectTtl = configuration.getConnectTtl();
        this.connectionTimeAliveMillis = connectTtl.map(duration -> !duration.isNegative() ? Long.valueOf(duration.toMillis()) : null).orElse(null);
        final HttpClientConfiguration.ConnectionPoolConfiguration connectionPoolConfiguration = configuration.getConnectionPoolConfiguration();
        this.poolMap = connectionPoolConfiguration.isEnabled() ? ((maxConnections = connectionPoolConfiguration.getMaxConnections()) > -1 ? new AbstractChannelPoolMap<RequestKey, ChannelPool>(){

            protected ChannelPool newPool(RequestKey key) {
                Bootstrap newBootstrap = DefaultHttpClient.this.bootstrap.clone(DefaultHttpClient.this.group);
                newBootstrap.remoteAddress((SocketAddress)key.getRemoteAddress());
                AbstractChannelPoolHandler channelPoolHandler = DefaultHttpClient.this.newPoolHandler(key);
                Long acquireTimeoutMillis = connectionPoolConfiguration.getAcquireTimeout().map(Duration::toMillis).orElse(-1L);
                return new FixedChannelPool(newBootstrap, (ChannelPoolHandler)channelPoolHandler, ChannelHealthChecker.ACTIVE, (FixedChannelPool.AcquireTimeoutAction)(acquireTimeoutMillis > -1L ? FixedChannelPool.AcquireTimeoutAction.FAIL : null), acquireTimeoutMillis.longValue(), maxConnections, connectionPoolConfiguration.getMaxPendingAcquires());
            }
        } : new AbstractChannelPoolMap<RequestKey, ChannelPool>(){

            protected ChannelPool newPool(RequestKey key) {
                Bootstrap newBootstrap = DefaultHttpClient.this.bootstrap.clone(DefaultHttpClient.this.group);
                newBootstrap.remoteAddress((SocketAddress)key.getRemoteAddress());
                AbstractChannelPoolHandler channelPoolHandler = DefaultHttpClient.this.newPoolHandler(key);
                return new SimpleChannelPool(newBootstrap, (ChannelPoolHandler)channelPoolHandler);
            }
        }) : null;
        Optional<Duration> connectTimeout = configuration.getConnectTimeout();
        connectTimeout.ifPresent(duration -> {
            Bootstrap cfr_ignored_0 = (Bootstrap)this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Long.valueOf(duration.toMillis()).intValue());
        });
        for (Map.Entry<ChannelOption, Object> entry : configuration.getChannelOptions().entrySet()) {
            Object v = entry.getValue();
            if (v == null) continue;
            ChannelOption channelOption = entry.getKey();
            this.bootstrap.option(channelOption, v);
        }
        this.mediaTypeCodecRegistry = codecRegistry;
        this.filters = filters;
        this.annotationMetadataResolver = annotationMetadataResolver != null ? annotationMetadataResolver : AnnotationMetadataResolver.DEFAULT;
        this.log = configuration.getLoggerName().map(LoggerFactory::getLogger).orElse(LOG);
    }

    public DefaultHttpClient(URL url, HttpClientConfiguration configuration, NettyClientSslBuilder nettyClientSslBuilder, MediaTypeCodecRegistry codecRegistry, HttpClientFilter ... filters) {
        this(LoadBalancer.fixed(url), configuration, null, (ThreadFactory)new DefaultThreadFactory(MultithreadEventLoopGroup.class), nettyClientSslBuilder, codecRegistry, AnnotationMetadataResolver.DEFAULT, filters);
    }

    public DefaultHttpClient(LoadBalancer loadBalancer) {
        this(loadBalancer, (HttpClientConfiguration)new DefaultHttpClientConfiguration(), null, (ThreadFactory)new DefaultThreadFactory(MultithreadEventLoopGroup.class), new NettyClientSslBuilder(new ResourceResolver()), DefaultHttpClient.createDefaultMediaTypeRegistry(), AnnotationMetadataResolver.DEFAULT, new HttpClientFilter[0]);
    }

    public DefaultHttpClient(@Parameter URL url) {
        this(url, (HttpClientConfiguration)new DefaultHttpClientConfiguration());
    }

    public DefaultHttpClient(URL url, HttpClientConfiguration configuration) {
        this(LoadBalancer.fixed(url), configuration, null, (ThreadFactory)new DefaultThreadFactory(MultithreadEventLoopGroup.class), new NettyClientSslBuilder(new ResourceResolver()), DefaultHttpClient.createDefaultMediaTypeRegistry(), AnnotationMetadataResolver.DEFAULT, new HttpClientFilter[0]);
    }

    public DefaultHttpClient(URL url, HttpClientConfiguration configuration, String contextPath) {
        this(LoadBalancer.fixed(url), configuration, contextPath, (ThreadFactory)new DefaultThreadFactory(MultithreadEventLoopGroup.class), new NettyClientSslBuilder(new ResourceResolver()), DefaultHttpClient.createDefaultMediaTypeRegistry(), AnnotationMetadataResolver.DEFAULT, new HttpClientFilter[0]);
    }

    public DefaultHttpClient(LoadBalancer loadBalancer, HttpClientConfiguration configuration) {
        this(loadBalancer, configuration, null, (ThreadFactory)new DefaultThreadFactory(MultithreadEventLoopGroup.class), new NettyClientSslBuilder(new ResourceResolver()), DefaultHttpClient.createDefaultMediaTypeRegistry(), AnnotationMetadataResolver.DEFAULT, new HttpClientFilter[0]);
    }

    public DefaultHttpClient(LoadBalancer loadBalancer, HttpClientConfiguration configuration, String contextPath) {
        this(loadBalancer, configuration, contextPath, (ThreadFactory)new DefaultThreadFactory(MultithreadEventLoopGroup.class), new NettyClientSslBuilder(new ResourceResolver()), DefaultHttpClient.createDefaultMediaTypeRegistry(), AnnotationMetadataResolver.DEFAULT, new HttpClientFilter[0]);
    }

    public HttpClientConfiguration getConfiguration() {
        return this.configuration;
    }

    public Logger getLog() {
        return this.log;
    }

    public HttpClient start() {
        if (!this.isRunning()) {
            this.group = this.createEventLoopGroup(this.configuration, this.threadFactory);
        }
        return this;
    }

    public boolean isRunning() {
        return !this.group.isShutdown();
    }

    @PreDestroy
    public HttpClient stop() {
        if (this.isRunning()) {
            if (this.poolMap instanceof Iterable) {
                Iterable i = (Iterable)this.poolMap;
                for (Map.Entry entry : i) {
                    ChannelPool cp = (ChannelPool)entry.getValue();
                    try {
                        cp.close();
                    }
                    catch (Exception cause) {
                        this.log.error("Error shutting down HTTP client connection pool: " + cause.getMessage(), (Throwable)cause);
                    }
                }
            }
            Duration shutdownTimeout = this.configuration.getShutdownTimeout().orElse(Duration.ofMillis(100L));
            Future future = this.group.shutdownGracefully(1L, shutdownTimeout.toMillis(), TimeUnit.MILLISECONDS);
            future.addListener(f -> {
                if (!f.isSuccess() && this.log.isErrorEnabled()) {
                    Throwable cause = f.cause();
                    this.log.error("Error shutting down HTTP client: " + cause.getMessage(), cause);
                }
            });
            try {
                future.await(shutdownTimeout.toMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this;
    }

    public void setClientIdentifiers(Set<String> clientIdentifiers) {
        if (clientIdentifiers != null) {
            this.clientIdentifiers = clientIdentifiers;
        }
    }

    public void setClientIdentifiers(String ... clientIdentifiers) {
        if (clientIdentifiers != null) {
            this.clientIdentifiers = new HashSet<String>(Arrays.asList(clientIdentifiers));
        }
    }

    public MediaTypeCodecRegistry getMediaTypeCodecRegistry() {
        return this.mediaTypeCodecRegistry;
    }

    public void setMediaTypeCodecRegistry(MediaTypeCodecRegistry mediaTypeCodecRegistry) {
        if (mediaTypeCodecRegistry != null) {
            this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        }
    }

    @Override
    public BlockingHttpClient toBlocking() {
        return new BlockingHttpClient(){

            @Override
            public void close() throws IOException {
                DefaultHttpClient.this.close();
            }

            @Override
            public <I, O, E> HttpResponse<O> exchange(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
                Flowable<HttpResponse<O>> publisher = DefaultHttpClient.this.exchange(request, bodyType, errorType);
                return (HttpResponse)publisher.doOnNext(res -> {
                    Optional byteBuf = res.getBody(ByteBuf.class);
                    byteBuf.ifPresent(bb -> {
                        if (bb.refCnt() > 0) {
                            ReferenceCountUtil.safeRelease((Object)bb);
                        }
                    });
                    if (res instanceof FullNettyClientHttpResponse) {
                        ((FullNettyClientHttpResponse)res).onComplete();
                    }
                }).blockingFirst();
            }
        };
    }

    @Override
    public <I> Flowable<Event<ByteBuffer<?>>> eventStream(HttpRequest<I> request) {
        if (request instanceof MutableHttpRequest) {
            ((MutableHttpRequest)request).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM_TYPE});
        }
        Flowable eventFlowable = Flowable.create(emitter -> this.dataStream((HttpRequest<I>)request).subscribe(new Subscriber<ByteBuffer<?>>(){
            private Subscription dataSubscription;
            private CurrentEvent currentEvent;

            public void onSubscribe(Subscription s) {
                this.dataSubscription = s;
                Cancellable cancellable = () -> this.dataSubscription.cancel();
                emitter.setCancellable(cancellable);
                if (!emitter.isCancelled() && emitter.requested() > 0L) {
                    this.dataSubscription.request(1L);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(ByteBuffer<?> buffer) {
                try {
                    int len = buffer.readableBytes();
                    if (len == 0) {
                        try {
                            Event event = Event.of((Object)DefaultHttpClient.this.byteBufferFactory.wrap((Object)this.currentEvent.data)).name(this.currentEvent.name).retry(this.currentEvent.retry).id(this.currentEvent.id);
                            emitter.onNext((Object)event);
                        }
                        finally {
                            this.currentEvent.data.release();
                            this.currentEvent = null;
                        }
                    } else {
                        int colonIndex;
                        if (this.currentEvent == null) {
                            this.currentEvent = new CurrentEvent(((ByteBufAllocator)DefaultHttpClient.this.byteBufferFactory.getNativeAllocator()).compositeBuffer(10));
                        }
                        if ((colonIndex = buffer.indexOf((byte)58)) > 0) {
                            String type = buffer.slice(0, colonIndex).toString(StandardCharsets.UTF_8).trim();
                            int fromIndex = colonIndex + 1;
                            if (buffer.getByte(fromIndex) == 32) {
                                ++fromIndex;
                            }
                            if (fromIndex < len) {
                                int toIndex = len - fromIndex;
                                switch (type) {
                                    case "data": {
                                        ByteBuffer content = buffer.slice(fromIndex, toIndex);
                                        ByteBuf nativeBuffer = (ByteBuf)content.asNativeBuffer();
                                        this.currentEvent.data.addComponent(true, nativeBuffer);
                                        break;
                                    }
                                    case "id": {
                                        ByteBuffer id = buffer.slice(fromIndex, toIndex);
                                        this.currentEvent.id = id.toString(StandardCharsets.UTF_8).trim();
                                        break;
                                    }
                                    case "event": {
                                        ByteBuffer event = buffer.slice(fromIndex, toIndex);
                                        this.currentEvent.name = event.toString(StandardCharsets.UTF_8).trim();
                                        break;
                                    }
                                    case "retry": {
                                        ByteBuffer retry = buffer.slice(fromIndex, toIndex);
                                        String text = retry.toString(StandardCharsets.UTF_8);
                                        if (StringUtils.isEmpty((CharSequence)text)) break;
                                        Long millis = Long.valueOf(text);
                                        this.currentEvent.retry = Duration.ofMillis(millis);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    if (emitter.requested() > 0L && !emitter.isCancelled()) {
                        this.dataSubscription.request(1L);
                    }
                }
                catch (Throwable e) {
                    this.onError(e);
                }
            }

            public void onError(Throwable t) {
                this.dataSubscription.cancel();
                if (t instanceof HttpClientException) {
                    emitter.onError(t);
                } else {
                    emitter.onError((Throwable)((Object)new HttpClientException("Error consuming Server Sent Events: " + t.getMessage(), t)));
                }
            }

            public void onComplete() {
                emitter.onComplete();
            }
        }), (BackpressureStrategy)BackpressureStrategy.BUFFER);
        return eventFlowable;
    }

    @Override
    public <I, B> Flowable<Event<B>> eventStream(HttpRequest<I> request, Argument<B> eventType) {
        return this.eventStream(request).map(byteBufferEvent -> {
            ByteBuffer data = (ByteBuffer)byteBufferEvent.getData();
            Optional registeredCodec = this.mediaTypeCodecRegistry != null ? this.mediaTypeCodecRegistry.findCodec(MediaType.APPLICATION_JSON_TYPE) : Optional.empty();
            if (registeredCodec.isPresent()) {
                Object decoded = ((MediaTypeCodec)registeredCodec.get()).decode(eventType, data);
                return Event.of((Event)byteBufferEvent, (Object)decoded);
            }
            throw new CodecException("JSON codec not present");
        });
    }

    @Override
    public <I> Flowable<ByteBuffer<?>> dataStream(HttpRequest<I> request) {
        return Flowable.fromPublisher(this.resolveRequestURI(request)).flatMap(this.buildDataStreamPublisher(request));
    }

    @Override
    public <I> Flowable<HttpResponse<ByteBuffer<?>>> exchangeStream(HttpRequest<I> request) {
        return Flowable.fromPublisher(this.resolveRequestURI(request)).flatMap(this.buildExchangeStreamPublisher(request));
    }

    @Override
    public <I, O> Flowable<O> jsonStream(HttpRequest<I> request, Argument<O> type) {
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        return Flowable.fromPublisher(this.resolveRequestURI(request)).flatMap(this.buildJsonStreamPublisher(parentRequest, request, type));
    }

    @Override
    public <I> Flowable<Map<String, Object>> jsonStream(HttpRequest<I> request) {
        Flowable<Map> flowable = this.jsonStream(request, Map.class);
        return flowable;
    }

    @Override
    public <I, O> Flowable<O> jsonStream(HttpRequest<I> request, Class<O> type) {
        return this.jsonStream(request, (Argument<O>)Argument.of(type));
    }

    @Override
    public <I, O, E> Flowable<HttpResponse<O>> exchange(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        Publisher<URI> uriPublisher = this.resolveRequestURI(request);
        return Flowable.fromPublisher(uriPublisher).switchMap(this.buildExchangePublisher(parentRequest, request, bodyType, errorType));
    }

    public <T extends AutoCloseable> Flowable<T> connect(Class<T> clientEndpointType, MutableHttpRequest<?> request) {
        Publisher<URI> uriPublisher = this.resolveRequestURI((HttpRequest)request);
        return Flowable.fromPublisher(uriPublisher).switchMap(resolvedURI -> this.connectWebSocket((URI)resolvedURI, request, clientEndpointType, null));
    }

    public <T extends AutoCloseable> Flowable<T> connect(Class<T> clientEndpointType, Map<String, Object> parameters) {
        WebSocketBean webSocketBean = this.webSocketRegistry.getWebSocket(clientEndpointType);
        String uri = webSocketBean.getBeanDefinition().stringValue(ClientWebSocket.class).orElse("/ws");
        uri = UriTemplate.of((String)uri).expand(parameters);
        MutableHttpRequest request = HttpRequest.GET((String)uri);
        Publisher<URI> uriPublisher = this.resolveRequestURI((HttpRequest)request);
        return Flowable.fromPublisher(uriPublisher).switchMap(resolvedURI -> this.connectWebSocket((URI)resolvedURI, (MutableHttpRequest<?>)request, clientEndpointType, (WebSocketBean)webSocketBean));
    }

    @Override
    public void close() {
        this.stop();
    }

    @Inject
    protected void configure(BeanContext beanContext) {
        if (beanContext != null) {
            this.webSocketRegistry = WebSocketBeanRegistry.forClient((BeanContext)beanContext);
            this.requestBinderRegistry = beanContext.findBean(RequestBinderRegistry.class).orElse(null);
        }
    }

    private <T> Flowable<T> connectWebSocket(final URI uri, final MutableHttpRequest<?> request, Class<T> clientEndpointType, WebSocketBean<T> webSocketBean) {
        Bootstrap bootstrap = this.bootstrap.clone();
        if (webSocketBean == null) {
            webSocketBean = this.webSocketRegistry.getWebSocket(clientEndpointType);
        }
        final WebSocketBean finalWebSocketBean = webSocketBean;
        return Flowable.create(emitter -> {
            RequestKey requestKey;
            SslContext sslContext = this.buildSslContext(uri);
            final WebSocketVersion protocolVersion = finalWebSocketBean.getBeanDefinition().enumValue(ClientWebSocket.class, "version", WebSocketVersion.class).orElse(WebSocketVersion.V13);
            final int maxFramePayloadLength = finalWebSocketBean.messageMethod().flatMap(m -> m.getValue(OnMessage.class, "maxPayloadLength", Integer.class)).orElse(65536);
            try {
                requestKey = new RequestKey(uri);
            }
            catch (HttpClientException e) {
                emitter.onError((Throwable)((Object)e));
                return;
            }
            bootstrap.remoteAddress(requestKey.getHost(), requestKey.getPort());
            bootstrap.handler((ChannelHandler)new HttpClientInitializer(sslContext, requestKey.getHost(), requestKey.getPort(), false, false){

                @Override
                protected void addFinalHandler(ChannelPipeline pipeline) {
                    Duration duration;
                    Optional<Duration> readIdleTime;
                    pipeline.remove(DefaultHttpClient.HANDLER_DECODER);
                    ReadTimeoutHandler readTimeoutHandler = (ReadTimeoutHandler)pipeline.get(ReadTimeoutHandler.class);
                    if (readTimeoutHandler != null) {
                        pipeline.remove((ChannelHandler)readTimeoutHandler);
                    }
                    if ((readIdleTime = DefaultHttpClient.this.configuration.getReadIdleTimeout()).isPresent() && !(duration = readIdleTime.get()).isNegative()) {
                        pipeline.addLast(DefaultHttpClient.HANDLER_IDLE_STATE, (ChannelHandler)new IdleStateHandler(duration.toMillis(), duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS));
                    }
                    try {
                        URI webSocketURL = URI.create("ws://" + this.host + ":" + this.port + uri.getPath());
                        MutableHttpHeaders headers = request.getHeaders();
                        EmptyHttpHeaders customHeaders = EmptyHttpHeaders.INSTANCE;
                        if (headers instanceof NettyHttpHeaders) {
                            customHeaders = ((NettyHttpHeaders)headers).getNettyHeaders();
                        }
                        NettyWebSocketClientHandler webSocketHandler = new NettyWebSocketClientHandler(request, finalWebSocketBean, WebSocketClientHandshakerFactory.newHandshaker((URI)webSocketURL, (WebSocketVersion)protocolVersion, null, (boolean)false, (HttpHeaders)customHeaders, (int)maxFramePayloadLength), DefaultHttpClient.this.requestBinderRegistry, DefaultHttpClient.this.mediaTypeCodecRegistry, emitter);
                        pipeline.addLast(DefaultHttpClient.HANDLER_MICRONAUT_WEBSOCKET_CLIENT, webSocketHandler);
                    }
                    catch (Throwable e) {
                        emitter.onError((Throwable)new WebSocketSessionException("Error opening WebSocket client session: " + e.getMessage(), e));
                    }
                }
            });
            bootstrap.connect().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    emitter.onError(future.cause());
                }
            }));
        }, (BackpressureStrategy)BackpressureStrategy.ERROR);
    }

    protected <I> Function<URI, Flowable<HttpResponse<ByteBuffer<?>>>> buildExchangeStreamPublisher(HttpRequest<I> request) {
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        return requestURI -> {
            Flowable<HttpResponse<Object>> streamResponsePublisher = this.buildStreamExchange((HttpRequest<?>)parentRequest, request, (URI)requestURI);
            return streamResponsePublisher.switchMap(response -> {
                if (!(response instanceof NettyStreamedHttpResponse)) {
                    throw new IllegalStateException("Response has been wrapped in non streaming type. Do not wrap the response in client filters for stream requests");
                }
                NettyStreamedHttpResponse nettyStreamedHttpResponse = (NettyStreamedHttpResponse)response;
                Flowable httpContentFlowable = Flowable.fromPublisher((Publisher)nettyStreamedHttpResponse.getNettyResponse());
                return httpContentFlowable.filter(message -> !(message.content() instanceof EmptyByteBuf)).map(message -> {
                    ByteBuf byteBuf = message.content();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("HTTP Client Streaming Response Received Chunk (length: {}) for Request: {} {}", new Object[]{byteBuf.readableBytes(), request.getMethod(), request.getUri()});
                        this.traceBody("Response", byteBuf);
                    }
                    final ByteBuffer byteBuffer = this.byteBufferFactory.wrap((Object)byteBuf);
                    return new HttpResponseWrapper<ByteBuffer<?>>(nettyStreamedHttpResponse){

                        public Optional<ByteBuffer<?>> getBody() {
                            return Optional.of(byteBuffer);
                        }
                    };
                });
            });
        };
    }

    protected <I, O> Function<URI, Flowable<O>> buildJsonStreamPublisher(HttpRequest<?> parentRequest, final HttpRequest<I> request, Argument<O> type) {
        return requestURI -> {
            Flowable<HttpResponse<Object>> streamResponsePublisher = this.buildStreamExchange(parentRequest, request, (URI)requestURI);
            return streamResponsePublisher.switchMap(response -> {
                if (!(response instanceof NettyStreamedHttpResponse)) {
                    throw new IllegalStateException("Response has been wrapped in non streaming type. Do not wrap the response in client filters for stream requests");
                }
                JsonMediaTypeCodec mediaTypeCodec = (JsonMediaTypeCodec)this.mediaTypeCodecRegistry.findCodec(MediaType.APPLICATION_JSON_TYPE).orElseThrow(() -> new IllegalStateException("No JSON codec found"));
                NettyStreamedHttpResponse nettyStreamedHttpResponse = (NettyStreamedHttpResponse)response;
                final Flowable httpContentFlowable = Flowable.fromPublisher((Publisher)nettyStreamedHttpResponse.getNettyResponse());
                boolean isJsonStream = response.getContentType().map(mediaType -> mediaType.equals((Object)MediaType.APPLICATION_JSON_STREAM_TYPE)).orElse(false);
                boolean streamArray = !Iterable.class.isAssignableFrom(type.getType()) && !isJsonStream;
                JacksonProcessor jacksonProcessor = new JacksonProcessor(mediaTypeCodec.getObjectMapper().getFactory(), streamArray){

                    public void subscribe(Subscriber<? super JsonNode> downstreamSubscriber) {
                        httpContentFlowable.map(content -> {
                            ByteBuf chunk = content.content();
                            if (DefaultHttpClient.this.log.isTraceEnabled()) {
                                DefaultHttpClient.this.log.trace("HTTP Client Streaming Response Received Chunk (length: {}) for Request: {} {}", new Object[]{chunk.readableBytes(), request.getMethod(), request.getUri()});
                                DefaultHttpClient.this.traceBody("Chunk", chunk);
                            }
                            try {
                                byte[] byArray = ByteBufUtil.getBytes((ByteBuf)chunk);
                                return byArray;
                            }
                            finally {
                                chunk.release();
                            }
                        }).subscribe((Subscriber)this);
                        super.subscribe(downstreamSubscriber);
                    }
                };
                return Flowable.fromPublisher((Publisher)jacksonProcessor).map(jsonNode -> mediaTypeCodec.decode(type, jsonNode));
            });
        };
    }

    protected <I> Function<URI, Flowable<ByteBuffer<?>>> buildDataStreamPublisher(HttpRequest<I> request) {
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        return requestURI -> {
            Flowable<HttpResponse<Object>> streamResponsePublisher = this.buildStreamExchange((HttpRequest<?>)parentRequest, request, (URI)requestURI);
            Function contentMapper = message -> {
                ByteBuf byteBuf = message.content();
                return this.byteBufferFactory.wrap((Object)byteBuf);
            };
            return streamResponsePublisher.switchMap(response -> {
                if (!(response instanceof NettyStreamedHttpResponse)) {
                    throw new IllegalStateException("Response has been wrapped in non streaming type. Do not wrap the response in client filters for stream requests");
                }
                NettyStreamedHttpResponse nettyStreamedHttpResponse = (NettyStreamedHttpResponse)response;
                Flowable httpContentFlowable = Flowable.fromPublisher((Publisher)nettyStreamedHttpResponse.getNettyResponse());
                return httpContentFlowable.filter(message -> !(message.content() instanceof EmptyByteBuf)).map(contentMapper);
            });
        };
    }

    protected <I> Flowable<HttpResponse<Object>> buildStreamExchange(HttpRequest<?> parentRequest, HttpRequest<I> request, URI requestURI) {
        SslContext sslContext = this.buildSslContext(requestURI);
        AtomicReference<HttpRequest> requestWrapper = new AtomicReference<HttpRequest>(request);
        Flowable streamResponsePublisher = Flowable.create(emitter -> {
            ChannelFuture channelFuture;
            try {
                channelFuture = this.doConnect(request, requestURI, sslContext, true);
            }
            catch (HttpClientException e) {
                emitter.onError((Throwable)((Object)e));
                return;
            }
            Disposable disposable = this.buildDisposableChannel(channelFuture);
            emitter.setDisposable(disposable);
            emitter.setCancellable(() -> ((Disposable)disposable).dispose());
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)f -> {
                if (f.isSuccess()) {
                    Channel channel = f.channel();
                    this.streamRequestThroughChannel(parentRequest, requestURI, requestWrapper, (FlowableEmitter<HttpResponse<Object>>)emitter, channel);
                } else {
                    Throwable cause = f.cause();
                    emitter.onError((Throwable)((Object)new HttpClientException("Connect error:" + cause.getMessage(), cause)));
                }
            }));
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
        streamResponsePublisher = Flowable.fromPublisher(this.applyFilterToResponsePublisher(parentRequest, request, requestURI, requestWrapper, (Publisher)streamResponsePublisher));
        return streamResponsePublisher.subscribeOn(this.scheduler);
    }

    protected <I, O, E> Function<URI, Publisher<? extends HttpResponse<O>>> buildExchangePublisher(HttpRequest<?> parentRequest, HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
        AtomicReference requestWrapper = new AtomicReference(request);
        return requestURI -> {
            Duration rt;
            Flowable responsePublisher = Flowable.create(emitter -> {
                boolean multipart = MediaType.MULTIPART_FORM_DATA_TYPE.equals(request.getContentType().orElse(null));
                if (this.poolMap != null && !multipart) {
                    try {
                        ChannelPool channelPool = this.poolMap.get((Object)new RequestKey((URI)requestURI));
                        Future channelFuture = channelPool.acquire();
                        channelFuture.addListener(future -> {
                            if (future.isSuccess()) {
                                Channel channel = (Channel)future.get();
                                try {
                                    this.sendRequestThroughChannel(requestWrapper, bodyType, errorType, emitter, channel, channelPool);
                                }
                                catch (Exception e) {
                                    emitter.onError((Throwable)e);
                                }
                            } else {
                                Throwable cause = future.cause();
                                emitter.onError((Throwable)((Object)new HttpClientException("Connect Error: " + cause.getMessage(), cause)));
                            }
                        });
                    }
                    catch (HttpClientException e) {
                        emitter.onError((Throwable)((Object)e));
                    }
                } else {
                    SslContext sslContext = this.buildSslContext((URI)requestURI);
                    ChannelFuture connectionFuture = this.doConnect(request, (URI)requestURI, sslContext, false);
                    connectionFuture.addListener(future -> {
                        if (future.isSuccess()) {
                            try {
                                Channel channel = connectionFuture.channel();
                                this.sendRequestThroughChannel(requestWrapper, bodyType, errorType, emitter, channel, null);
                            }
                            catch (Exception e) {
                                emitter.onError((Throwable)e);
                            }
                        } else {
                            Throwable cause = future.cause();
                            emitter.onError((Throwable)((Object)new HttpClientException("Connect Error: " + cause.getMessage(), cause)));
                        }
                    });
                }
            }, (BackpressureStrategy)BackpressureStrategy.ERROR);
            Publisher finalPublisher = this.applyFilterToResponsePublisher(parentRequest, request, (URI)requestURI, requestWrapper, (Publisher)responsePublisher);
            Flowable finalFlowable = finalPublisher instanceof Flowable ? (Flowable)finalPublisher : Flowable.fromPublisher(finalPublisher);
            Optional<Duration> readTimeout = this.configuration.getReadTimeout();
            if (readTimeout.isPresent() && !(rt = readTimeout.get()).isNegative()) {
                Duration duration = rt.plus(Duration.ofSeconds(1L));
                finalFlowable = finalFlowable.timeout(duration.toMillis(), TimeUnit.MILLISECONDS).onErrorResumeNext(throwable -> {
                    if (throwable instanceof TimeoutException) {
                        return Flowable.error((Throwable)((Object)ReadTimeoutException.TIMEOUT_EXCEPTION));
                    }
                    return Flowable.error((Throwable)throwable);
                });
            }
            return finalFlowable;
        };
    }

    protected void closeChannelAsync(Channel channel) {
        if (channel.isOpen()) {
            ChannelFuture closeFuture = channel.closeFuture();
            closeFuture.addListener(f2 -> {
                if (!f2.isSuccess() && this.log.isErrorEnabled()) {
                    Throwable cause = f2.cause();
                    this.log.error("Error closing request connection: " + cause.getMessage(), cause);
                }
            });
        }
    }

    protected <I> Publisher<URI> resolveRequestURI(HttpRequest<I> request) {
        URI requestURI;
        if (!request.getParameters().isEmpty()) {
            UriBuilder newUri = UriBuilder.of((URI)request.getUri());
            request.getParameters().forEach((key, value) -> newUri.queryParam(key, value.toArray()));
            requestURI = newUri.build();
        } else {
            requestURI = request.getUri();
        }
        if (requestURI.getScheme() != null) {
            return Publishers.just((Object)requestURI);
        }
        return Publishers.map(this.loadBalancer.select(this.getLoadBalancerDiscriminator()), server -> {
            Optional authInfo = server.getMetadata().get((CharSequence)"Authorization-Info", String.class);
            if (request instanceof MutableHttpRequest && authInfo.isPresent()) {
                ((MutableHttpRequest)request).getHeaders().auth((String)authInfo.get());
            }
            return server.resolve(this.resolveRequestURI(requestURI));
        });
    }

    protected URI resolveRequestURI(URI requestURI) {
        if (StringUtils.isNotEmpty((CharSequence)this.contextPath)) {
            try {
                return new URI(StringUtils.prependUri((String)this.contextPath, (String)requestURI.toString()));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return requestURI;
    }

    protected Object getLoadBalancerDiscriminator() {
        return null;
    }

    protected ChannelFuture doConnect(HttpRequest<?> request, URI uri, @Nullable SslContext sslCtx, boolean isStream) throws HttpClientException {
        RequestKey requestKey = new RequestKey(uri);
        return this.doConnect(request, requestKey.getHost(), requestKey.getPort(), sslCtx, isStream);
    }

    protected ChannelFuture doConnect(HttpRequest<?> request, String host, int port, @Nullable SslContext sslCtx, boolean isStream) {
        Bootstrap localBootstrap = this.bootstrap.clone();
        localBootstrap.handler((ChannelHandler)new HttpClientInitializer(sslCtx, host, port, isStream, request.getHeaders().get((CharSequence)"Accept", String.class).map(ct -> ct.equals("text/event-stream")).orElse(false)));
        return this.doConnect(localBootstrap, host, port);
    }

    protected NioEventLoopGroup createEventLoopGroup(HttpClientConfiguration configuration, ThreadFactory threadFactory) {
        OptionalInt numOfThreads = configuration.getNumOfThreads();
        Optional<Class<? extends ThreadFactory>> threadFactoryType = configuration.getThreadFactory();
        boolean hasThreads = numOfThreads.isPresent();
        boolean hasFactory = threadFactoryType.isPresent();
        NioEventLoopGroup group = hasThreads && hasFactory ? new NioEventLoopGroup(numOfThreads.getAsInt(), (ThreadFactory)InstantiationUtils.instantiate(threadFactoryType.get())) : (hasThreads ? (threadFactory != null ? new NioEventLoopGroup(numOfThreads.getAsInt(), threadFactory) : new NioEventLoopGroup(numOfThreads.getAsInt())) : (threadFactory != null ? new NioEventLoopGroup(NettyThreadFactory.DEFAULT_EVENT_LOOP_THREADS, threadFactory) : new NioEventLoopGroup()));
        return group;
    }

    protected ChannelFuture doConnect(Bootstrap bootstrap, String host, int port) {
        return bootstrap.connect(host, port);
    }

    protected SslContext buildSslContext(URI uriObject) {
        SslContext sslCtx;
        if (uriObject.getScheme().equals("https")) {
            sslCtx = this.sslContext;
            if (sslCtx == null && !this.configuration.getProxyAddress().isPresent()) {
                throw new HttpClientException("Cannot send HTTPS request. SSL is disabled");
            }
        } else {
            sslCtx = null;
        }
        return sslCtx;
    }

    protected List<HttpClientFilter> resolveFilters(@Nullable HttpRequest<?> parentRequest, HttpRequest<?> request, URI requestURI) {
        ArrayList<HttpClientFilter> filterList = new ArrayList<HttpClientFilter>();
        if (parentRequest != null) {
            filterList.add(new ClientServerContextFilter(parentRequest));
        }
        String requestPath = StringUtils.prependUri((String)"/", (String)requestURI.getPath());
        HttpMethod method = request.getMethod();
        for (HttpClientFilter filter : this.filters) {
            if (filter instanceof Toggleable && !((Toggleable)filter).isEnabled()) continue;
            Optional filterOpt = this.annotationMetadataResolver.resolveMetadata((Object)filter).findAnnotation(Filter.class);
            if (filterOpt.isPresent()) {
                Object[] methods;
                AnnotationValue filterAnn = (AnnotationValue)filterOpt.get();
                Object[] clients = filterAnn.get((CharSequence)"serviceId", String[].class).orElse(null);
                if (ArrayUtils.isNotEmpty((Object[])clients) && (this.clientIdentifiers.isEmpty() || Arrays.stream(clients).noneMatch(id -> this.clientIdentifiers.contains(id))) || ArrayUtils.isNotEmpty((Object[])(methods = (HttpMethod[])filterAnn.get((CharSequence)"methods", HttpMethod[].class, null))) && !Arrays.asList(methods).contains(method)) continue;
                String[] patterns = filterAnn.stringValues();
                if (patterns.length == 0) {
                    filterList.add(filter);
                    continue;
                }
                for (String pathPattern : patterns) {
                    if (!PathMatcher.ANT.matches(pathPattern, requestPath)) continue;
                    filterList.add(filter);
                }
                continue;
            }
            filterList.add(filter);
        }
        return filterList;
    }

    protected void configureProxy(ChannelPipeline pipeline, Proxy proxy) {
        this.configureProxy(pipeline, proxy.type(), proxy.address());
    }

    protected void configureProxy(ChannelPipeline pipeline, Proxy.Type proxyType, SocketAddress proxyAddress) {
        String username = this.configuration.getProxyUsername().orElse(null);
        String password = this.configuration.getProxyPassword().orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password)) {
            switch (proxyType) {
                case HTTP: {
                    pipeline.addLast(HANDLER_HTTP_PROXY, (ChannelHandler)new HttpProxyHandler(proxyAddress, username, password));
                    break;
                }
                case SOCKS: {
                    pipeline.addLast(HANDLER_SOCKS_5_PROXY, (ChannelHandler)new Socks5ProxyHandler(proxyAddress, username, password));
                    break;
                }
            }
        } else {
            switch (proxyType) {
                case HTTP: {
                    pipeline.addLast(HANDLER_HTTP_PROXY, (ChannelHandler)new HttpProxyHandler(proxyAddress));
                    break;
                }
                case SOCKS: {
                    pipeline.addLast(HANDLER_SOCKS_5_PROXY, (ChannelHandler)new Socks5ProxyHandler(proxyAddress));
                    break;
                }
            }
        }
    }

    protected <I, O> Publisher<HttpResponse<O>> applyFilterToResponsePublisher(HttpRequest<?> parentRequest, HttpRequest<I> request, URI requestURI, AtomicReference<HttpRequest> requestWrapper, Publisher<HttpResponse<O>> responsePublisher) {
        if (request instanceof MutableHttpRequest) {
            ((MutableHttpRequest)request).uri(requestURI);
        }
        if (CollectionUtils.isNotEmpty(this.filters)) {
            List<HttpClientFilter> httpClientFilters = this.resolveFilters(parentRequest, request, requestURI);
            OrderUtil.reverseSort(httpClientFilters);
            Publisher finalResponsePublisher = responsePublisher;
            httpClientFilters.add((req, chain) -> finalResponsePublisher);
            ClientFilterChain filterChain = this.buildChain(requestWrapper, httpClientFilters);
            responsePublisher = parentRequest != null ? (Publisher)ServerRequestContext.with(parentRequest, () -> ((HttpClientFilter)httpClientFilters.get(0)).doFilter(request, (FilterChain)filterChain)) : httpClientFilters.get(0).doFilter(request, (FilterChain)filterChain);
        }
        return responsePublisher;
    }

    protected NettyRequestWriter buildNettyRequest(MutableHttpRequest request, URI requestURI, MediaType requestContentType, boolean permitsBody) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        io.netty.handler.codec.http.HttpRequest nettyRequest;
        NettyClientHttpRequest clientHttpRequest = (NettyClientHttpRequest)request;
        HttpPostRequestEncoder postRequestEncoder = null;
        if (permitsBody) {
            Optional body = clientHttpRequest.getBody();
            boolean hasBody = body.isPresent();
            if (requestContentType.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE) && hasBody) {
                Object bodyValue = body.get();
                if (bodyValue instanceof CharSequence) {
                    ByteBuf byteBuf = this.charSequenceToByteBuf((CharSequence)bodyValue, requestContentType);
                    nettyRequest = clientHttpRequest.getFullRequest(byteBuf);
                } else {
                    postRequestEncoder = this.buildFormDataRequest(clientHttpRequest, bodyValue);
                    nettyRequest = postRequestEncoder.finalizeRequest();
                }
            } else if (requestContentType.equals((Object)MediaType.MULTIPART_FORM_DATA_TYPE) && hasBody) {
                Object bodyValue = body.get();
                postRequestEncoder = this.buildMultipartRequest(clientHttpRequest, bodyValue);
                nettyRequest = postRequestEncoder.finalizeRequest();
            } else {
                ByteBuf bodyContent = null;
                if (hasBody) {
                    Object bodyValue = body.get();
                    if (Publishers.isConvertibleToPublisher(bodyValue)) {
                        boolean isSingle = Publishers.isSingle(bodyValue.getClass());
                        Flowable publisher = (Flowable)ConversionService.SHARED.convert(bodyValue, Flowable.class).orElseThrow(() -> new IllegalArgumentException("Unconvertible reactive type: " + bodyValue));
                        Flowable requestBodyPublisher = publisher.map(o -> {
                            Optional registeredCodec;
                            ByteBuf encoded;
                            if (o instanceof CharSequence) {
                                ByteBuf textChunk = Unpooled.copiedBuffer((CharSequence)((CharSequence)o), (Charset)requestContentType.getCharset().orElse(StandardCharsets.UTF_8));
                                if (this.log.isTraceEnabled()) {
                                    this.traceChunk(textChunk);
                                }
                                return new DefaultHttpContent(textChunk);
                            }
                            if (o instanceof ByteBuf) {
                                ByteBuf byteBuf = (ByteBuf)o;
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace("Sending Bytes Chunk. Length: {}", (Object)byteBuf.readableBytes());
                                }
                                return new DefaultHttpContent(byteBuf);
                            }
                            if (o instanceof byte[]) {
                                byte[] bodyBytes = (byte[])o;
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace("Sending Bytes Chunk. Length: {}", (Object)bodyBytes.length);
                                }
                                return new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])bodyBytes));
                            }
                            if (this.mediaTypeCodecRegistry != null && (encoded = (ByteBuf)(registeredCodec = this.mediaTypeCodecRegistry.findCodec(requestContentType)).map(codec -> (ByteBuf)codec.encode(o, this.byteBufferFactory).asNativeBuffer()).orElse(null)) != null) {
                                if (this.log.isTraceEnabled()) {
                                    this.traceChunk(encoded);
                                }
                                return new DefaultHttpContent(encoded);
                            }
                            throw new CodecException("Cannot encode value [" + o + "]. No possible encoders found");
                        });
                        if (!isSingle && MediaType.APPLICATION_JSON_TYPE.equals((Object)requestContentType)) {
                            requestBodyPublisher = requestBodyPublisher.map((Function)new Function<HttpContent, HttpContent>(){
                                boolean first = true;

                                public HttpContent apply(HttpContent httpContent) {
                                    if (!this.first) {
                                        return HttpContentUtil.prefixComma((HttpContent)httpContent);
                                    }
                                    this.first = false;
                                    return httpContent;
                                }
                            });
                            requestBodyPublisher = Flowable.concat((Publisher)Flowable.fromCallable(HttpContentUtil::openBracket), (Publisher)requestBodyPublisher, (Publisher)Flowable.fromCallable(HttpContentUtil::closeBracket));
                        }
                        io.netty.handler.codec.http.HttpRequest nettyRequest2 = clientHttpRequest.getStreamedRequest((Publisher<HttpContent>)requestBodyPublisher);
                        try {
                            nettyRequest2.setUri(requestURI.toURL().getFile());
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        return new NettyRequestWriter(nettyRequest2, null);
                    }
                    if (bodyValue instanceof CharSequence) {
                        bodyContent = this.charSequenceToByteBuf((CharSequence)bodyValue, requestContentType);
                    } else if (this.mediaTypeCodecRegistry != null) {
                        Optional registeredCodec = this.mediaTypeCodecRegistry.findCodec(requestContentType);
                        bodyContent = registeredCodec.map(codec -> (ByteBuf)codec.encode(bodyValue, this.byteBufferFactory).asNativeBuffer()).orElse(null);
                    }
                    if (bodyContent == null) {
                        bodyContent = (ByteBuf)ConversionService.SHARED.convert(bodyValue, ByteBuf.class).orElseThrow(() -> new HttpClientException("Body [" + bodyValue + "] cannot be encoded to content type [" + requestContentType + "]. No possible codecs or converters found."));
                    }
                }
                nettyRequest = clientHttpRequest.getFullRequest(bodyContent);
            }
        } else {
            nettyRequest = clientHttpRequest.getFullRequest(null);
        }
        try {
            nettyRequest.setUri(requestURI.toURL().getFile());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return new NettyRequestWriter(nettyRequest, postRequestEncoder);
    }

    private <I, O, E> void sendRequestThroughChannel(AtomicReference<HttpRequest> requestWrapper, Argument<O> bodyType, Argument<E> errorType, FlowableEmitter<HttpResponse<O>> emitter, Channel channel, ChannelPool channelPool) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        HttpRequest finalRequest = requestWrapper.get();
        URI requestURI = finalRequest.getUri();
        MediaType requestContentType = finalRequest.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)finalRequest.getMethod());
        NettyClientHttpRequest clientHttpRequest = (NettyClientHttpRequest)finalRequest;
        NettyRequestWriter requestWriter = this.buildNettyRequest(clientHttpRequest, requestURI, requestContentType, permitsBody);
        io.netty.handler.codec.http.HttpRequest nettyRequest = requestWriter.getNettyRequest();
        this.prepareHttpHeaders(requestURI, finalRequest, nettyRequest, permitsBody, this.poolMap == null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending HTTP Request: {} {}", (Object)nettyRequest.method(), (Object)nettyRequest.uri());
            this.log.debug("Chosen Server: {}({})", (Object)requestURI.getHost(), (Object)requestURI.getPort());
        }
        if (this.log.isTraceEnabled()) {
            this.traceRequest(finalRequest, nettyRequest);
        }
        this.addFullHttpResponseHandler(finalRequest, channel, channelPool, emitter, bodyType, errorType);
        requestWriter.writeAndClose(channel, channelPool, emitter);
    }

    private void streamRequestThroughChannel(final HttpRequest<?> parentRequest, URI requestURI, AtomicReference<HttpRequest> requestWrapper, final FlowableEmitter<HttpResponse<Object>> emitter, Channel channel) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        NettyRequestWriter requestWriter = this.prepareRequest(requestWrapper.get(), requestURI);
        final io.netty.handler.codec.http.HttpRequest nettyRequest = requestWriter.getNettyRequest();
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast(HANDLER_MICRONAUT_HTTP_RESPONSE_STREAM, (ChannelHandler)new SimpleChannelInboundHandler<StreamedHttpResponse>(){
            AtomicBoolean received = new AtomicBoolean(false);

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                if (this.received.compareAndSet(false, true)) {
                    emitter.onError(cause);
                }
            }

            protected void channelRead0(ChannelHandlerContext ctx, StreamedHttpResponse msg) {
                if (this.received.compareAndSet(false, true)) {
                    HttpStatus httpStatus;
                    HttpResponseStatus status = msg.status();
                    int statusCode = status.code();
                    try {
                        httpStatus = HttpStatus.valueOf((int)statusCode);
                    }
                    catch (IllegalArgumentException e) {
                        emitter.onError((Throwable)e);
                        return;
                    }
                    NettyStreamedHttpResponse response = new NettyStreamedHttpResponse(msg, httpStatus);
                    HttpHeaders headers = msg.headers();
                    if (DefaultHttpClient.this.log.isTraceEnabled()) {
                        DefaultHttpClient.this.log.trace("HTTP Client Streaming Response Received ({}) for Request: {} {}", new Object[]{msg.status(), nettyRequest.method().name(), nettyRequest.uri()});
                        DefaultHttpClient.this.traceHeaders(headers);
                    }
                    if (statusCode > 300 && statusCode < 400 && DefaultHttpClient.this.configuration.isFollowRedirects() && headers.contains((CharSequence)HttpHeaderNames.LOCATION)) {
                        String location = headers.get((CharSequence)HttpHeaderNames.LOCATION);
                        try {
                            MutableHttpRequest redirectRequest = HttpRequest.GET((String)location);
                            DefaultHttpClient.this.setRedirectHeaders(nettyRequest, (MutableHttpRequest<Object>)redirectRequest);
                            Flowable redirectedExchange = Flowable.fromPublisher(DefaultHttpClient.this.resolveRequestURI(redirectRequest)).flatMap(uri -> DefaultHttpClient.this.buildStreamExchange((HttpRequest<?>)parentRequest, redirectRequest, (URI)uri));
                            redirectedExchange.subscribe((Subscriber)new Subscriber<HttpResponse<Object>>(){
                                Subscription sub;

                                public void onSubscribe(Subscription s) {
                                    s.request(1L);
                                    this.sub = s;
                                }

                                public void onNext(HttpResponse<Object> objectHttpResponse) {
                                    emitter.onNext(objectHttpResponse);
                                    this.sub.cancel();
                                }

                                public void onError(Throwable t) {
                                    emitter.onError(t);
                                    this.sub.cancel();
                                }

                                public void onComplete() {
                                    emitter.onComplete();
                                }
                            });
                        }
                        catch (Exception e) {
                            emitter.onError((Throwable)e);
                        }
                    } else {
                        boolean errorStatus;
                        boolean bl = errorStatus = statusCode >= 400;
                        if (errorStatus) {
                            emitter.onError((Throwable)((Object)new HttpClientResponseException(response.getStatus().getReason(), response)));
                        } else {
                            emitter.onNext(response);
                            emitter.onComplete();
                        }
                    }
                }
            }
        });
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending HTTP Request: {} {}", (Object)nettyRequest.method(), (Object)nettyRequest.uri());
            this.log.debug("Chosen Server: {}({})", (Object)requestURI.getHost(), (Object)requestURI.getPort());
        }
        if (this.log.isTraceEnabled()) {
            this.traceRequest(requestWrapper.get(), nettyRequest);
        }
        requestWriter.writeAndClose(channel, null, emitter);
    }

    private ByteBuf charSequenceToByteBuf(CharSequence bodyValue, MediaType requestContentType) {
        CharSequence charSequence = bodyValue;
        return (ByteBuf)this.byteBufferFactory.copiedBuffer(charSequence.toString().getBytes(requestContentType.getCharset().orElse(this.defaultCharset))).asNativeBuffer();
    }

    private String getHostHeader(URI requestURI) {
        RequestKey requestKey = new RequestKey(requestURI);
        StringBuilder host = new StringBuilder(requestKey.getHost());
        int port = requestKey.getPort();
        if (port > -1 && port != 80 && port != 443) {
            host.append(":").append(port);
        }
        return host.toString();
    }

    private <I> void prepareHttpHeaders(URI requestURI, HttpRequest<I> request, io.netty.handler.codec.http.HttpRequest nettyRequest, boolean permitsBody, boolean closeConnection) {
        HttpHeaders headers = nettyRequest.headers();
        if (!headers.contains((CharSequence)HttpHeaderNames.HOST)) {
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)this.getHostHeader(requestURI));
        }
        if (closeConnection) {
            headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        } else {
            headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        if (permitsBody) {
            Optional body = request.getBody();
            if (body.isPresent()) {
                if (!headers.contains((CharSequence)HttpHeaderNames.CONTENT_TYPE)) {
                    MediaType mediaType = request.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType);
                }
                if (nettyRequest instanceof FullHttpRequest) {
                    FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyRequest;
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)fullHttpRequest.content().readableBytes());
                } else if (!headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && !headers.contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) {
                    headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                }
            } else {
                headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
            }
        }
    }

    private <O, E> void addFullHttpResponseHandler(final HttpRequest<?> request, Channel channel, final ChannelPool channelPool, final FlowableEmitter<HttpResponse<O>> emitter, final Argument<O> bodyType, final Argument<E> errorType) {
        final ChannelPipeline pipeline = channel.pipeline();
        SimpleChannelInboundHandler<FullHttpResponse> newHandler = new SimpleChannelInboundHandler<FullHttpResponse>(false){
            AtomicBoolean complete;
            boolean keepAlive;
            {
                super(x0);
                this.complete = new AtomicBoolean(false);
                this.keepAlive = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void channelRead0(ChannelHandlerContext channelHandlerContext, FullHttpResponse fullResponse) {
                block47: {
                    HttpHeaders headers;
                    HttpStatus httpStatus;
                    int statusCode;
                    HttpResponseStatus status;
                    block45: {
                        block46: {
                            status = fullResponse.status();
                            statusCode = status.code();
                            try {
                                httpStatus = HttpStatus.valueOf((int)statusCode);
                            }
                            catch (IllegalArgumentException e) {
                                block44: {
                                    if (this.complete.compareAndSet(false, true)) {
                                        emitter.tryOnError((Throwable)e);
                                    } else if (LOG.isWarnEnabled()) {
                                        LOG.warn("Unsupported http status after handler completed: " + e.getMessage(), (Throwable)e);
                                    }
                                    if (fullResponse.refCnt() > 0) {
                                        try {
                                            ReferenceCountUtil.release((Object)fullResponse);
                                        }
                                        catch (Throwable e2) {
                                            if (!LOG.isDebugEnabled()) break block44;
                                            LOG.debug("Failed to release response: {}", (Object)fullResponse);
                                        }
                                    }
                                }
                                if (!HttpUtil.isKeepAlive((HttpMessage)fullResponse)) {
                                    this.keepAlive = false;
                                }
                                pipeline.remove((ChannelHandler)this);
                                return;
                            }
                            headers = fullResponse.headers();
                            if (DefaultHttpClient.this.log.isTraceEnabled()) {
                                DefaultHttpClient.this.log.trace("HTTP Client Response Received for Request: {} {}", (Object)request.getMethod(), (Object)request.getUri());
                                DefaultHttpClient.this.log.trace("Status Code: {}", (Object)status);
                                DefaultHttpClient.this.traceHeaders(headers);
                                DefaultHttpClient.this.traceBody("Response", fullResponse.content());
                            }
                            if (statusCode <= 300 || statusCode >= 400 || !DefaultHttpClient.this.configuration.isFollowRedirects() || !headers.contains((CharSequence)HttpHeaderNames.LOCATION)) break block45;
                            String location = headers.get((CharSequence)HttpHeaderNames.LOCATION);
                            MutableHttpRequest redirectRequest = HttpRequest.GET((String)location);
                            DefaultHttpClient.this.setRedirectHeaders(request, (MutableHttpRequest<Object>)redirectRequest);
                            Flowable redirectExchange = DefaultHttpClient.this.exchange((HttpRequest)redirectRequest, bodyType);
                            redirectExchange.first((Object)HttpResponse.notFound()).subscribe((oHttpResponse, throwable) -> {
                                if (throwable != null) {
                                    emitter.tryOnError(throwable);
                                } else {
                                    emitter.onNext(oHttpResponse);
                                    emitter.onComplete();
                                }
                            });
                            if (fullResponse.refCnt() > 0) {
                                try {
                                    ReferenceCountUtil.release((Object)fullResponse);
                                }
                                catch (Throwable e) {
                                    if (!LOG.isDebugEnabled()) break block46;
                                    LOG.debug("Failed to release response: {}", (Object)fullResponse);
                                }
                            }
                        }
                        if (!HttpUtil.isKeepAlive((HttpMessage)fullResponse)) {
                            this.keepAlive = false;
                        }
                        pipeline.remove((ChannelHandler)this);
                        return;
                    }
                    try {
                        try {
                            if (statusCode == HttpStatus.NO_CONTENT.getCode()) {
                                headers.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                            }
                            boolean errorStatus = statusCode >= 400;
                            FullNettyClientHttpResponse response = new FullNettyClientHttpResponse(fullResponse, httpStatus, DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, bodyType, errorStatus);
                            if (!this.complete.compareAndSet(false, true)) break block47;
                            if (errorStatus) {
                                try {
                                    HttpClientResponseException clientError = errorType != HttpClient.DEFAULT_ERROR_TYPE ? new HttpClientResponseException(status.reasonPhrase(), null, response, new HttpClientErrorDecoder(){

                                        @Override
                                        public Argument<?> getErrorType(MediaType mediaType) {
                                            return errorType;
                                        }
                                    }) : new HttpClientResponseException(status.reasonPhrase(), response);
                                    try {
                                        emitter.tryOnError((Throwable)((Object)clientError));
                                        break block47;
                                    }
                                    finally {
                                        response.onComplete();
                                    }
                                }
                                catch (Throwable t) {
                                    if (t instanceof HttpClientResponseException) {
                                        try {
                                            emitter.tryOnError(t);
                                            break block47;
                                        }
                                        finally {
                                            response.onComplete();
                                        }
                                    }
                                    response.onComplete();
                                    FullNettyClientHttpResponse errorResponse = new FullNettyClientHttpResponse(fullResponse, httpStatus, DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, null, true);
                                    errorResponse.onComplete();
                                    HttpClientResponseException clientResponseError = new HttpClientResponseException("Error decoding HTTP error response body: " + t.getMessage(), t, errorResponse, null);
                                    emitter.tryOnError((Throwable)((Object)clientResponseError));
                                }
                                break block47;
                            }
                            emitter.onNext(response);
                            response.onComplete();
                            emitter.onComplete();
                        }
                        catch (Throwable t) {
                            if (this.complete.compareAndSet(false, true)) {
                                if (t instanceof HttpClientResponseException) {
                                    emitter.tryOnError(t);
                                    break block47;
                                }
                                FullNettyClientHttpResponse response = new FullNettyClientHttpResponse(fullResponse, httpStatus, DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, null, true);
                                HttpClientResponseException clientResponseError = new HttpClientResponseException("Error decoding HTTP response body: " + t.getMessage(), t, response, new HttpClientErrorDecoder(){

                                    @Override
                                    public Argument<?> getErrorType(MediaType mediaType) {
                                        return errorType;
                                    }
                                });
                                try {
                                    emitter.tryOnError((Throwable)((Object)clientResponseError));
                                    break block47;
                                }
                                finally {
                                    response.onComplete();
                                }
                            }
                            if (LOG.isWarnEnabled()) {
                                LOG.warn("Exception fired after handler completed: " + t.getMessage(), t);
                            }
                        }
                    }
                    finally {
                        block48: {
                            if (fullResponse.refCnt() > 0) {
                                try {
                                    ReferenceCountUtil.release((Object)fullResponse);
                                }
                                catch (Throwable e) {
                                    if (!LOG.isDebugEnabled()) break block48;
                                    LOG.debug("Failed to release response: {}", (Object)fullResponse);
                                }
                            }
                        }
                        if (!HttpUtil.isKeepAlive((HttpMessage)fullResponse)) {
                            this.keepAlive = false;
                        }
                        pipeline.remove((ChannelHandler)this);
                    }
                }
            }

            public void handlerRemoved(ChannelHandlerContext ctx) {
                if (channelPool != null) {
                    Channel ch = ctx.channel();
                    if (!this.keepAlive) {
                        ch.closeFuture().addListener(future -> channelPool.release(ch));
                    } else {
                        channelPool.release(ch);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                try {
                    if (this.complete.compareAndSet(false, true)) {
                        String message = cause.getMessage();
                        if (message == null) {
                            message = cause.getClass().getSimpleName();
                        }
                        if (DefaultHttpClient.this.log.isTraceEnabled()) {
                            DefaultHttpClient.this.log.trace("HTTP Client exception ({}) occurred for request : {} {}", new Object[]{message, request.getMethod(), request.getUri()});
                        }
                        if (cause instanceof TooLongFrameException) {
                            emitter.tryOnError((Throwable)((Object)new ContentLengthExceededException(DefaultHttpClient.this.configuration.getMaxContentLength())));
                        } else if (cause instanceof io.netty.handler.timeout.ReadTimeoutException) {
                            emitter.tryOnError((Throwable)((Object)ReadTimeoutException.TIMEOUT_EXCEPTION));
                        } else {
                            emitter.tryOnError((Throwable)((Object)new HttpClientException("Error occurred reading HTTP response: " + message, cause)));
                        }
                    }
                }
                finally {
                    this.keepAlive = false;
                    pipeline.remove((ChannelHandler)this);
                }
            }
        };
        pipeline.addLast(HANDLER_MICRONAUT_FULL_HTTP_RESPONSE, (ChannelHandler)newHandler);
        if (this.readTimeoutMillis != null) {
            pipeline.addBefore(HANDLER_HTTP_CLIENT_CODEC, HANDLER_READ_TIMEOUT, (ChannelHandler)new ReadTimeoutHandler(this.readTimeoutMillis.longValue(), TimeUnit.MILLISECONDS));
        }
    }

    private void setRedirectHeaders(@Nullable io.netty.handler.codec.http.HttpRequest request, MutableHttpRequest<Object> redirectRequest) {
        if (request != null) {
            request.headers().forEach(header -> redirectRequest.header((CharSequence)header.getKey(), (CharSequence)header.getValue()));
        }
    }

    private void setRedirectHeaders(@Nullable HttpRequest<?> request, MutableHttpRequest<Object> redirectRequest) {
        if (request != null) {
            for (Map.Entry originalHeader : request.getHeaders()) {
                List originalHeaderValue = (List)originalHeader.getValue();
                if (originalHeaderValue == null || originalHeaderValue.isEmpty()) continue;
                for (String value : originalHeaderValue) {
                    if (value == null) continue;
                    redirectRequest.header((CharSequence)originalHeader.getKey(), (CharSequence)value);
                }
            }
        }
    }

    private ClientFilterChain buildChain(final AtomicReference<HttpRequest> requestWrapper, final List<HttpClientFilter> filters) {
        final AtomicInteger integer = new AtomicInteger();
        final int len = filters.size();
        return new ClientFilterChain(){

            public Publisher<? extends HttpResponse<?>> proceed(MutableHttpRequest<?> request) {
                int pos = integer.incrementAndGet();
                if (pos > len) {
                    throw new IllegalStateException("The FilterChain.proceed(..) method should be invoked exactly once per filter execution. The method has instead been invoked multiple times by an erroneous filter definition.");
                }
                HttpClientFilter httpFilter = (HttpClientFilter)filters.get(pos);
                return httpFilter.doFilter((HttpRequest)requestWrapper.getAndSet(request), (FilterChain)this);
            }
        };
    }

    private HttpPostRequestEncoder buildFormDataRequest(NettyClientHttpRequest clientHttpRequest, Object bodyValue) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        HttpPostRequestEncoder postRequestEncoder = new HttpPostRequestEncoder(clientHttpRequest.getFullRequest(null), false);
        Map formData = bodyValue instanceof Map ? (Map)bodyValue : BeanMap.of((Object)bodyValue);
        for (Map.Entry entry : formData.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object val : collection) {
                    this.addBodyAttribute(postRequestEncoder, (String)entry.getKey(), val);
                }
                continue;
            }
            this.addBodyAttribute(postRequestEncoder, (String)entry.getKey(), value);
        }
        return postRequestEncoder;
    }

    private void addBodyAttribute(HttpPostRequestEncoder postRequestEncoder, String key, Object value) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        Optional converted = ConversionService.SHARED.convert(value, String.class);
        if (converted.isPresent()) {
            postRequestEncoder.addBodyAttribute(key, (String)converted.get());
        }
    }

    private HttpPostRequestEncoder buildMultipartRequest(NettyClientHttpRequest clientHttpRequest, Object bodyValue) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(16384L);
        io.netty.handler.codec.http.HttpRequest request = clientHttpRequest.getFullRequest(null);
        HttpPostRequestEncoder postRequestEncoder = new HttpPostRequestEncoder((HttpDataFactory)factory, request, true, CharsetUtil.UTF_8, HttpPostRequestEncoder.EncoderMode.HTML5);
        if (bodyValue instanceof MultipartBody.Builder) {
            bodyValue = ((MultipartBody.Builder)bodyValue).build();
        }
        if (!(bodyValue instanceof MultipartBody)) {
            throw new MultipartException(String.format("The type %s is not a supported type for a multipart request body", bodyValue.getClass().getName()));
        }
        postRequestEncoder.setBodyHttpDatas(((MultipartBody)bodyValue).getData(request, (HttpDataFactory)factory));
        return postRequestEncoder;
    }

    private void traceRequest(HttpRequest<?> request, io.netty.handler.codec.http.HttpRequest nettyRequest) {
        HttpHeaders headers = nettyRequest.headers();
        this.traceHeaders(headers);
        if (HttpMethod.permitsRequestBody((HttpMethod)request.getMethod()) && request.getBody().isPresent() && nettyRequest instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyRequest;
            ByteBuf content = fullHttpRequest.content();
            if (this.log.isTraceEnabled()) {
                this.traceBody("Request", content);
            }
        }
    }

    private void traceBody(String type, ByteBuf content) {
        this.log.trace(type + " Body");
        this.log.trace("----");
        this.log.trace(content.toString(this.defaultCharset));
        this.log.trace("----");
    }

    private void traceChunk(ByteBuf content) {
        this.log.trace("Sending Chunk");
        this.log.trace("----");
        this.log.trace(content.toString(this.defaultCharset));
        this.log.trace("----");
    }

    private void traceHeaders(HttpHeaders headers) {
        for (String name : headers.names()) {
            List all = headers.getAll(name);
            if (all.size() > 1) {
                for (String value : all) {
                    this.log.trace("{}: {}", (Object)name, (Object)value);
                }
                continue;
            }
            if (all.isEmpty()) continue;
            this.log.trace("{}: {}", (Object)name, all.get(0));
        }
    }

    private static MediaTypeCodecRegistry createDefaultMediaTypeRegistry() {
        ObjectMapper objectMapper = new ObjectMapperFactory().objectMapper(null, null);
        ApplicationConfiguration applicationConfiguration = new ApplicationConfiguration();
        return MediaTypeCodecRegistry.of((MediaTypeCodec[])new MediaTypeCodec[]{new JsonMediaTypeCodec(objectMapper, applicationConfiguration, null), new JsonStreamMediaTypeCodec(objectMapper, applicationConfiguration, null)});
    }

    private <I> NettyRequestWriter prepareRequest(HttpRequest<I> request, URI requestURI) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        MediaType requestContentType = request.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)request.getMethod());
        NettyClientHttpRequest clientHttpRequest = (NettyClientHttpRequest)request;
        NettyRequestWriter requestWriter = this.buildNettyRequest(clientHttpRequest, requestURI, requestContentType, permitsBody);
        io.netty.handler.codec.http.HttpRequest nettyRequest = requestWriter.getNettyRequest();
        this.prepareHttpHeaders(requestURI, request, nettyRequest, permitsBody, true);
        return requestWriter;
    }

    private Disposable buildDisposableChannel(final ChannelFuture channelFuture) {
        return new Disposable(){
            boolean disposed = false;

            public void dispose() {
                if (!this.disposed) {
                    Channel channel = channelFuture.channel();
                    if (channel.isOpen()) {
                        DefaultHttpClient.this.closeChannelAsync(channel);
                    }
                    this.disposed = true;
                }
            }

            public boolean isDisposed() {
                return this.disposed;
            }
        };
    }

    private AbstractChannelPoolHandler newPoolHandler(final RequestKey key) {
        return new AbstractChannelPoolHandler(){

            public void channelCreated(Channel ch) {
                ch.pipeline().addLast(DefaultHttpClient.HANDLER_HTTP_CLIENT_INIT, (ChannelHandler)new HttpClientInitializer(key.isSecure() ? DefaultHttpClient.this.sslContext : null, key.getHost(), key.getPort(), false, false){

                    @Override
                    protected void addFinalHandler(ChannelPipeline pipeline) {
                    }
                });
                if (DefaultHttpClient.this.connectionTimeAliveMillis != null) {
                    ch.pipeline().addLast(DefaultHttpClient.HANDLER_CONNECT_TTL, (ChannelHandler)new ConnectTTLHandler(DefaultHttpClient.this.connectionTimeAliveMillis));
                }
            }

            public void channelReleased(Channel ch) {
                ChannelPipeline pipeline;
                boolean shouldCloseOnRelease;
                if (DefaultHttpClient.this.connectionTimeAliveMillis != null && (shouldCloseOnRelease = Boolean.TRUE.equals(ch.attr(ConnectTTLHandler.RELEASE_CHANNEL).get())) && ch.isOpen() && !ch.eventLoop().isShuttingDown()) {
                    ch.close();
                }
                if (DefaultHttpClient.this.readTimeoutMillis != null && (pipeline = ch.pipeline()).context(DefaultHttpClient.HANDLER_READ_TIMEOUT) != null) {
                    pipeline.remove(DefaultHttpClient.HANDLER_READ_TIMEOUT);
                }
            }
        };
    }

    private class CurrentEvent {
        final CompositeByteBuf data;
        String id;
        String name;
        Duration retry;

        CurrentEvent(CompositeByteBuf data) {
            this.data = data;
        }
    }

    protected class NettyRequestWriter {
        private final io.netty.handler.codec.http.HttpRequest nettyRequest;
        private final HttpPostRequestEncoder encoder;

        NettyRequestWriter(io.netty.handler.codec.http.HttpRequest nettyRequest, HttpPostRequestEncoder encoder) {
            this.nettyRequest = nettyRequest;
            this.encoder = encoder;
        }

        protected void writeAndClose(Channel channel, ChannelPool channelPool, FlowableEmitter<?> emitter) {
            ChannelFuture channelFuture;
            if (this.encoder != null && this.encoder.isChunked()) {
                channel.pipeline().replace(DefaultHttpClient.HANDLER_STREAM, DefaultHttpClient.HANDLER_CHUNK, (ChannelHandler)new ChunkedWriteHandler());
                channel.write((Object)this.nettyRequest);
                channelFuture = channel.writeAndFlush((Object)this.encoder);
            } else {
                channelFuture = channel.writeAndFlush((Object)this.nettyRequest);
            }
            if (channelPool == null) {
                this.closeChannel(channel, emitter, channelFuture);
            }
        }

        private void closeChannel(Channel channel, FlowableEmitter<?> emitter, ChannelFuture channelFuture) {
            channelFuture.addListener(f -> {
                try {
                    if (!f.isSuccess()) {
                        if (!emitter.isCancelled()) {
                            emitter.onError(f.cause());
                        }
                    } else {
                        channel.read();
                    }
                }
                finally {
                    if (this.encoder != null) {
                        this.encoder.cleanFiles();
                    }
                    DefaultHttpClient.this.closeChannelAsync(channel);
                }
            });
        }

        io.netty.handler.codec.http.HttpRequest getNettyRequest() {
            return this.nettyRequest;
        }
    }

    private final class RequestKey {
        private final String host;
        private final int port;
        private final boolean secure;

        public RequestKey(URI requestURI) {
            int port;
            this.secure = "https".equalsIgnoreCase(requestURI.getScheme());
            String host = requestURI.getHost();
            if (host == null) {
                host = requestURI.getAuthority();
                if (host == null) {
                    throw new HttpClientException("URI specifies no host to connect to");
                }
                int i = host.indexOf(58);
                if (i > -1) {
                    String portStr = host.substring(i + 1);
                    host = host.substring(0, i);
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        throw new HttpClientException("URI specifies an invalid port: " + portStr);
                    }
                } else {
                    port = requestURI.getPort() > -1 ? requestURI.getPort() : (this.secure ? 443 : 80);
                }
            } else {
                port = requestURI.getPort() > -1 ? requestURI.getPort() : (this.secure ? 443 : 80);
            }
            this.host = host;
            this.port = port;
        }

        public InetSocketAddress getRemoteAddress() {
            return InetSocketAddress.createUnresolved(this.host, this.port);
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestKey that = (RequestKey)o;
            return this.port == that.port && this.secure == that.secure && Objects.equals(this.host, that.host);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port, this.secure);
        }
    }

    protected class HttpClientInitializer
    extends ChannelInitializer<Channel> {
        final SslContext sslContext;
        final String host;
        final int port;
        final boolean stream;
        final boolean acceptsEvents;

        protected HttpClientInitializer(SslContext sslContext, String host, int port, boolean stream, boolean acceptsEvents) {
            this.sslContext = sslContext;
            this.stream = stream;
            this.host = host;
            this.port = port;
            this.acceptsEvents = acceptsEvents;
        }

        protected void initChannel(Channel ch) {
            Duration duration;
            Optional<Duration> readIdleTime;
            Proxy proxy;
            ChannelPipeline p = ch.pipeline();
            if (this.stream) {
                ch.config().setAutoRead(false);
            }
            if (!Proxy.NO_PROXY.equals(proxy = DefaultHttpClient.this.configuration.resolveProxy(this.sslContext != null, this.host, this.port))) {
                DefaultHttpClient.this.configureProxy(p, proxy);
            }
            if (this.sslContext != null) {
                SslHandler sslHandler = this.sslContext.newHandler(ch.alloc(), this.host, this.port);
                p.addLast(DefaultHttpClient.HANDLER_SSL, (ChannelHandler)sslHandler);
            }
            if (DefaultHttpClient.this.poolMap == null && this.stream && DefaultHttpClient.this.readTimeoutMillis == null && (readIdleTime = DefaultHttpClient.this.configuration.getReadIdleTimeout()).isPresent() && !(duration = readIdleTime.get()).isNegative()) {
                p.addLast(DefaultHttpClient.HANDLER_IDLE_STATE, (ChannelHandler)new IdleStateHandler(duration.toMillis(), duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS));
            }
            p.addLast(DefaultHttpClient.HANDLER_HTTP_CLIENT_CODEC, (ChannelHandler)new HttpClientCodec());
            p.addLast(DefaultHttpClient.HANDLER_DECODER, (ChannelHandler)new HttpContentDecompressor());
            int maxContentLength = DefaultHttpClient.this.configuration.getMaxContentLength();
            if (!this.stream) {
                p.addLast(DefaultHttpClient.HANDLER_AGGREGATOR, (ChannelHandler)new HttpObjectAggregator(maxContentLength){

                    protected void finishAggregation(FullHttpMessage aggregated) throws Exception {
                        if (!HttpUtil.isContentLengthSet((HttpMessage)aggregated) && aggregated.content().readableBytes() > 0) {
                            super.finishAggregation(aggregated);
                        }
                    }
                });
            }
            if (this.acceptsEventStream()) {
                p.addLast(DefaultHttpClient.HANDLER_MICRONAUT_SSE_EVENT_STREAM, (ChannelHandler)new SimpleChannelInboundHandler<HttpContent>(){
                    LineBasedFrameDecoder decoder;
                    {
                        this.decoder = new LineBasedFrameDecoder(DefaultHttpClient.this.configuration.getMaxContentLength(), true, true);
                    }

                    public boolean acceptInboundMessage(Object msg) {
                        return msg instanceof HttpContent && !(msg instanceof LastHttpContent);
                    }

                    protected void channelRead0(ChannelHandlerContext ctx, HttpContent msg) throws Exception {
                        ByteBuf content = msg.content();
                        this.decoder.channelRead(ctx, (Object)content);
                    }
                });
                p.addLast(DefaultHttpClient.HANDLER_MICRONAUT_SSE_CONTENT, (ChannelHandler)new SimpleChannelInboundHandler<ByteBuf>(false){

                    public boolean acceptInboundMessage(Object msg) {
                        return msg instanceof ByteBuf;
                    }

                    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
                        ctx.fireChannelRead((Object)new DefaultHttpContent(msg));
                    }
                });
            }
            this.addFinalHandler(p);
        }

        protected void addFinalHandler(ChannelPipeline pipeline) {
            pipeline.addLast(DefaultHttpClient.HANDLER_STREAM, (ChannelHandler)new HttpStreamsClientHandler(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (evt instanceof IdleStateEvent) {
                        ctx.close();
                    } else {
                        super.userEventTriggered(ctx, evt);
                    }
                }
            });
        }

        private boolean acceptsEventStream() {
            return this.acceptsEvents;
        }
    }
}

