/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import java.util.Optional;

@Internal
class NettyStreamedHttpResponse<B>
implements HttpResponse<B> {
    private final StreamedHttpResponse nettyResponse;
    private final HttpStatus status;
    private final NettyHttpHeaders headers;
    private B body;
    private MutableConvertibleValues<Object> attributes;

    NettyStreamedHttpResponse(StreamedHttpResponse response, HttpStatus httpStatus) {
        this.nettyResponse = response;
        this.status = httpStatus;
        this.headers = new NettyHttpHeaders(response.headers(), ConversionService.SHARED);
    }

    public StreamedHttpResponse getNettyResponse() {
        return this.nettyResponse;
    }

    public String reason() {
        return this.nettyResponse.status().reasonPhrase();
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap attributes = this.attributes;
        if (attributes == null) {
            NettyStreamedHttpResponse nettyStreamedHttpResponse = this;
            synchronized (nettyStreamedHttpResponse) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = new MutableConvertibleValuesMap();
                }
            }
        }
        return attributes;
    }

    public void setBody(B body) {
        this.body = body;
    }

    public Optional<B> getBody() {
        return Optional.ofNullable(this.body);
    }
}

