/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.subscriber.Completable;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.client.netty.DefaultHttpClient;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.cookies.NettyCookies;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.FullHttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class FullNettyClientHttpResponse<B>
implements HttpResponse<B>,
Completable,
NettyHttpResponseBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpClient.class);
    private final HttpStatus status;
    private final NettyHttpHeaders headers;
    private final NettyCookies nettyCookies;
    private final MutableConvertibleValues<Object> attributes;
    private final FullHttpResponse nettyHttpResponse;
    private final Map<Argument, Optional> convertedBodies = new HashMap<Argument, Optional>();
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    private final ByteBufferFactory<ByteBufAllocator, ByteBuf> byteBufferFactory;
    private final B body;
    private boolean complete;
    private byte[] bodyBytes;

    FullNettyClientHttpResponse(FullHttpResponse fullHttpResponse, HttpStatus httpStatus, MediaTypeCodecRegistry mediaTypeCodecRegistry, ByteBufferFactory<ByteBufAllocator, ByteBuf> byteBufferFactory, Argument<B> bodyType, boolean convertBody) {
        Class rawBodyType;
        this.status = httpStatus;
        this.headers = new NettyHttpHeaders(fullHttpResponse.headers(), ConversionService.SHARED);
        this.attributes = new MutableConvertibleValuesMap();
        this.nettyHttpResponse = fullHttpResponse;
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.byteBufferFactory = byteBufferFactory;
        this.nettyCookies = new NettyCookies(fullHttpResponse.headers(), ConversionService.SHARED);
        Class clazz = rawBodyType = bodyType != null ? bodyType.getType() : null;
        if (rawBodyType != null && !HttpStatus.class.isAssignableFrom(rawBodyType)) {
            if (HttpResponse.class.isAssignableFrom(bodyType.getType())) {
                Optional responseBodyType = bodyType.getFirstTypeVariable();
                if (responseBodyType.isPresent()) {
                    Argument finalResponseBodyType = (Argument)responseBodyType.get();
                    this.body = convertBody || this.isParseableBodyType(finalResponseBodyType.getType()) ? this.getBody(finalResponseBodyType).orElse(null) : null;
                } else {
                    this.body = null;
                }
            } else {
                this.body = convertBody || this.isParseableBodyType(rawBodyType) ? this.getBody(bodyType).orElse(null) : null;
            }
        } else {
            this.body = null;
        }
    }

    public String reason() {
        return this.nettyHttpResponse.status().reasonPhrase();
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Cookies getCookies() {
        return this.nettyCookies;
    }

    public Optional<Cookie> getCookie(String name) {
        return this.nettyCookies.findCookie((CharSequence)name);
    }

    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    public Optional<B> getBody() {
        return Optional.ofNullable(this.body);
    }

    public <T> Optional<T> getBody(Class<T> type) {
        if (type == null) {
            return Optional.empty();
        }
        return this.getBody(Argument.of(type));
    }

    public FullHttpResponse getNativeResponse() {
        return this.nettyHttpResponse;
    }

    public <T> Optional<T> getBody(Argument<T> type) {
        if (type == null) {
            return Optional.empty();
        }
        Class javaType = type.getType();
        if (javaType == Void.TYPE) {
            return Optional.empty();
        }
        if (javaType == ByteBuffer.class) {
            return Optional.of(this.byteBufferFactory.wrap((Object)this.nettyHttpResponse.content()));
        }
        if (javaType == ByteBuf.class) {
            return Optional.of(this.nettyHttpResponse.content());
        }
        if (javaType == byte[].class && this.bodyBytes != null) {
            return Optional.of(this.bodyBytes);
        }
        Optional result = this.convertedBodies.computeIfAbsent(type, argument -> {
            Optional converted;
            boolean isOptional = argument.getType() == Optional.class;
            Argument finalArgument = isOptional ? argument.getFirstTypeVariable().orElse(argument) : argument;
            try {
                if (this.bodyBytes != null) {
                    return this.convertBytes(this.bodyBytes, finalArgument);
                }
                Optional<B> existing = this.getBody();
                if (existing.isPresent()) {
                    converted = this.getBody().flatMap(b -> {
                        if (b instanceof ByteBuffer) {
                            ByteBuf bytebuf = (ByteBuf)((ByteBuffer)b).asNativeBuffer();
                            return this.convertByteBuf(bytebuf, finalArgument);
                        }
                        Optional opt = ConversionService.SHARED.convert(b, ConversionContext.of((Argument)finalArgument));
                        if (!opt.isPresent()) {
                            ByteBuf content = this.nettyHttpResponse.content();
                            return this.convertByteBuf(content, finalArgument);
                        }
                        return opt;
                    });
                } else {
                    ByteBuf content = this.nettyHttpResponse.content();
                    converted = this.convertByteBuf(content, finalArgument);
                }
            }
            catch (RuntimeException e) {
                if (this.status.getCode() < 400) {
                    throw e;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error decoding HTTP error response body: " + e.getMessage(), (Throwable)e);
                }
                converted = Optional.empty();
            }
            if (isOptional) {
                return Optional.of(converted);
            }
            return converted;
        });
        if (LOG.isTraceEnabled() && !result.isPresent()) {
            LOG.trace("Unable to convert response body to target type {}", (Object)javaType);
        }
        return result;
    }

    private boolean isParseableBodyType(Class<?> rawBodyType) {
        return CharSequence.class.isAssignableFrom(rawBodyType) || Map.class.isAssignableFrom(rawBodyType);
    }

    private <T> Optional convertByteBuf(ByteBuf content, Argument<T> type) {
        if (this.complete) {
            return Optional.empty();
        }
        if (content.refCnt() == 0 || content.readableBytes() == 0) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Full HTTP response received an empty body");
            }
            if (!this.convertedBodies.isEmpty()) {
                for (Map.Entry<Argument, Optional> entry : this.convertedBodies.entrySet()) {
                    Argument existing = entry.getKey();
                    if (!type.getType().isAssignableFrom(existing.getType())) continue;
                    return entry.getValue();
                }
            }
            return Optional.empty();
        }
        Optional contentType = this.getContentType();
        if (contentType.isPresent()) {
            if (this.mediaTypeCodecRegistry != null) {
                this.bodyBytes = ByteBufUtil.getBytes((ByteBuf)content);
                if (CharSequence.class.isAssignableFrom(type.getType())) {
                    Charset charset = contentType.flatMap(MediaType::getCharset).orElse(StandardCharsets.UTF_8);
                    return Optional.of(new String(this.bodyBytes, charset));
                }
                if (type.getType() == byte[].class) {
                    return Optional.of(this.bodyBytes);
                }
                Optional foundCodec = this.mediaTypeCodecRegistry.findCodec((MediaType)contentType.get());
                if (foundCodec.isPresent()) {
                    MediaTypeCodec codec = (MediaTypeCodec)foundCodec.get();
                    return Optional.of(codec.decode(type, this.bodyBytes));
                }
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Missing or unknown Content-Type received from server.");
        }
        return ConversionService.SHARED.convert((Object)content, ConversionContext.of(type));
    }

    private <T> Optional convertBytes(byte[] bytes, Argument<T> type) {
        Optional contentType = this.getContentType();
        boolean hasContentType = contentType.isPresent();
        if (this.mediaTypeCodecRegistry != null && hasContentType) {
            if (CharSequence.class.isAssignableFrom(type.getType())) {
                Charset charset = contentType.flatMap(MediaType::getCharset).orElse(StandardCharsets.UTF_8);
                return Optional.of(new String(bytes, charset));
            }
            if (type.getType() == byte[].class) {
                return Optional.of(bytes);
            }
            Optional foundCodec = this.mediaTypeCodecRegistry.findCodec((MediaType)contentType.get());
            if (foundCodec.isPresent()) {
                MediaTypeCodec codec = (MediaTypeCodec)foundCodec.get();
                return Optional.of(codec.decode(type, bytes));
            }
        }
        return ConversionService.SHARED.convert((Object)bytes, ConversionContext.of(type));
    }

    public void onComplete() {
        this.complete = true;
    }

    @NonNull
    public FullHttpResponse toFullHttpResponse() {
        return this.nettyHttpResponse;
    }

    @NonNull
    public io.netty.handler.codec.http.HttpResponse toHttpResponse() {
        return this.nettyHttpResponse;
    }

    public boolean isStream() {
        return false;
    }
}

