/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.micronaut.http.netty.cookies.NettyCookies;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.util.Optional;

@Internal
class NettyStreamedHttpResponse<B>
implements MutableHttpResponse<B>,
NettyHttpResponseBuilder {
    private final StreamedHttpResponse nettyResponse;
    private final NettyHttpHeaders headers;
    @GuardedBy(value="this")
    private NettyCookies nettyCookies;
    private B body;
    private MutableConvertibleValues<Object> attributes;

    NettyStreamedHttpResponse(StreamedHttpResponse response, ConversionService conversionService) {
        this.nettyResponse = response;
        this.headers = new NettyHttpHeaders(response.headers(), conversionService);
    }

    public StreamedHttpResponse getNettyResponse() {
        return this.nettyResponse;
    }

    public int code() {
        return this.nettyResponse.status().code();
    }

    public String reason() {
        return this.nettyResponse.status().reasonPhrase();
    }

    public MutableHttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap mcv = this.attributes;
        if (mcv == null) {
            NettyStreamedHttpResponse nettyStreamedHttpResponse = this;
            synchronized (nettyStreamedHttpResponse) {
                mcv = this.attributes;
                if (mcv == null) {
                    this.attributes = mcv = new MutableConvertibleValuesMap();
                }
            }
        }
        return mcv;
    }

    public void setBody(B body) {
        this.body = body;
    }

    public Optional<B> getBody() {
        return Optional.ofNullable(this.body);
    }

    @NonNull
    public FullHttpResponse toFullHttpResponse() {
        throw new UnsupportedOperationException("Cannot convert a stream response to a full response");
    }

    @NonNull
    public StreamedHttpResponse toStreamHttpResponse() {
        return this.nettyResponse;
    }

    @NonNull
    public HttpResponse toHttpResponse() {
        return this.nettyResponse;
    }

    public boolean isStream() {
        return true;
    }

    public synchronized MutableHttpResponse<B> cookie(Cookie cookie) {
        if (!(cookie instanceof NettyCookie)) {
            throw new IllegalArgumentException("Argument is not a Netty compatible Cookie");
        }
        NettyCookie nettyCookie = (NettyCookie)cookie;
        String value = ServerCookieEncoder.STRICT.encode(nettyCookie.getNettyCookie());
        this.headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, (CharSequence)value);
        this.nettyCookies = null;
        return this;
    }

    public synchronized Cookies getCookies() {
        if (this.nettyCookies == null) {
            this.nettyCookies = new NettyCookies(this.nettyResponse.headers(), ConversionService.SHARED);
        }
        return this.nettyCookies;
    }

    public Optional<Cookie> getCookie(String name) {
        return this.getCookies().findCookie((CharSequence)name);
    }

    public <T> MutableHttpResponse<T> body(@Nullable T body) {
        this.body = body;
        return this;
    }

    public MutableHttpResponse<B> status(int status, CharSequence message) {
        if (message == null) {
            this.nettyResponse.setStatus(HttpResponseStatus.valueOf((int)status));
        } else {
            this.nettyResponse.setStatus(HttpResponseStatus.valueOf((int)status, (String)message.toString()));
        }
        return this;
    }
}

